/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import common.geom.Trig;
import inferno.data2.CylinderShape;
import inferno.data2.IAgentBodyShape;
import inferno.data2.OccLocator;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.geom.Inter;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.VehicleBody;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;

public class PolygonShape
implements IAgentBodyShape {
    private static final long serialVersionUID = 1L;
    private static final double MIN_TURNAROUND_TIME = 3.0;
    public final VehicleBody vehicleBody;
    public final int occId;
    private Point3d center;
    private Point3d[] points;
    private List<TriPoint> visPoints;
    private Vector3d dir;
    private double width;
    private double length;
    private double distToFront;
    private double enclosingRadius;

    public PolygonShape(Point3d center, Vector3d dir, int occId, VehicleBody vehicleBody) {
        this(center, PolygonShape.getUpdatedPoints(center, dir, vehicleBody.innerPoints), dir, occId, vehicleBody, vehicleBody.length, vehicleBody.width, vehicleBody.distToFrontInner);
    }

    public PolygonShape(Point3d center, Point3d[] points, Vector3d dir, int occId, VehicleBody vehicleBody, boolean outerPoints) {
        this(center, points, dir, occId, vehicleBody, outerPoints ? vehicleBody.outerLength : vehicleBody.length, outerPoints ? vehicleBody.outerWidth : vehicleBody.width, outerPoints ? vehicleBody.distToFrontOuter : vehicleBody.distToFrontInner);
    }

    public PolygonShape(Point3d center, Point3d[] points, Vector3d dir, int occId, VehicleBody vehicleBody, double newLength, double newWidth, double distToFront) {
        this.dir = dir;
        this.occId = occId;
        this.vehicleBody = vehicleBody;
        this.center = new Point3d(center);
        this.points = points;
        this.length = newLength;
        this.width = newWidth;
        this.distToFront = distToFront;
        this.markPointsDirty();
    }

    public static double calcWidth(Point3d pivot, Vector3d orient, Point3d[] points) {
        return PolygonShape.calcLength(pivot, new Vector3d(-orient.y, orient.x, 0.0), points);
    }

    public static double calcLength(Point3d pivot, Vector3d orient, Point3d[] points) {
        Vector3d dir = new Vector3d(orient.x, orient.y, 0.0);
        Util3D.safeNormalize(dir, 1.0E-6);
        double minDist = Double.POSITIVE_INFINITY;
        double maxDist = Double.NEGATIVE_INFINITY;
        Vector3d pdir = new Vector3d();
        for (int m = 1; m < points.length; ++m) {
            Point3d p = points[m];
            pdir.sub(p, points[0]);
            double dist = pdir.dot(dir);
            if (dist > maxDist) {
                maxDist = dist;
            }
            if (!(dist < minDist)) continue;
            minDist = dist;
        }
        return Math.abs(maxDist - minDist);
    }

    @Override
    public String getName() {
        return this.vehicleBody.name;
    }

    @Override
    public double getProjectedArea() {
        return this.vehicleBody.area;
    }

    @Override
    public double getDistToFront() {
        return this.distToFront;
    }

    @Override
    public Point3d getCenter() {
        return this.center;
    }

    public Point3d[] getPoints() {
        return this.points;
    }

    public void update(Point3d center, Point3d[] points, Vector3d dir, boolean useOuterPoints) {
        this.center = center;
        this.points = points;
        this.dir = dir;
        this.length = useOuterPoints ? this.vehicleBody.outerLength : this.vehicleBody.length;
        this.width = useOuterPoints ? this.vehicleBody.outerWidth : this.vehicleBody.width;
        this.markPointsDirty();
    }

    @Override
    public AABox getAABox3D() {
        return new AABox(this.get3DPoints());
    }

    private Point3d[] get3DPoints() {
        ArrayList<Point3d> points3d = new ArrayList<Point3d>();
        for (Point3d p : this.points) {
            points3d.add(p);
        }
        for (Point3d p : this.points) {
            points3d.add(new Point3d(p.x, p.y, p.z + this.vehicleBody.height));
        }
        return points3d.toArray(new Point3d[points3d.size()]);
    }

    @Override
    public Point3d[] getAABox2DVerts() {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double z = this.points[0].z;
        for (Point3d p : this.points) {
            if (p.x < minx) {
                minx = p.x;
            }
            if (p.x > maxx) {
                maxx = p.x;
            }
            if (p.y < miny) {
                miny = p.y;
            }
            if (!(p.y > maxy)) continue;
            maxy = p.y;
        }
        Point3d[] box = new Point3d[]{new Point3d(minx, miny, z), new Point3d(maxx, miny, z), new Point3d(maxx, maxy, z), new Point3d(minx, maxy, z)};
        return box;
    }

    public AABox getBigAABox() {
        double enclRad = this.getEnclosingRadius();
        double minx = this.center.x - enclRad;
        double miny = this.center.y - enclRad;
        double maxx = this.center.x + enclRad;
        double maxy = this.center.y + enclRad;
        return new AABox(minx, miny, this.center.z, maxx, maxy, this.center.z);
    }

    private ITest<AABox> getExtendedAABox(double extend) {
        return this.getExtendedShape(extend).getAABox3D();
    }

    @Override
    public boolean contains2d(Point3d p) {
        if (this.points.length == 0) {
            return false;
        }
        if (p.z != this.points[0].z) {
            p = new Point3d(p.x, p.y, this.points[0].z);
        }
        return Inter3D.classifyConvexPolyPoint((double)1.0E-6, (Point3d)p, (Point3d[])this.points).positive;
    }

    @Override
    public double getEnclosingRadius() {
        return this.enclosingRadius;
    }

    @Override
    public double getGeomRadius() {
        return this.vehicleBody.radiusUnattached;
    }

    @Override
    public double getOccRadius() {
        return this.vehicleBody.radiusUnattached;
    }

    private void markPointsDirty() {
        this.enclosingRadius = this.center.distance(this.points[this.vehicleBody.maxDistPoint]);
        this.visPoints = null;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public IAgentBodyShape adjust(double sizeFactor) {
        if (sizeFactor == 0.0) {
            return new CylinderShape(this.center, 0.0, this.getGeomRadius(), this.vehicleBody.height, this.dir, this.occId);
        }
        return this;
    }

    @Override
    public IAgentBodyShape adjust(Point3d pos, double sizeFactor) {
        if (sizeFactor == 0.0) {
            return new CylinderShape(pos, 0.0, this.getGeomRadius(), this.vehicleBody.height, this.dir, this.occId);
        }
        if (this.center.equals(pos)) {
            PolygonShape shape = new PolygonShape(pos, this.points, this.dir, this.occId, this.vehicleBody, this.length, this.width, this.distToFront);
            shape.visPoints = this.visPoints;
            return shape;
        }
        Vector3d move = Util3D.vector(this.center, pos);
        Point3d[] newPoints = new Point3d[this.points.length];
        for (int m = 0; m < this.points.length; ++m) {
            newPoints[m] = Util3D.add(this.points[m], (Tuple3d)move);
        }
        return new PolygonShape(pos, newPoints, this.dir, this.occId, this.vehicleBody, this.length, this.width, this.distToFront);
    }

    @Override
    public double getNearDist2d(Point3d p) {
        if (this.contains2d(p)) {
            return 0.0;
        }
        double nearDistSq = Double.MAX_VALUE;
        Point3d prev = this.points[this.points.length - 1];
        for (Point3d curr : this.points) {
            double distsq = Inter2D.distSqToNearestPtOnLineSeg(prev.x, prev.y, curr.x, curr.y, p.x, p.y);
            if (distsq < nearDistSq) {
                nearDistSq = distsq;
            }
            prev = curr;
        }
        return Math.sqrt(nearDistSq);
    }

    public PolygonShape translateToAndRotate(Point3d newPos, double angle) {
        Point3d newCenter = new Point3d(newPos);
        double dx = newPos.x - this.center.x;
        double dy = newPos.y - this.center.y;
        double dz = newPos.z - this.center.z;
        Point3d[] newPoints = new Point3d[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            Point3d p = new Point3d(this.points[i].x + dx, this.points[i].y + dy, this.points[i].z + dz);
            Inter.rotateTuple2D(p, angle, newCenter);
            newPoints[i] = p;
        }
        Point3d dirP = new Point3d(this.dir);
        Inter.rotateTuple2D(dirP, angle, new Point3d(0.0, 0.0, 0.0));
        PolygonShape ret = new PolygonShape(newCenter, newPoints, new Vector3d(dirP), this.occId, this.vehicleBody, this.length, this.width, this.distToFront);
        return ret;
    }

    public PolygonShape transform(Point3d newPos, Vector3d dir, boolean useOuterPoints) {
        return new PolygonShape(newPos, this.getUpdatedPoints(newPos, dir, useOuterPoints), dir, this.occId, this.vehicleBody, useOuterPoints);
    }

    public Point3d[] getUpdatedPoints(Point3d position, Vector3d direction, boolean useOuterPoints) {
        Point3d[] staticPoints = useOuterPoints ? this.vehicleBody.getStaticOuterPoints() : this.vehicleBody.getStaticInnerPoints();
        return PolygonShape.getUpdatedPoints(position, direction, staticPoints);
    }

    @Override
    public PolygonShape orientTo(Vector3d dir) {
        if (dir.equals(this.dir)) {
            return this;
        }
        double angle = Util2D.sAngle(this.dir.x, this.dir.y, dir.x, dir.y);
        Matrix4d xform = Util.translateMat(this.center.x, this.center.y, this.center.z);
        xform.mul(Util.rotMat(0.0, 0.0, 1.0, angle));
        xform.mul(Util.translateMat(-this.center.x, -this.center.y, -this.center.z));
        Point3d[] newPoints = new Point3d[this.points.length];
        for (int m = 0; m < this.points.length; ++m) {
            newPoints[m] = Util3D.xform(xform, this.points[m], true);
        }
        return new PolygonShape(this.center, newPoints, dir, this.occId, this.vehicleBody, this.length, this.width, this.distToFront);
    }

    @Override
    public Vector3d getDir() {
        return this.dir;
    }

    @Override
    public double getMinTurnaroundTime() {
        return 3.0;
    }

    @Override
    public boolean canRotate360(KB kb) {
        Collection<WingedEdge> testEdges = kb.getMesh().findEdges(this.getBigAABox(), new Predicate<WingedEdge>(){

            @Override
            public boolean test(WingedEdge t) {
                return t.isBoundary();
            }
        });
        for (WingedEdge e : testEdges) {
            if (!(Inter.nearDistToLineSeg(this.center, e.p1(), e.p2()) < this.getEnclosingRadius())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canTravel360() {
        return false;
    }

    public PolygonShape getExtendedShape(double extend) {
        Point3d[] extendedPoints = new Point3d[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            Vector3d v = Util3D.vector(this.center, this.points[i]);
            double length = v.length() + extend;
            v.normalize();
            v.scale(length);
            Point3d p = new Point3d(this.center);
            p.add(v);
            extendedPoints[i] = p;
        }
        return new PolygonShape(this.center, extendedPoints, this.dir, this.occId, this.vehicleBody, PolygonShape.calcLength(this.center, this.dir, extendedPoints), PolygonShape.calcWidth(this.center, this.dir, extendedPoints), this.distToFront + extend);
    }

    public boolean testCollisionAll(KB kb, double extend, Predicate<OccAgent> raisedPriorityFilter, OccAgent agent) {
        return this.testCollisionWalls(kb, extend) || this.testCollisionOccs(kb, extend, raisedPriorityFilter, agent);
    }

    public boolean testCollisionWalls(KB kb, double extend) {
        PolygonShape extendedShape = extend == 0.0 ? this : this.getExtendedShape(extend);
        Collection<WingedEdge> testEdges = kb.getMesh().findEdges(extendedShape.getAABox3D(), new Predicate<WingedEdge>(){

            @Override
            public boolean test(WingedEdge t) {
                return t.isBoundary();
            }
        });
        if (!testEdges.isEmpty()) {
            for (WingedEdge e : testEdges) {
                if (!Inter.isectLineSegPoly(e.p1(), e.p2(), extendedShape.points)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean testCollisionOccs(KB kb, double extend, Predicate<OccAgent> collisionFilter, OccAgent agent) {
        List<Object> nearOccs = new ArrayList();
        double r = this.getLength();
        Predicate<OccAgent> toExclude = collisionFilter.negate();
        nearOccs = kb.findOccs(OccLocator.testCyl(agent, r, new Plane3d[0]), Predicates.and(Filters.reject(agent), toExclude), false);
        for (OccAgent occAgent : nearOccs) {
            Vector3d vel;
            double isect;
            IAgentBodyShape shape = occAgent.getOcc().bodyShape;
            if (shape.getOccId() == this.occId || (isect = Inter.getOccCollision(this, vel = GeomConstants.VEC3D_ZERO, shape, vel, 0.0)) == Double.POSITIVE_INFINITY) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PolygonShape)) {
            return false;
        }
        PolygonShape other = (PolygonShape)o;
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i].equals(other.points[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getOccId() {
        return this.occId;
    }

    public Vector3d snapVelToOrient(Vector3d vel, double tolerance) {
        double angle = Trig.angle(this.dir, vel);
        Vector3d back = new Vector3d(this.dir);
        back.negate();
        double angleBack = Trig.angle(back, vel);
        Vector3d snap = new Vector3d();
        Vector3d orig = new Vector3d(0.0, 0.0, 0.0);
        if (Math.abs(angle) <= tolerance || Math.abs(angleBack) <= tolerance) {
            return vel;
        }
        if (angle > tolerance && angle <= 1.5707963267948966) {
            snap = new Vector3d(this.dir);
            Inter.rotateTuple2D(snap, tolerance, orig);
        } else if (angle > tolerance && angle > 1.5707963267948966) {
            snap = new Vector3d(back);
            Inter.rotateTuple2D(snap, -tolerance, orig);
        } else if (angle < -tolerance && angle >= -1.5707963267948966) {
            snap = new Vector3d(this.dir);
            Inter.rotateTuple2D(snap, -tolerance, orig);
        } else if (angle < -tolerance && angle < -1.5707963267948966) {
            snap = new Vector3d(back);
            Inter.rotateTuple2D(snap, tolerance, orig);
        }
        snap.normalize();
        snap.scale(vel.length());
        return snap;
    }

    public Vector3d snapVelToOrient(Vector3d vel) {
        double angle = Inter.angleAbs(this.dir, vel);
        double length = vel.length();
        Vector3d ret = new Vector3d(this.dir);
        ret.normalize();
        ret.scale(length);
        if (angle > 1.5707963267948966) {
            ret.negate();
        }
        return ret;
    }

    @Override
    public synchronized List<TriPoint> getVisibilityPoints(KB kb, OccAgent agent) {
        if (this.visPoints == null) {
            this.visPoints = PolygonShape.calcVisPoints(kb, agent, this.points);
        }
        return this.visPoints;
    }

    private static List<TriPoint> calcVisPoints(KB kb, OccAgent agent, Point3d[] points) {
        ArrayList<TriPoint> result = new ArrayList<TriPoint>(points.length + 1);
        result.add(agent.getLoc());
        for (Point3d p : points) {
            Tri t = kb.getMesh().getTri(p);
            if (t == null) continue;
            result.add(new TriPoint(t, p));
        }
        return result;
    }

    @Override
    public double getHeight() {
        return this.vehicleBody.height;
    }

    @Override
    public IAgentBodyShape moveInDirBy(double distOffset) {
        return this.moveInDirBy(this.dir, distOffset);
    }

    @Override
    public PolygonShape move(Vector3d vec) {
        if (vec.lengthSquared() == 0.0) {
            return this;
        }
        Point3d newCenter = Util3D.add(this.center, (Tuple3d)vec);
        return this.translateToAndRotate(newCenter, 0.0);
    }

    public VehicleBody getVehicleBody() {
        return this.vehicleBody;
    }

    public static void rotatePoint(Point3d p, Point3d pivot, double angle) {
        double newX = pivot.x + (p.x - pivot.x) * Math.cos(angle) - (p.y - pivot.y) * Math.sin(angle);
        double newY = pivot.y + (p.x - pivot.x) * Math.sin(angle) + (p.y - pivot.y) * Math.cos(angle);
        p.x = newX;
        p.y = newY;
    }

    public static Point3d[] getUpdatedPoints(Point3d position, Vector3d direction, Point3d[] staticPoints) {
        Point3d pivot = new Point3d(0.0, 0.0, 0.0);
        Point3d[] points = new Point3d[staticPoints.length];
        pivot.add(position);
        for (int i = 0; i < points.length; ++i) {
            Point3d p = staticPoints[i];
            Point3d pNew = new Point3d(p);
            pNew.add(position);
            Vector3d ref = new Vector3d(1.0, 0.0, position.z);
            double angle = Trig.angle(ref, direction);
            PolygonShape.rotatePoint(pNew, pivot, angle);
            points[i] = pNew;
        }
        return points;
    }

    @Override
    public boolean getPrefersLateralAvoidance() {
        return this.vehicleBody.allowLateral;
    }

    public String toString() {
        return String.format("PolygonShape: sides=%d, radius=%g, height=%g", this.points.length, this.getOccRadius(), this.getHeight());
    }

    @Override
    public OccProfileSim.PolyShapeGen toShapeGen() {
        return new OccProfileSim.PolyShapeGen(this.vehicleBody);
    }

    @Override
    public Object getStaticHash() {
        return new StaticHash(this);
    }

    public static class StaticHash {
        public final PolygonShape shape;

        public StaticHash(PolygonShape shape) {
            this.shape = shape;
        }

        public int hashCode() {
            return 0xAAF83D ^ this.shape.vehicleBody.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StaticHash)) {
                return false;
            }
            StaticHash hash = (StaticHash)obj;
            return this.shape.vehicleBody.equals(hash.shape.vehicleBody);
        }
    }
}

