/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.sim.DoorQueue;
import inferno.sim.IFormationLeaderAgent;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public interface ITimeEstimate {
    public static final ITimeEstimate FOREVER = new Forever();

    public double getTime(KB var1, OccAgent var2);

    public boolean isPhysicallyClosed();

    public static class VariableOccSize
    implements ITimeEstimate,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ANode d_pickupNode;
        private int d_nominalLoad;
        private DoorQueue d_doorQueue;

        public VariableOccSize(ANode pickupNode, int nominalLoad, DoorQueue doorQueue) {
            this.d_pickupNode = pickupNode;
            this.d_doorQueue = doorQueue;
            this.d_nominalLoad = nominalLoad;
        }

        @Override
        public double getTime(KB kb, OccAgent agent) {
            int formationCorrespondingOccCount;
            IFormationLeaderAgent formationLeader = agent.getOcc().formationLeader;
            if (formationLeader != null && formationLeader.isFreePassDoor(this.d_doorQueue)) {
                return 0.0;
            }
            int correspondingOccCount = agent.getCorrespondingOccCount();
            if (formationLeader == null && correspondingOccCount == 1) {
                return 0.0;
            }
            int curOccCount = this.d_pickupNode.getCorrespondingNumOccupants() + this.d_pickupNode.getEnteringCount();
            int formationOccsInside = 0;
            List<OccAgent> formation = formationLeader != null ? formationLeader.getFormation() : Collections.singletonList(agent);
            for (OccAgent a : formation) {
                if (!this.d_pickupNode.getEnteringAgents().contains(a)) continue;
                formationOccsInside += a.getCorrespondingOccCount();
            }
            double maxAvailableOccCount = this.d_nominalLoad - curOccCount + formationOccsInside;
            int n = formationCorrespondingOccCount = formationLeader != null ? formationLeader.getFormationCorrespondingOccCount() : agent.getCorrespondingOccCount();
            if (formationCorrespondingOccCount > this.d_nominalLoad) {
                return Double.POSITIVE_INFINITY;
            }
            if ((double)(formationCorrespondingOccCount - formationOccsInside) > maxAvailableOccCount) {
                return kb.getCurrentSimTime() + 2000000.0;
            }
            return 0.0;
        }

        @Override
        public boolean isPhysicallyClosed() {
            return false;
        }
    }

    public static class Offset
    implements ITimeEstimate,
    Serializable {
        private static final long serialVersionUID = 6805030393164715309L;
        public final double tOffset;

        public Offset(double tOffset) {
            this.tOffset = tOffset;
        }

        @Override
        public double getTime(KB kb, OccAgent agent) {
            return kb.getCurrentSimTime() + this.tOffset;
        }

        @Override
        public boolean isPhysicallyClosed() {
            return true;
        }
    }

    public static class Forever
    implements ITimeEstimate,
    Serializable {
        private static final long serialVersionUID = 5305759104951693646L;

        @Override
        public double getTime(KB kb, OccAgent agent) {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isPhysicallyClosed() {
            return true;
        }
    }

    public static class Specific
    implements ITimeEstimate,
    Serializable {
        private static final long serialVersionUID = 852920724311182539L;
        private double d_t;

        public Specific(double t) {
            this.d_t = t;
        }

        @Override
        public double getTime(KB kb, OccAgent agent) {
            return this.d_t;
        }

        @Override
        public boolean isPhysicallyClosed() {
            return true;
        }
    }

    public static class FutureFixed
    implements ITimeEstimate,
    Serializable {
        private static final long serialVersionUID = 6154327557142381406L;
        private ITimeEstimate d_beforeFixed;
        private double d_dtPlus;

        public FutureFixed(ITimeEstimate beforeFixed, double dtPlus) {
            this.d_beforeFixed = beforeFixed;
            this.d_dtPlus = dtPlus;
        }

        @Override
        public double getTime(KB kb, OccAgent agent) {
            double dtBefore = 0.0;
            if (this.d_beforeFixed != null) {
                dtBefore = Math.max(0.0, this.d_beforeFixed.getTime(kb, agent) - kb.getCurrentSimTime());
            }
            return kb.getCurrentSimTime() + dtBefore + this.d_dtPlus;
        }

        @Override
        public boolean isPhysicallyClosed() {
            return true;
        }
    }
}

