/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import java.io.Serializable;

public class ElevatorLevel
implements Serializable {
    private static final long serialVersionUID = -2153617070083430794L;
    public final int levelId;
    public final ANode pickupNode;
    public final double openTime;
    public final double closeTime;
    public boolean isDischargeLevel;
    public final double tFirstAvailable;
    private final double d_pickupTime;
    private final double d_dischargeTime;
    private boolean d_hallCallActive;
    private final boolean d_isEnabled;

    public ElevatorLevel(int levelId, ANode pickupNode, double openTime, double closeTime, double pickupTimeTot, double dischargeTimeTot, double tFirstAvailable, boolean isEnabled) {
        this.levelId = levelId;
        this.openTime = openTime;
        this.closeTime = closeTime;
        this.pickupNode = pickupNode;
        this.d_pickupTime = pickupTimeTot;
        this.d_dischargeTime = dischargeTimeTot;
        this.tFirstAvailable = isEnabled ? tFirstAvailable : Double.POSITIVE_INFINITY;
        pickupNode.setElevatorLevel(this);
        this.d_isEnabled = isEnabled;
        this.isDischargeLevel = false;
    }

    public boolean isHallCallActive() {
        return this.d_hallCallActive;
    }

    public void call() {
        this.d_hallCallActive = true;
    }

    public void clearCall() {
        this.d_hallCallActive = false;
    }

    public double getDischargeTime() {
        return this.d_dischargeTime;
    }

    public double getDischargeTimeTot(ElevatorLevel elevatorDischargeLevel) {
        return this.closeTime + this.d_dischargeTime + elevatorDischargeLevel.openTime;
    }

    public double getPickupTime() {
        return this.d_pickupTime;
    }

    public double getPickupTimeTot(ElevatorLevel elevatorDischargeLevel) {
        return elevatorDischargeLevel.closeTime + this.d_pickupTime + this.openTime;
    }

    public boolean isEnabled() {
        return this.d_isEnabled;
    }

    public String toString() {
        return String.format("ElevatorLevel[id=%d]", this.levelId);
    }
}

