/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ElevatorLevel;
import inferno.data2.IElevator;
import inferno.sim.KB;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AElevatorScheduler<ElevatorType extends IElevator> {
    public abstract ElevatorLevel shouldReRouteTo(ElevatorType var1, Collection<ElevatorLevel> var2);

    public abstract void processHallCallsIndividual(KB var1, ElevatorType var2, Collection<ElevatorLevel> var3);

    public void processHallCallsLinked(KB kb, Set<ElevatorType> linkedElevs) {
        LinkedHashSet<ElevatorLevel> allLinkedInServiceLevels = new LinkedHashSet<ElevatorLevel>();
        for (IElevator linkedElevator : linkedElevs) {
            allLinkedInServiceLevels.addAll(linkedElevator.getInServiceLevels());
        }
        for (IElevator elevator : linkedElevs) {
            this.processHallCallsIndividual(kb, elevator, allLinkedInServiceLevels);
        }
    }

    public void clearCallStates(ElevatorType elevator) {
        for (ElevatorLevel level : elevator.getInServiceLevels()) {
            level.clearCall();
        }
        for (ElevatorLevel level : elevator.getOutOfServiceLevels()) {
            level.clearCall();
        }
    }
}

