/*
 * Decompiled with CFR 0.152.
 */
package inferno;

import inferno.parse2.SimpleParser;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.Param;
import inferno.sim.profiling.TimeAccum;
import inferno.test.ParsePth;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import merlin.MerlinApp;
import merlin.unitsystem.EnglishUS;
import merlin.unitsystem.SIUS;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TeciProps;

public class TestSim
extends Application {
    private static Logger LOGGER;

    public TestSim(String[] args) {
        super("TestSim", args, 0);
    }

    public static void main(String[] args) throws Throwable {
        TestSim app = new TestSim(args);
        app.run(args);
    }

    public void handle(Throwable t) {
        t.printStackTrace();
        System.exit(0);
    }

    private void run(String[] args) throws Throwable {
        SIUS.getInstance();
        EnglishUS.getInstance();
        File inFile = null;
        if (args.length > 0) {
            inFile = new File(args[0]);
        }
        if (inFile == null || !inFile.exists()) {
            Properties props = new Properties();
            File f = new File("inferno.props");
            if (!f.exists()) {
                f.createNewFile();
            }
            props.load(new FileInputStream(f));
            File lastFile = new File(props.getProperty("last_dir", ""));
            guiFileChooser chooser = new guiFileChooser();
            chooser.setAllSupportedTypesFilterEnabled(true);
            chooser.addChoosableFileFilter(new ExampleFileFilter("txt", "Inferno files"));
            chooser.addChoosableFileFilter(new ExampleFileFilter("pth", "Pathfinder files"));
            chooser.addChoosableFileFilter(new ExampleFileFilter("zip", "ZIP files"));
            chooser.setSelectedFile(lastFile);
            chooser.selectFirstAppropriateFilter(lastFile);
            if (chooser.showOpenDialog(null) != 0) {
                return;
            }
            inFile = chooser.getSelectedFile();
            props.setProperty("last_dir", inFile.getAbsolutePath());
            props.store(new FileOutputStream("inferno.props"), "");
        }
        TimeAccum ticks = new TimeAccum();
        ticks.begin("INFERNO");
        ticks.begin("STARTUP");
        final Engine engine = TestSim.loadEngine(inFile, ticks);
        KB kb = engine.getKB();
        Param p = kb.getParams();
        if (args.length > 1) {
            p.err = p.out = new PrintStream(new File(inFile.getParentFile(), args[1]));
        }
        if (engine.getGLView() != null) {
            engine.getGLView().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    int option;
                    if (engine.isFinished()) {
                        System.exit(0);
                    }
                    if ((option = JOptionPane.showConfirmDialog(null, "Would you like to exit inferno?", "Exit?", 0)) == 0) {
                        System.exit(0);
                    }
                }
            });
        }
        ticks.end("STARTUP");
        engine.addObserver(new EngineObserver(inFile.getName()));
        engine.run();
        engine.waitUntilFinished(100L);
        ticks.end("INFERNO");
        if (engine.getGLView() == null) {
            System.exit(0);
        }
    }

    /*
     * Exception decompiling
     */
    private static Engine loadEngine(File inFile, TimeAccum ticks) throws FileNotFoundException, Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Engine loadEngine(File dir, String probName, TimeAccum ticks, InputStream stream) throws FileNotFoundException, Throwable {
        String ext;
        switch (ext = FilenameManager.splitFilename(probName)[1].toLowerCase()) {
            case "txt": {
                KB kb = TestSim.createKbFromTxt(dir, probName, stream);
                TestSim.initGraphics(kb.getParams());
                return new Engine(TestSim.loadPrefs(), kb, kb.getParams(), ticks);
            }
            case "pth": {
                int options = 1;
                KB kb = ParsePth.load(stream, dir, probName, null, options);
                kb.getParams().out_results = probName.replace(".pth", ".pfr");
                kb.init();
                TestSim.initGraphics(kb.getParams());
                return new Engine(TestSim.loadPrefs(), kb, kb.getParams(), ticks);
            }
        }
        throw new IOException(String.format("Unsupported file type for file: %s", probName));
    }

    private static TeciProps loadPrefs() {
        try {
            return MerlinApp.loadAppPreferences();
        }
        catch (IOException e) {
            return new TeciProps();
        }
    }

    private static void initGraphics(Param p) {
        if (p.show_vis) {
            if (p.slower == 0) {
                p.slower = 15;
            }
            System.loadLibrary("FreeImage");
            try {
                TestSim.loadLib("Pathfinder_jni");
            }
            catch (Throwable t) {
                TestSim.loadLib("jawt");
                TestSim.loadLib("Pathfinder_jni");
            }
        }
    }

    private static KB createKbFromTxt(File parent, String name, InputStream is) throws FileNotFoundException {
        SimpleParser sp = new SimpleParser(is, parent, name);
        try {
            sp.run();
        }
        catch (Exception t) {
            LOGGER.severe("parse error [line " + sp.getLastLineN() + "]: " + sp.getLastLine());
            LOGGER.severe(t.getLocalizedMessage());
            t.printStackTrace();
            System.exit(1);
        }
        Param p = sp.getParam();
        String baseName = name;
        baseName = baseName.substring(0, baseName.lastIndexOf(46));
        p.set("out_occ_cumulative", new File(parent, baseName + "_occupants.csv").getPath());
        p.set("out_occ_detailed", new File(parent, baseName + "_occupants_detailed.csv").getPath());
        p.set("out_occ_individual", new File(parent, baseName + "_occupant_{id}.csv").getPath());
        p.set("out_occ_params", new File(parent, baseName + "_occupant_params.csv").getPath());
        return sp.getKB();
    }

    @Override
    protected void loadLibraries() {
    }

    @Override
    public boolean isInstallFolder(File folder) {
        int found = 0;
        if (Stream.of(folder.listFiles()).anyMatch(f -> f.getName().equalsIgnoreCase("PathfinderResults.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x86_Debug.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x64_Debug.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x86_Release.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x64_Release.exe"))) {
            ++found;
        }
        if (Stream.of(folder.listFiles()).anyMatch(f -> f.getName().equalsIgnoreCase("lib"))) {
            ++found;
        }
        return found == 2;
    }

    static {
        System.setProperty("sun.awt.exception.handler", TestSim.class.getName());
        TeciLogging.init(Level.INFO);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER = Logger.getLogger(TestSim.class.getName());
    }

    private static class EngineObserver
    implements Observer {
        private final String d_probId;

        public EngineObserver(String probId) {
            this.d_probId = probId;
        }

        @Override
        public void update(Observable o, Object arg) {
            IPropertySet meta = (IPropertySet)arg;
            long ts = meta.get(Engine.META_TIME_TS);
            double t = meta.get(Engine.META_TIME_SIM);
            double tWall = meta.get(Engine.META_TIME_WALL);
            int occs = meta.get(Engine.META_OCCS_REM);
            String msg = String.format("TS=%5d  T=%8.3f  T_WALL=%8.3f  OCCS=%5d INPUT=%s%n", ts, t, tWall, occs, this.d_probId);
            LOGGER.info(msg);
        }
    }
}

