/*
 * Decompiled with CFR 0.152.
 */
package inferno;

import inferno.sim.Param;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Stream;
import merlin.MerlinPrefs;
import merlin.actions.InfernoUtil;
import merlin.actions.WriteMesh;
import merlin.data.MerlinData;
import merlin.data.egress.SimError;
import merlin.io.MerlinOIS;
import merlin.unitsystem.EnglishUS;
import merlin.unitsystem.SIUS;
import thunderheadeng.gui.Application;

public class PthToTxt
extends Application {
    public PthToTxt(String[] args) {
        super("PthToTxt", args, 0);
    }

    public static void main(String[] args) throws Throwable {
        PthToTxt app = new PthToTxt(args);
        app.run(args);
    }

    private void run(String[] args) throws FileNotFoundException, IOException, ClassNotFoundException {
        File inFile = null;
        File outFile = null;
        if (args.length <= 1) {
            throw new IllegalArgumentException("USAGE: PthToText <PTH file in> <TXT file out>");
        }
        inFile = new File(args[0]);
        System.out.println(inFile.getPath());
        outFile = new File(args[1]);
        System.out.println(outFile.getPath());
        if (!inFile.exists()) {
            throw new IllegalArgumentException("USAGE: PTH file in must exist.");
        }
        MerlinData md = new MerlinData(false);
        try (FileInputStream fis = new FileInputStream(inFile);){
            SIUS.getInstance();
            EnglishUS.getInstance();
            BufferedInputStream bis = new BufferedInputStream(fis);
            MerlinOIS ois = new MerlinOIS(bis, tp -> {});
            MerlinOIS.DecisionMaker decisions = new MerlinOIS.DecisionMaker();
            decisions.pre104UseNewDefaults = () -> false;
            MerlinData mdTemp = ois.readModel(decisions);
            md.loadFrom(mdTemp);
            String rootFn = InfernoUtil.rootFn(inFile.getName());
            Param p = InfernoUtil.mkInfernoParam(null, md, outFile.getParentFile(), rootFn, false);
            ArrayList<SimError> errors = new ArrayList<SimError>();
            InfernoUtil.KBInfo kbi = InfernoUtil.mkInfernoKB(md, p, (Boolean)MerlinPrefs.KEY_ANNOTATE.defVal, errors);
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            WriteMesh.writeInputFile(md, outFile.getParentFile(), rootFn, kbi, p);
        }
    }

    @Override
    protected void loadLibraries() {
    }

    @Override
    public boolean isInstallFolder(File folder) {
        int found = 0;
        if (Stream.of(folder.listFiles()).anyMatch(f -> f.getName().equalsIgnoreCase("PathfinderResults.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x86_Debug.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x64_Debug.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x86_Release.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x64_Release.exe"))) {
            ++found;
        }
        if (Stream.of(folder.listFiles()).anyMatch(f -> f.getName().equalsIgnoreCase("lib"))) {
            ++found;
        }
        return found == 2;
    }
}

