/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.session;

import java.util.List;
import java.util.stream.Collectors;
import results.api.ICallbacks;
import results.api.UnitType;
import results.nativebuffered.session.Filenames;
import results.nativebuffered.session.Session;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.util.Events;
import thunderheadeng.util.IBindable;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.theUtil;

public class SessionMediator
extends Mediator {
    public final Session session;
    public final ICallbacks callbacks;
    public final Filenames filenames;

    public SessionMediator(Session session, ICallbacks callbacks) {
        this.session = session;
        this.callbacks = callbacks;
        this.filenames = new Filenames(callbacks);
        session.setDomain(this);
    }

    public Session getSession() {
        return this.session;
    }

    public IUnitSrc getUnit(UnitType type) {
        return this.callbacks.getUnit(type);
    }

    public Runnable disconnectObservers() {
        return new ListenerStripper(this.getEvents());
    }

    private static class ListenerStripper
    implements Runnable {
        private final List<IBindable> d_bindables;
        private final IListenerStripper d_base;

        public ListenerStripper(Events events) {
            this.d_bindables = events.getObservers().stream().filter(v -> v instanceof IBindable).map(v -> (IBindable)((Object)v)).collect(Collectors.toList());
            this.d_bindables.forEach(IBindable::disconnect);
            this.d_base = guiUtil.stripListeners(events::addObserver, () -> theUtil.toArray(events.getObservers(), IEventObserver.class), events::removeObserver);
        }

        @Override
        public void run() {
            this.d_base.restore();
            this.d_bindables.forEach(IBindable::connect);
        }
    }
}

