/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.mv;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jscience.physics.units.SI;
import results.Intl;
import results.api.Events;
import results.api.FileType;
import results.api.UnitType;
import results.nativebuffered.gui.MovieDlg;
import results.nativebuffered.gui.ScreenshotDlg;
import results.nativebuffered.mv.MVAction;
import results.nativebuffered.mv.MVPrefs;
import results.nativebuffered.mv.ResultsSceneView;
import results.nativebuffered.mv.VideoCompressorPrefs;
import results.nativebuffered.session.Session;
import results.nativebuffered.session.SessionMediator;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.video.VideoCompressorDlg;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.nativebuffered.VideoCompressors;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IBindable;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.theUtil;
import thunderheadeng.video.IVideoCompressor;
import thunderheadeng.video.IVideoCompressors;

public class MVMedia
implements IEventObserver,
IBindable {
    private final SessionMediator d_mediator;
    private final JButton d_record;
    private final JButton d_stop;
    public final guiAction createMovie;
    public final guiAction createScreenshot;

    public MVMedia(SessionMediator mediator, ResultsSceneView sceneView) {
        this.d_mediator = mediator;
        this.d_record = MVMedia.newMediaBtn(Intl.intl("Start Recording Video"), "Record", e -> this.recordOrPause(e.getSource() instanceof Component ? (Component)e.getSource() : null));
        this.d_stop = MVMedia.newMediaBtn(Intl.intl("Stop Recording Video"), "StopRec", e -> this.stop());
        this.createMovie = new MVAction(Intl.intl("Movie"), null, e -> this.createMovie((MVAction.ActionInfo)e, sceneView));
        this.createScreenshot = new MVAction(Intl.intl("Screenshot"), null, e -> this.createScreenshot((MVAction.ActionInfo)e, sceneView));
        this.sync();
    }

    private void createMovie(MVAction.ActionInfo ai, ResultsSceneView sceneView) {
        if (!this.validateNotRecordingVideo(ai.srcComp)) {
            return;
        }
        Pair<File, IVideoCompressors.Type> vfile = this.chooseVideoFile(ai.srcComp, FileType.MOVIE, true);
        if (vfile == null) {
            return;
        }
        List<IVideoCompressor> compressors = MVMedia.getCompressors().getCompressors((IVideoCompressors.Type)((Object)vfile.v2));
        IPropertySet props = MVPrefs.loadMoviePrefs(this.d_mediator.callbacks.getPreferences(), compressors);
        if (props.get(MovieDlg.MoviePnl.COMPRESSOR) == null) {
            props.set(MovieDlg.MoviePnl.COMPRESSOR, MVMedia.getDefaultCompressor((IVideoCompressors.Type)((Object)vfile.v2), compressors));
        }
        double[] trange = (double[])this.d_mediator.session.get(Session.TIME_RANGE);
        UnitDouble[] trangeu = new UnitDouble[]{new UnitDouble(trange[0], SI.SECOND), new UnitDouble(trange[1], SI.SECOND)};
        props.set(MovieDlg.MoviePnl.TRANGE, trangeu);
        props.set(MovieDlg.MoviePnl.SPEED, this.d_mediator.session.get(Session.TIME_SCALE));
        MovieDlg dlg = new MovieDlg(ai.parentWindow, Intl.intl("Movie Properties"), (IVideoCompressors.Type)((Object)vfile.v2), compressors, () -> sceneView.getComponent().getSize(), this.d_mediator.callbacks.getUnit(UnitType.TIME), trangeu[0], trangeu[1]);
        dlg.load(props);
        if (dlg.doModal() != 1) {
            return;
        }
        dlg.save(props);
        MVPrefs.saveMoviePrefs(this.d_mediator.callbacks.getPreferences(), props);
        TaskProgress progress = new TaskProgress();
        guiProgressMonitor progMonitor = new guiProgressMonitor(ai.parentWindow, Intl.intl("Movie Progress"), true, progress, 500, true);
        this.forkWorkerThread(ai, () -> {
            progMonitor.begin();
            try {
                sceneView.createMovie(this.d_mediator.session, progress, ((File)pair.v1).getAbsolutePath(), props.get(MovieDlg.MoviePnl.COMPRESSOR), props.get(MovieDlg.MoviePnl.SIZE), props.get(MovieDlg.MoviePnl.FRAMERATE), props.get(MovieDlg.MoviePnl.SPEED), props.get(MovieDlg.MoviePnl.TRANGE), props.get(MovieDlg.MoviePnl.LOD));
            }
            catch (Throwable t) {
                SwingUtilities.invokeLater(() -> guiUtil.showError(actionInfo.srcComp, Intl.intl("Movie Error"), Intl.intl("Could not create movie"), t));
            }
            finally {
                progMonitor.end();
                if (props.get(MovieDlg.MoviePnl.WATCH_WHEN_FINISHED).booleanValue() && ((File)pair.v1).exists()) {
                    try {
                        Desktop.getDesktop().open((File)pair.v1);
                    }
                    catch (Throwable t) {
                        SwingUtilities.invokeLater(() -> guiUtil.showError(actionInfo.srcComp, Intl.intl("File Error"), Intl.intl("Could not open movie file"), t));
                    }
                }
            }
        });
    }

    private void forkWorkerThread(MVAction.ActionInfo ai, Runnable task) {
        ai.beginWaitCursor();
        Runnable restoreListeners = this.d_mediator.disconnectObservers();
        this.d_mediator.session.pauseSessionUpdates();
        Thread worker = new Thread(() -> {
            try {
                task.run();
            }
            finally {
                SwingUtilities.invokeLater(() -> {
                    restoreListeners.run();
                    this.d_mediator.session.resumeSessionUpdates();
                    ai.endWaitCursor();
                });
            }
        });
        worker.start();
    }

    private void createScreenshot(MVAction.ActionInfo ai, ResultsSceneView sceneView) {
        if (!this.validateNotRecordingVideo(ai.srcComp)) {
            return;
        }
        File file = this.chooseImageFile(ai.srcComp);
        if (file == null) {
            return;
        }
        IPropertySet props = MVPrefs.loadScreenshotPrefs(this.d_mediator.callbacks.getPreferences());
        ScreenshotDlg dlg = new ScreenshotDlg(ai.parentWindow, Intl.intl("Screenshot Properties"), () -> sceneView.getComponent().getSize());
        dlg.load(props);
        if (dlg.doModal() != 1) {
            return;
        }
        dlg.save(props);
        MVPrefs.saveScreenshotPrefs(this.d_mediator.callbacks.getPreferences(), props);
        this.forkWorkerThread(ai, () -> {
            try {
                sceneView.createScreenshot(this.d_mediator.session, file.getAbsolutePath(), props.get(ScreenshotDlg.ScreenshotPnl.SIZE), props.get(ScreenshotDlg.ScreenshotPnl.LOD));
                if (props.get(ScreenshotDlg.ScreenshotPnl.VIEW_WHEN_FINISHED).booleanValue() && file.exists()) {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (Throwable t) {
                        SwingUtilities.invokeLater(() -> guiUtil.showError(actionInfo.srcComp, Intl.intl("File Error"), Intl.intl("Could not open screenshot"), t));
                    }
                }
            }
            catch (Throwable t) {
                SwingUtilities.invokeLater(() -> guiUtil.showError(actionInfo.srcComp, Intl.intl("Screenshot Error"), Intl.intl("Could not create screenshot"), t));
            }
        });
    }

    private static JButton newMediaBtn(String tooltip, String icon, ActionListener action) {
        return guiUtil.newMediaBtn(tooltip, "media/" + icon, action);
    }

    private static void setMediaIcons(JButton button, String icon) {
        guiUtil.setMediaIcons(button, "media/" + icon);
    }

    @Override
    public void connect() {
        this.d_mediator.getEvents().addObserver(this);
    }

    @Override
    public void disconnect() {
        this.d_mediator.getEvents().removeObserver(this);
    }

    private static IVideoCompressor getDefaultCompressor(IVideoCompressors.Type type, List<IVideoCompressor> clist) {
        if (type == IVideoCompressors.Type.WMV) {
            String[] preferredNames;
            for (String prefName : preferredNames = new String[]{"Windows Media Video 9", "Windows Media Video V8", "Windows Media Video V7"}) {
                Optional<IVideoCompressor> comp = clist.stream().filter(c -> c.get(IVideoCompressor.DESCRIPTION).equals(prefName)).findFirst();
                if (!comp.isPresent()) continue;
                return comp.get();
            }
        } else {
            for (IVideoCompressor compressor : clist) {
                if (!compressor.get(IVideoCompressor.UNCOMPRESSED).booleanValue()) continue;
                return compressor;
            }
            if (!clist.isEmpty()) {
                return clist.iterator().next();
            }
        }
        return null;
    }

    private static IVideoCompressors getCompressors() {
        return new VideoCompressors();
    }

    private static void warnNoCompressors(Component parent) {
        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(parent), Intl.intl("Cannot create video. No video CODECs could be found."), Intl.intl("Missing CODECs"), 0);
    }

    private IVideoCompressor chooseCompressor(Component parent, IVideoCompressors.Type type, VideoCompressorPrefs prefs) {
        IVideoCompressors compressors = MVMedia.getCompressors();
        List<IVideoCompressor> clist = compressors.getCompressors(type);
        if (clist.isEmpty()) {
            MVMedia.warnNoCompressors(parent);
            return null;
        }
        TeciProps gprefs = this.d_mediator.callbacks.getPreferences();
        IVideoCompressor initCompressor = prefs.load(gprefs, clist);
        if (initCompressor == null) {
            initCompressor = MVMedia.getDefaultCompressor(type, clist);
        }
        VideoCompressorDlg compressorDlg = new VideoCompressorDlg(SwingUtilities.getWindowAncestor(parent), Intl.intl("Select Video Compressor"), type, clist, true);
        compressorDlg.load(initCompressor);
        if (compressorDlg.doModal() != 1) {
            return null;
        }
        IVideoCompressor compressor = compressorDlg.save();
        prefs.save(gprefs, compressor);
        return compressor;
    }

    private Pair<File, IVideoCompressors.Type> chooseVideoFile(Component parent, FileType ftype, boolean aviAllowed) {
        IVideoCompressors.Type type;
        String videoPath = this.d_mediator.filenames.generatePath(ftype, true);
        ArrayList filters = new ArrayList();
        BiConsumer<String, String> addFilter = (desc, ext) -> {
            filters.add(desc);
            filters.add(ext);
        };
        IVideoCompressors compressors = MVMedia.getCompressors();
        if (!compressors.getCompressors(IVideoCompressors.Type.WMV).isEmpty()) {
            addFilter.accept(Intl.intl("Windows Media Format"), "wmv");
        }
        if (aviAllowed && !compressors.getCompressors(IVideoCompressors.Type.AVI).isEmpty()) {
            addFilter.accept(Intl.intl("Audio-Video Interlaced"), "avi");
        }
        if (filters.isEmpty()) {
            MVMedia.warnNoCompressors(parent);
            return null;
        }
        guiFileChooser chooser = this.d_mediator.callbacks.getChooser(FileType.LIVEVIDEO, Optional.of(videoPath), false, theUtil.toArray(filters, Object.class));
        chooser.setDialogTitle(Intl.intl("Choose a Video File"));
        if (chooser.showSaveDialog(SwingUtilities.getWindowAncestor(parent)) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        this.d_mediator.filenames.commitPath(ftype, file.getAbsolutePath());
        switch (FilenameManager.splitFilename(file.getName())[1]) {
            case "avi": {
                type = IVideoCompressors.Type.AVI;
                break;
            }
            default: {
                type = IVideoCompressors.Type.WMV;
            }
        }
        return new Pair<File, IVideoCompressors.Type>(file, type);
    }

    private File chooseImageFile(Component parent) {
        String imagePath = this.d_mediator.filenames.generatePath(FileType.SCREENSHOT, true);
        guiFileChooser chooser = this.d_mediator.callbacks.getChooser(FileType.SCREENSHOT, Optional.of(imagePath), false, Intl.intl("Bitmap"), "bmp", Intl.intl("JPEG"), 4, "jpg", "jpeg", "jif", "jpe", Intl.intl("PNG"), "png", Intl.intl("TARGA"), 2, "tga", "targa", Intl.intl("TIF"), 2, "tif", "tiff");
        chooser.setDialogTitle(Intl.intl("Choose a Video File"));
        if (chooser.showSaveDialog(SwingUtilities.getWindowAncestor(parent)) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        this.d_mediator.filenames.commitPath(FileType.SCREENSHOT, file.getAbsolutePath());
        return file;
    }

    private void recordOrPause(Component parent) {
        Session session = this.d_mediator.session;
        Session.VideoRecState vstate = session.get(Session.VIDEO_RECORD);
        if (vstate == Session.VideoRecState.STOPPED) {
            Pair<File, IVideoCompressors.Type> f = this.chooseVideoFile(parent, FileType.LIVEVIDEO, false);
            if (f == null) {
                return;
            }
            IVideoCompressor compressor = this.chooseCompressor(parent, (IVideoCompressors.Type)((Object)f.v2), MVPrefs.LIVEVIDEO_COMPRESSOR);
            if (compressor == null) {
                return;
            }
            try {
                session.startVideoRecord(((File)f.v1).getAbsolutePath(), compressor);
            }
            catch (IOException e) {
                guiUtil.showError(parent, Intl.intl("Cannot Start Video"), Intl.intl("Cannot start recording video"), (Throwable)e);
            }
        } else if (vstate == Session.VideoRecState.PAUSED) {
            session.set(Session.VIDEO_RECORD, Session.VideoRecState.RECORDING);
        } else {
            session.set(Session.VIDEO_RECORD, Session.VideoRecState.PAUSED);
        }
    }

    private void stop() {
        this.d_mediator.session.set(Session.VIDEO_RECORD, Session.VideoRecState.STOPPED);
    }

    private boolean validateNotRecordingVideo(Component parent) {
        if (this.d_mediator.session.get(Session.VIDEO_RECORD) != Session.VideoRecState.STOPPED) {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(parent), Intl.intl("A video is currently being recorded.  Please stop video and try again."), Intl.intl("Recording Video"), 0);
            return false;
        }
        return true;
    }

    public Component createRecordUI() {
        JButton movieBtn = new JButton(this.createMovie);
        guiPanel panel = new guiPanel();
        GridBagHelper gb = new GridBagHelper(panel);
        gb.d_colSpace = 3;
        gb.addRow(this.d_record, this.d_stop, movieBtn, new JButton(this.createScreenshot));
        gb.finalizeRows();
        return panel;
    }

    private void sync() {
        Session.VideoRecState vstate = this.d_mediator.session.get(Session.VIDEO_RECORD);
        this.d_stop.setEnabled(vstate != Session.VideoRecState.STOPPED);
        switch (vstate) {
            case PAUSED: 
            case STOPPED: {
                MVMedia.setMediaIcons(this.d_record, "Record");
                break;
            }
            case RECORDING: {
                MVMedia.setMediaIcons(this.d_record, "PauseRec");
            }
        }
    }

    @Override
    public void update(thunderheadeng.util.Events events) {
        Session session = this.d_mediator.getSession();
        IEventRecord<Session> sevts = events.getEvents(Session.class, new Class[0]);
        if (sevts.isChanged(session, (Object)Events.PATHFINDER_RESULTS_ATTACHED) || sevts.isChanged(session, (Object)Events.PATHFINDER_RESULTS_DETACHED) || sevts.isChanged(session, Session.VIDEO_RECORD)) {
            this.sync();
        }
    }
}

