/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import merlin.actions.OccGenerator;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;

public class CreateCases {
    public RoomRule roomRule = RoomRule.SAME;
    public DistPos distPosRule = DistPos.RANDOM;
    private static PathFilterType[] FILTER_PROPS_SEQ = new PathFilterType[]{PathFilterType.INCLUDE, PathFilterType.EXCLUDE, PathFilterType.INCLUDE_PROPS, PathFilterType.EXCLUDE_PROPS};
    private static PathFilterType[] FILTER_POS_SEQ = new PathFilterType[]{PathFilterType.INCLUDE, PathFilterType.EXCLUDE, PathFilterType.INCLUDE_POS, PathFilterType.EXCLUDE_POS};
    public Map<PathFilterType, PathFilter> filters = new HashMap<PathFilterType, PathFilter>();
    public File installFolderOverride = null;
    private final File pthFile;
    private final int n;
    public long d_rseed;

    public CreateCases(File pthFile, int n) {
        this.pthFile = pthFile;
        this.n = n;
    }

    public void generate() throws IOException, ClassNotFoundException {
        String pthFilenameNoExt = this.pthFile.getName().replaceFirst("[.][^.]+$", "");
        String baseName = pthFilenameNoExt + "_variations";
        File outputRootFile = new File(this.pthFile.getParentFile(), baseName);
        int autonum = 1;
        while (outputRootFile.exists()) {
            outputRootFile = new File(this.pthFile.getParentFile(), baseName + autonum);
            ++autonum;
        }
        if (!outputRootFile.mkdir()) {
            System.err.println("Unable to create output folder: " + outputRootFile.getPath());
            return;
        }
        MerlinData md = new MerlinData(false);
        try (MerlinOIS ois = new MerlinOIS(new BufferedInputStream(new FileInputStream(this.pthFile)), tp -> {});){
            MerlinOIS.DecisionMaker decisions = new MerlinOIS.DecisionMaker();
            decisions.pre104UseNewDefaults = () -> false;
            MerlinData rawLoad = ois.readModel(decisions);
            md.loadFrom(rawLoad);
        }
        Collection<EgressAgent> posAgents = CreateCases.getAgents(md, this.filters, FILTER_POS_SEQ);
        Collection<EgressAgent> propsAgents = CreateCases.getAgents(md, this.filters, FILTER_PROPS_SEQ);
        HashMap<IEgressOccupiable, Set<EgressAgent>> roomOccMap = new HashMap<IEgressOccupiable, Set<EgressAgent>>();
        for (EgressAgent ea : posAgents) {
            roomOccMap.putIfAbsent(ea.getRoom(), new HashSet());
            ((Set)roomOccMap.get(ea.getRoom())).add(ea);
        }
        this.printSummary(md, this.filters);
        Random rng = new Random(this.d_rseed);
        ArrayList<String> cases = new ArrayList<String>();
        for (int id = 1; id <= this.n; ++id) {
            CreateCases.randomizeAgentPosition(md, rng, this.roomRule, this.distPosRule, roomOccMap, posAgents);
            CreateCases.randomizeAgentProfileData(md, rng, propsAgents);
            File caseFile = new File(outputRootFile, pthFilenameNoExt + "_" + id + ".pth");
            cases.add(caseFile.getName());
            MerlinIO.writeModel(caseFile.getPath(), md);
        }
        this.writeRunnerScript(outputRootFile + File.separator + "_run.bat", cases);
        this.writeResultsScript(outputRootFile + File.separator + "_make_plots.bat", cases);
    }

    private void writeRunnerScript(String fn, List<String> cases) throws IOException {
        StringBuilder data = new StringBuilder();
        InputStream instrm = CreateCases.class.getResourceAsStream("runner.bat.template");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(instrm));){
            String line = reader.readLine();
            while (line != null) {
                data.append(line).append("\n");
                line = reader.readLine();
            }
        }
        String installFolder = this.installFolderOverride != null ? this.installFolderOverride.getPath() : CreateCases.findInstallFolder();
        String jreFolder = CreateCases.findJreFolder(installFolder);
        String casesStr = cases.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(" "));
        String content = data.toString();
        content = content.replace("{INSTALL_FOLDER}", installFolder);
        content = content.replace("{JAVA_FOLDER}", jreFolder);
        content = content.replace("{CASES}", casesStr);
        Files.write(Paths.get(fn, new String[0]), content.getBytes(), new OpenOption[0]);
    }

    private void writeResultsScript(String fn, List<String> cases) throws IOException {
        StringBuilder data = new StringBuilder();
        InputStream instrm = CreateCases.class.getResourceAsStream("results.bat.template");
        BufferedReader reader = new BufferedReader(new InputStreamReader(instrm));
        Object object = null;
        try {
            String line = reader.readLine();
            while (line != null) {
                data.append(line).append("\n");
                line = reader.readLine();
            }
        }
        catch (Throwable line) {
            object = line;
            throw line;
        }
        finally {
            if (reader != null) {
                if (object != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable line) {
                        ((Throwable)object).addSuppressed(line);
                    }
                } else {
                    reader.close();
                }
            }
        }
        ArrayList<String> casesBetter = new ArrayList<String>();
        for (String caseName : cases) {
            casesBetter.add(String.format("\"%s\"", "%ROOT%\\" + caseName));
        }
        String installFolder = this.installFolderOverride != null ? this.installFolderOverride.getPath() : CreateCases.findInstallFolder();
        String jreFolder = CreateCases.findJreFolder(installFolder);
        String casesStr = String.join((CharSequence)" ", casesBetter);
        String content = data.toString();
        content = content.replace("{INSTALL_FOLDER}", installFolder);
        content = content.replace("{JAVA_FOLDER}", jreFolder);
        content = content.replace("{CASES}", casesStr);
        Files.write(Paths.get(fn, new String[0]), content.getBytes(), new OpenOption[0]);
    }

    private static String findJreFolder(String installFolder) {
        File root = new File(installFolder);
        File jreFolder = new File(root, "jre");
        if (jreFolder.exists()) {
            return jreFolder.getPath();
        }
        for (File f : root.listFiles()) {
            if (!f.isDirectory() || !f.getName().startsWith("jre")) continue;
            return f.getPath();
        }
        return jreFolder.getPath();
    }

    private static String findInstallFolder() {
        String applicationDir = CreateCases.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            applicationDir = URLDecoder.decode(applicationDir, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (applicationDir.endsWith(".jar")) {
            applicationDir = new File(applicationDir).getParent();
        } else {
            applicationDir = applicationDir + CreateCases.class.getName().replace('.', '/');
            applicationDir = new File(applicationDir).getParent();
        }
        for (File currentDir = new File(applicationDir); currentDir != null; currentDir = currentDir.getParentFile()) {
            File test = new File(currentDir, "testsim.bat");
            if (!test.exists()) continue;
            return currentDir.getPath();
        }
        return null;
    }

    private static void randomizeAgentProfileData(MerlinData md, Random rng, Collection<EgressAgent> occsToRandomize) {
        if (occsToRandomize.isEmpty()) {
            return;
        }
        Collection<EgressAgent> allAgents = md.agents.getDeepMembers(EgressAgent.class);
        for (EgressAgent ea : allAgents) {
            if (!occsToRandomize.contains(ea)) continue;
            ea.setProfileSeed(rng.nextLong());
            ea.setOrientSeed(rng.nextLong());
        }
    }

    private static void randomizeAgentPosition(MerlinData md, Random rng, RoomRule roomRule, DistPos distPosRule, Map<IEgressOccupiable, Set<EgressAgent>> roomOccMap, Collection<EgressAgent> occsToRandomize) {
        if (occsToRandomize.isEmpty()) {
            return;
        }
        LinkedHashSet<OccProfile> profiles = new LinkedHashSet<OccProfile>();
        LinkedHashMap<EgressAgent, OccLocation> locMap = new LinkedHashMap<EgressAgent, OccLocation>();
        LinkedHashMap<EgressAgent, Long> orientSeedMap = new LinkedHashMap<EgressAgent, Long>();
        for (EgressAgent occ : occsToRandomize) {
            profiles.add(occ.getProfile().getProfParent());
            locMap.put(occ, occ.getLocInfo());
            orientSeedMap.put(occ, occ.getOrientSeed());
        }
        HashSet<IEgressOccupiable> allUseableRooms = new HashSet<IEgressOccupiable>(md.floors.flatten(IEgressOccupiable.class, room -> room.isEnabled() && room.getOccupantsAllowed()));
        BiFunction<Set, Collection, Boolean> randomize = (comps, occs) -> {
            OccGenerator occGenerator = new OccGenerator(md, rng, OccGenerator.getModels(comps), OccGenerator.getMaxDiam(profiles), new UnitDouble(0.125, SI.SECOND), 400, null, null);
            switch (distPosRule) {
                case UNIFORM: {
                    return occGenerator.generate(occs.size(), 0, 2, (Collection<EgressAgent>)occs);
                }
                case RANDOM: {
                    return occGenerator.generate(occs.size(), 1, 2, (Collection<EgressAgent>)occs);
                }
            }
            assert (false);
            throw new RuntimeException("Unrecognized distPosRule: " + (Object)((Object)distPosRule));
        };
        boolean successful = true;
        if (RoomRule.ANY == roomRule) {
            successful &= randomize.apply(allUseableRooms, occsToRandomize).booleanValue();
        } else if (RoomRule.UNION == roomRule) {
            successful &= randomize.apply(roomOccMap.keySet(), occsToRandomize).booleanValue();
        } else if (RoomRule.SAME == roomRule) {
            for (Map.Entry<IEgressOccupiable, Set<EgressAgent>> entry : roomOccMap.entrySet()) {
                if (!(successful &= randomize.apply(Collections.singleton(entry.getKey()), entry.getValue()).booleanValue())) break;
            }
        } else {
            assert (false);
            throw new RuntimeException("Unrecognized roomRule: " + (Object)((Object)roomRule));
        }
        if (!successful) {
            System.out.println("Pathfinder was unable to randomize occupants' positions without overlap.");
            System.out.println("Occupant positions reverted.");
            for (EgressAgent occ : occsToRandomize) {
                occ.setLocation((OccLocation)locMap.get(occ));
                occ.setOrientSeed((Long)orientSeedMap.get(occ));
            }
        }
    }

    private static Collection<EgressAgent> getAgents(MerlinData md, Map<PathFilterType, PathFilter> allFiltersMap, PathFilterType ... filterTypes) {
        return md.agents.flatten(EgressAgent.class, agent -> {
            String path = CreateCases.getPath(md, agent);
            for (PathFilterType filterType : filterTypes) {
                if (!allFiltersMap.containsKey((Object)filterType)) continue;
                PathFilter filter = (PathFilter)allFiltersMap.get((Object)filterType);
                if (filter.include && !path.contains(filter.pattern)) {
                    return false;
                }
                if (filter.include || !path.contains(filter.pattern)) continue;
                return false;
            }
            return true;
        });
    }

    private static String getPath(MerlinData md, EgressAgent agent) {
        Object[] pathObj = md.hierarchy.getPath(agent, md, false);
        return Arrays.stream(pathObj).map(obj -> ((INamed)obj).getName()).collect(Collectors.joining("/"));
    }

    private void printSummary(MerlinData md, Map<PathFilterType, PathFilter> filters) {
        if (RoomRule.ANY == this.roomRule) {
            System.out.print("\n\nOccupant positions will be distributed between all rooms.\n");
        }
        if (DistPos.UNIFORM == this.distPosRule) {
            System.out.print("\n\nOccupant position distribution will be uniform.\n");
        }
        Collection<EgressAgent> allAgents = CreateCases.getAgents(md, filters, new PathFilterType[0]);
        Collection<EgressAgent> topFilter = CreateCases.getAgents(md, filters, PathFilterType.INCLUDE, PathFilterType.EXCLUDE);
        Collection<EgressAgent> posAgents = CreateCases.getAgents(md, filters, FILTER_POS_SEQ);
        Collection<EgressAgent> propsAgents = CreateCases.getAgents(md, filters, FILTER_PROPS_SEQ);
        System.out.printf("%n%-50s %-10s %-10s %-10s %n", "Id", "Include", "Rng Pos", "Rng Props");
        for (EgressAgent agent : allAgents) {
            System.out.printf("%-50s %-10s %-10s %-10s %n", CreateCases.getPath(md, agent), topFilter.contains(agent) ? "yes" : "no", posAgents.contains(agent) ? "yes" : "no", propsAgents.contains(agent) ? "yes" : "no");
        }
    }

    public static class PathFilter {
        public final boolean include;
        public final String pattern;

        public PathFilter(boolean include, String pattern) {
            this.include = include;
            this.pattern = pattern;
        }
    }

    public static enum PathFilterType {
        INCLUDE,
        EXCLUDE,
        INCLUDE_PROPS,
        EXCLUDE_PROPS,
        INCLUDE_POS,
        EXCLUDE_POS;

    }

    public static enum DistPos {
        RANDOM,
        UNIFORM;

    }

    public static enum RoomRule {
        SAME,
        UNION,
        ANY;

    }
}

