/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import merlin.builders.AgentDropper;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.mv.ModelView;
import merlin.mv.tools.MerlinTool;
import merlin.util.MerlinUtil;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IsectInfo;

public class NewAgentTool
extends MerlinTool<AgentDropper> {
    private boolean d_agentLocSet = false;

    public NewAgentTool(ModelView mv) {
        super(mv, (IToolFunction<? extends CursorTool>)new Func());
        this.setSnapInfo(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(IEgressOccupiable.class, GeomType.FACE));
    }

    @Override
    public void cancel() {
        super.cancel();
    }

    private void updateLocation() {
        ((AgentDropper)this.props()).pause();
        for (IsectInfo ii : super.getP1().snaps) {
            ((AgentDropper)this.props()).setLocation(MerlinUtil.getUPoint3D(ii.isectPoint));
            if (!((AgentDropper)this.props()).canCreate()) continue;
            break;
        }
        ((AgentDropper)this.props()).resume();
    }

    protected static class Func
    extends AToolFunction<NewAgentTool> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(NewAgentTool tool) {
            return null;
        }

        @Override
        public void mousePressed(NewAgentTool tool, MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            tool.updateLocation();
            if (((AgentDropper)tool.props()).canCreate()) {
                tool.d_agentLocSet = true;
            }
        }

        @Override
        public void mouseDragged(NewAgentTool tool, MouseEvent e) {
            if (!tool.isDragging(1)) {
                return;
            }
            tool.updateLocation();
            if (((AgentDropper)tool.props()).canCreate()) {
                tool.d_agentLocSet = true;
            }
        }

        @Override
        public void mouseReleased(NewAgentTool tool, MouseEvent e) {
            if (e.getButton() == 3) {
                tool.cancel();
                return;
            }
            if (!tool.d_agentLocSet || e.getButton() != 1) {
                return;
            }
            ((AgentDropper)tool.props()).createAndAddAgent(e.getComponent());
            tool.d_agentLocSet = false;
            tool.finish();
        }

        @Override
        public void mouseMoved(NewAgentTool tool, MouseEvent e) {
            tool.updateLocation();
        }
    }
}

