/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import merlin.builders.ATwoPointBuilder;
import merlin.builders.AgentRectDropper;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.mv.ModelView;
import merlin.mv.tools.ANewTwoPointTool;
import merlin.mv.tools.NewRectTool;
import merlin.mv.tools.ToolUtil;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.scene3d.Rectifier;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.util.LinkedIdentityHashSet;

public class NewAgentRectTool
extends NewRectTool<AgentRectDropper> {
    public NewAgentRectTool(ModelView mv, MerlinData md) {
        super(mv, new Func());
        this.setSnapInfo(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(IEgressOccupiable.class));
    }

    @Override
    public boolean areGuidesVisible() {
        return true;
    }

    @Override
    protected boolean showDragGuides() {
        return true;
    }

    public Model getModel() {
        Point3d p1 = this.getView().worldToScreen(this.getP0().referenceSnap);
        p1.z = 0.0;
        Point3d p3 = this.getView().worldToScreen(this.getP1().referenceSnap);
        p3.z = 0.0;
        Rectifier.rectify(p1, p3);
        Box3d frustum = ToolUtil.getCamFrustum(this.getView(), new Point2d(p1.x, p1.y), new Point2d(p3.x, p3.y));
        Point3d[] frusVerts = frustum.getVerts();
        Model tempModel = new Model();
        Collection<IEgressOccupiable> rooms = this.getValidRooms();
        for (IEgressOccupiable room : rooms) {
            for (Face pgeom : room.getModel().getFaces()) {
                Plane3d plane = pgeom.plane;
                Point3d i1 = Inter3D.rayPlaneIntersection(frusVerts[0], Util3D.vector(frusVerts[0], frusVerts[4]), plane, 1.0E-6);
                Point3d i2 = Inter3D.rayPlaneIntersection(frusVerts[1], Util3D.vector(frusVerts[1], frusVerts[5]), plane, 1.0E-6);
                Point3d i3 = Inter3D.rayPlaneIntersection(frusVerts[2], Util3D.vector(frusVerts[2], frusVerts[6]), plane, 1.0E-6);
                Point3d i4 = Inter3D.rayPlaneIntersection(frusVerts[3], Util3D.vector(frusVerts[3], frusVerts[7]), plane, 1.0E-6);
                if (i1 == null || i2 == null || i3 == null || i4 == null) continue;
                Matrix4d wpXform = Util.getWorldToLocalXform(plane);
                Point2d p12d = ShapeUtil.invXform2d(wpXform, i1);
                Point2d p22d = ShapeUtil.invXform2d(wpXform, i2);
                Point2d p32d = ShapeUtil.invXform2d(wpXform, i3);
                Point2d p42d = ShapeUtil.invXform2d(wpXform, i4);
                Area area = new Area(ShapeUtil.toPath(p12d, p22d, p32d, p42d));
                area.intersect(GeomUtil.toArea(pgeom));
                if (area.isEmpty()) continue;
                ShapeGeom geom = new ShapeGeom((Shape)area, Util.getLocalToWorldXform(plane));
                for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode(geom, IFace.class)) {
                    GeomUtil.addFaceToModel(face, tempModel, 0, 0.0, 0.0);
                }
            }
        }
        return tempModel;
    }

    private Collection<IEgressOccupiable> getValidRooms() {
        LinkedIdentityHashSet<IEgressOccupiable> validRooms = new LinkedIdentityHashSet<IEgressOccupiable>();
        Collection<IsectInfo> isects0 = this.getP0().snaps;
        Collection<IsectInfo> isects1 = this.getP1().snaps;
        for (IsectInfo ii0 : isects0) {
            for (IsectInfo ii1 : isects1) {
                if (ii0.obj != ii1.obj) continue;
                validRooms.add((IEgressOccupiable)ii0.obj);
            }
        }
        return validRooms;
    }

    protected static class Func
    extends ANewTwoPointTool.Func<AgentRectDropper> {
        protected Func() {
        }

        @Override
        public void mouseReleased(ANewTwoPointTool tool, MouseEvent e) {
            super.mouseReleased(tool, e);
            if (tool.props() instanceof ATwoPointBuilder) {
                ((ATwoPointBuilder)tool.props()).reset();
            }
        }
    }
}

