/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.queues;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.builders.queues.QueueServiceBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.gui.APropEditPanel;
import merlin.gui.stat.CompactCurvePnl;
import merlin.mv.gui.LocationPanel;
import merlin.mv.gui.queues.NewQueueElemPnl;
import merlin.mv.gui.queues.QueueElemCreatePnl;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.stat.IDistributedVal;

public class NewQueueServicePnl
extends APropEditPanel<QueueServiceBuilder> {
    private final CompactCurvePnl d_waitEditor = new CompactCurvePnl(Intl.intl("Service Time:"), 1);

    public NewQueueServicePnl() {
        super(QueueServiceBuilder.WAIT_CHANGED);
        this.addDefaultListener(this.d_waitEditor);
        guiPanel locPnl = new guiPanel();
        GridBagHelper gbh = new GridBagHelper(locPnl);
        gbh.addRow(Intl.intl("Location:"), new ServiceLocationPanel());
        guiPanel waitPnl = new guiPanel();
        gbh = new GridBagHelper(waitPnl);
        gbh.addRow(Intl.intl("Service Time:"), this.d_waitEditor, 1.0, 0);
        this.addSection(new NewQueueElemPnl());
        this.addSeparator();
        this.addSection(locPnl);
        this.addSeparator();
        this.addSection(waitPnl);
        this.addSeparator();
        this.addSection(new QueueElemCreatePnl());
    }

    @Override
    protected void updateFromProps(QueueServiceBuilder props) {
        this.d_waitEditor.setValue(props.getWaitTime());
    }

    @Override
    protected void updateToProps(QueueServiceBuilder props) {
        props.setWaitTime((IDistributedVal)this.d_waitEditor.getValue());
    }

    private static class ServiceLocationPanel
    extends LocationPanel<QueueServiceBuilder> {
        public ServiceLocationPanel() {
            super(1, QueueServiceBuilder.DEST_CHANGED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateToProps(QueueServiceBuilder props) {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            try {
                UnitPoint3D specPoint = this.getValue();
                Point3d p1 = specPoint.getPoint3dValue(Geometry.LENGTH_UNIT);
                p1.z += 1.0E-6;
                AABox modelBounds = MerlinApp.getApp().getData().geomLocation.getBounds();
                Point3d p2 = new Point3d(p1.x, p1.y, modelBounds.getMinZ() - 1.0E-6);
                GeomUtil.FindResult findResult = GeomUtil.findRoom(MerlinApp.getApp().getData(), p1, p2, 1);
                IEgressOccupiable room = findResult != null ? findResult.room : null;
                Vector3d norm = findResult != null ? findResult.faceNormal : GeomConstants.VEC3D_ZPOS;
                UnitPoint3D p = findResult != null ? new UnitPoint3D(findResult.p, Geometry.LENGTH_UNIT) : specPoint;
                props.setDestination(p, room, norm);
            }
            finally {
                md.endRead();
            }
        }

        @Override
        protected void updateFromProps(QueueServiceBuilder props) {
            this.setValue(props.getDestination());
        }
    }
}

