/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.propConnections;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import merlin.actions.CompElementActions;
import merlin.actions.Undo;
import merlin.data.ICompElement;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.material.TexMappers;
import merlin.util.MerlinUtil;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.util.ListMap;

public class MaterialProp
extends CompElementActions.DefProp<ICompElement, IMaterial> {
    private static final IElemSource<Point2d> DEFUV = TexMappers.newPlanarCoordMapper(new Point3d(0.0, 0.0, 0.0));

    public MaterialProp() {
        super(ImportedGeom.PROP_MATERIAL);
    }

    @Override
    public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
        return super.get(md, CompElementActions.flattenToLocallyDefined(this.getProp(), objs));
    }

    private IMaterial[] getMats(MerlinData md, Object prop, ICompElement obj) {
        IMaterial[] mats = (IMaterial[])obj.getProperty(prop);
        if (mats.length > 1 && MerlinUtil.isUniform(mats)) {
            mats = new IMaterial[]{mats[0]};
        }
        return mats;
    }

    @Override
    protected Object get(MerlinData md, Object prop, ICompElement obj) {
        IMaterial[] mats = this.getMats(md, prop, obj);
        if (mats.length == 0) {
            return null;
        }
        if (mats.length == 1) {
            return mats[0];
        }
        return ICompElement.NON_UNIFORM;
    }

    @Override
    public void set(MerlinData md, Collection<? extends ICompElement> objs, IMaterial newVal) {
        super.set(md, CompElementActions.flattenToLocallyDefined(this.getProp(), objs), newVal);
    }

    @Override
    protected void set(MerlinData md, Object prop, ICompElement obj, IMaterial newVal) {
        IMaterial[] oldMats = this.getMats(md, prop, obj);
        if (oldMats.length == 1 && oldMats[0] == newVal) {
            return;
        }
        IGeomNode newGeom = (IGeomNode)obj.getProperty(ImportedGeom.PROP_GEOM);
        if (!MaterialProp.needsTexCoords(newVal)) {
            newGeom = newGeom.applyUniformProp(Elements.UV, Collections.emptyMap());
        } else {
            Set<String> uvSets = newVal.getAttributes().getUVSets();
            if (oldMats.length == 1) {
                ListMap<String, IElemSource<Point2d>> newUV = new ListMap<String, IElemSource<Point2d>>();
                for (String set : uvSets) {
                    newUV.put(set, DEFUV);
                }
                newGeom = newGeom.applyUniformProp(Elements.UV, newUV);
            } else {
                for (String uvSet : uvSets) {
                    newGeom = newGeom.applyUVElements(uvSet, (m, oldUV) -> {
                        IMaterial oldMat = oldMats[m];
                        return oldMat != newVal ? DEFUV : oldUV;
                    });
                }
            }
        }
        obj.setProperty(ImportedGeom.PROP_GEOM, newGeom);
        obj.setProperty(prop, new IMaterial[]{newVal});
    }

    private static boolean needsTexCoords(IMaterial mat) {
        if (mat == null) {
            return false;
        }
        for (MatChannel chnl : MatChannel.values()) {
            if (mat.getAttributes().getTexture(chnl) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void saveState(MerlinData md, Object prop, Collection<? extends ICompElement> objs, IMaterial newVal) {
        Undo.insertUndoEntry_propRestore(md, objs, ImportedGeom.PROP_DISPLAY_PROPS);
        Undo.insertUndoEntry_propRestore(md, objs, ImportedGeom.PROP_GEOM);
    }
}

