/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.builders.GotoActionBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditCommand;
import merlin.gui.MerlinUDF;
import merlin.mv.gui.LocationPanel;
import merlin.mv.gui.behaviors.ActionCreatePnl;
import merlin.mv.gui.behaviors.BehaviorPnl;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class NewGotoWaypointPnl
extends APropEditPanel<GotoActionBuilder> {
    private final MerlinUDF d_radiusFld = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);

    public NewGotoWaypointPnl() {
        super(GotoActionBuilder.ARRIVE_RADIUS_CHANGED);
        this.d_radiusFld.setColumns(8);
        guiPanel waypointLocPnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(waypointLocPnl);
        gb.addRow(Intl.intl("Location:"), new WaypointLocPanel());
        guiPanel waypointArrivePnl = new guiPanel();
        gb = new GridBagHelper(waypointArrivePnl);
        gb.addRow(Intl.intl("Arrival Radius:"), this.d_radiusFld);
        this.addSection(new BehaviorPnl());
        this.addSeparator();
        this.addSection(waypointLocPnl);
        this.addSeparator();
        this.addSection(waypointArrivePnl);
        this.addSeparator();
        this.addSection(new ActionCreatePnl());
    }

    @Override
    protected void updateFromProps(GotoActionBuilder props) {
        this.d_radiusFld.setValue(props.getArriveRadius());
    }

    @Override
    protected void updateToProps(GotoActionBuilder props) {
        props.setArriveRadius((UnitDouble)this.d_radiusFld.getValue());
    }

    private class WaypointLocPanel
    extends LocationPanel<GotoActionBuilder> {
        public WaypointLocPanel() {
            super(1, GotoActionBuilder.DEST_CHANGED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateToProps(GotoActionBuilder props) {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            try {
                UnitPoint3D specPoint = this.getValue();
                Point3d p1 = specPoint.getPoint3dValue(Geometry.LENGTH_UNIT);
                p1.z += 1.0E-6;
                AABox modelBounds = MerlinApp.getApp().getData().geomLocation.getBounds();
                Point3d p2 = new Point3d(p1.x, p1.y, modelBounds.getMinZ() - 1.0E-6);
                GeomUtil.FindResult findResult = GeomUtil.findRoom(MerlinApp.getApp().getData(), p1, p2, 1);
                IEgressOccupiable room = findResult != null ? findResult.room : null;
                Vector3d norm = findResult != null ? findResult.faceNormal : GeomConstants.VEC3D_ZPOS;
                UnitPoint3D p = findResult != null ? new UnitPoint3D(findResult.p, Geometry.LENGTH_UNIT) : specPoint;
                props.setWaypointDest(room, norm, p);
            }
            finally {
                md.endRead();
            }
        }

        @Override
        protected void updateFromProps(GotoActionBuilder props) {
            this.setValue(props.getDestLoc());
        }
    }
}

