/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.Component;
import java.util.concurrent.Semaphore;
import javax.swing.JButton;
import merlin.Intl;
import merlin.builders.AgentDropper;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.Behavior;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditCommand;
import merlin.gui.MerlinComboBox;
import merlin.mv.gui.LocationPanel;
import thunderheadeng.gui.GridBagHelper;

public class NewAgentPanel
extends APropEditPanel<AgentDropper> {
    private MerlinData d_data;
    private APropEditPanel<AgentDropper> d_createPanel;
    private APropEditPanel<AgentDropper> d_locPanel;
    private APropEditPanel<AgentDropper> d_propsPanel;

    public NewAgentPanel(MerlinData data) {
        super(new Object[0]);
        this.d_data = data;
        this.d_propsPanel = new PropsPanel(this.d_data);
        this.d_locPanel = new LocPanel();
        this.d_createPanel = new CreateBtPanel();
        this.addSection(this.d_propsPanel);
        this.addSeparator();
        this.addSection(this.d_locPanel);
        this.addSeparator();
        this.addSection(this.d_createPanel);
    }

    @Override
    public void setProps(AgentDropper props) {
        super.setProps(props);
        this.d_createPanel.setProps(props);
        this.d_locPanel.setProps(props);
        this.d_propsPanel.setProps(props);
    }

    private static class LocPanel
    extends LocationPanel<AgentDropper> {
        public LocPanel() {
            super(6, AgentDropper.LOC_CHANGED);
        }

        @Override
        protected void updateToProps(AgentDropper props) {
            ((AgentDropper)this.props()).setLocation(this.getValue());
        }

        @Override
        protected void updateFromProps(AgentDropper props) {
            this.setValue(props.getLocation());
        }
    }

    private static class PropsPanel
    extends APropEditPanel<AgentDropper> {
        private final MerlinData d_md;
        private final MerlinComboBox<OccProfile> d_profileCB;
        private final MerlinComboBox<Behavior> d_behaviorCB;
        private final Semaphore d_lock = new Semaphore(1);

        public PropsPanel(MerlinData md) {
            super(AgentDropper.PROFILE_CHANGED, AgentDropper.BEHAVIOR_CHANGED);
            this.d_md = md;
            this.d_profileCB = this.initComboBox(new MerlinComboBox(this.d_md, OccProfile.class, (IMerlinObj[])new OccProfile[0]));
            this.d_behaviorCB = this.initComboBox(new MerlinComboBox(this.d_md, Behavior.class, (IMerlinObj[])new Behavior[0]));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Profile:"), this.d_profileCB, 1.0);
            gb.addRow(Intl.intl("Behavior:"), this.d_behaviorCB, 1.0);
        }

        @Override
        protected void updateFromProps(AgentDropper props) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            this.d_profileCB.setSelectedItem(props.getProfile());
            this.d_behaviorCB.setSelectedItem(props.getBehavior());
            this.d_lock.release();
        }

        @Override
        protected void updateToProps(AgentDropper props) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            props.pause();
            props.setProfile((OccProfile)this.d_profileCB.getSelectedItem());
            props.setBehavior((Behavior)this.d_behaviorCB.getSelectedItem());
            props.resume();
            this.d_lock.release();
        }
    }

    private static class CreateBtPanel
    extends APropEditPanel<AgentDropper> {
        private JButton d_createBtn = this.initButton(new JButton(Intl.intl("Create")), new IPropEditCommand(){

            @Override
            public void updateProp(Component c, boolean hardValidate) {
                if (!this.validateData(hardValidate, hardValidate)) {
                    return;
                }
                ((AgentDropper)this.props()).createAndAddAgent(c);
            }
        });

        public CreateBtPanel() {
            super(AgentDropper.LOC_CHANGED, AgentDropper.PROFILE_CHANGED);
            this.add(this.d_createBtn);
        }

        @Override
        protected void updateFromProps(AgentDropper props) {
            this.d_createBtn.setEnabled(props.canCreate());
        }

        @Override
        protected void updateToProps(AgentDropper props) {
        }
    }
}

