/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.actions.InfernoGeomBuilder;
import merlin.actions.InfernoUtil;
import merlin.data.MerlinData;
import merlin.data.egress.SimError;
import merlin.data.egress.geom.EgressRoom;
import merlin.geom.IMerlinGeomSrc;
import merlin.io.inferno.InfernoGeom;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Triangulation;
import thunderheadeng.scene3d.nativebuffered.GenericActor;

public class NavMeshTriDisplay
extends GenericActor {
    private static final long serialVersionUID = 3833210511036298391L;

    public NavMeshTriDisplay() {
        this.setFaceColor(Color.GREEN);
        this.setEdgeColor(Color.BLACK);
        this.setPointSize(5.0);
        this.setVertexColor(Color.BLACK);
    }

    public void regenerateDisplay(MerlinData data) {
        this.resetData();
        List<InfernoGeom> igeoms = InfernoUtil.collectInfernoGeom(data);
        ArrayList<SimError> errors = new ArrayList<SimError>();
        for (InfernoGeomBuilder igb : InfernoUtil.constructMeshes(data, igeoms, errors)) {
            List<Point3d> points = igb.getPoints();
            List<InfernoGeomBuilder.NavTriangle> tri = igb.getTriangles();
            for (InfernoGeomBuilder.NavTriangle nt : tri) {
                IMerlinGeomSrc src;
                InfernoGeom igeom = nt.getBestSource();
                if (!(igeom.source instanceof IMerlinGeomSrc) || !(src = (IMerlinGeomSrc)((Object)igeom.source)).isVisible()) continue;
                Point3d p1 = points.get(nt.i1);
                Point3d p2 = points.get(nt.i2);
                Point3d p3 = points.get(nt.i3);
                this.addLine(p1, p2);
                this.addLine(p2, p3);
                this.addLine(p3, p1);
                this.addPoint(p1);
                this.addPoint(p2);
                this.addPoint(p3);
            }
        }
        for (SimError error : errors) {
            System.err.printf("[%s] %s%n", error.level.toString(), error.cause);
        }
        this.finalizeData();
    }

    public void regenerateDisplay__l(MerlinData data) {
        this.resetData();
        Face.RefinementOptions refOptions = data.simParams.getFaceRefinementOptions();
        Collection<EgressRoom> rooms = data.floors.getDeepMembers(EgressRoom.class);
        for (EgressRoom room : rooms) {
            Model m = room.getModel();
            for (Face f : m.getFaces()) {
                Triangulation t = f.triangulate(refOptions);
                for (int i = 0; i < t.tris.length; i += 3) {
                    Point3d p1 = t.verts[t.tris[i]];
                    Point3d p2 = t.verts[t.tris[i + 1]];
                    Point3d p3 = t.verts[t.tris[i + 2]];
                    Point3d mp = new Point3d((p1.x + p2.x + p3.x) / 3.0, (p1.y + p2.y + p3.y) / 3.0, (p1.z + p2.z + p3.z) / 3.0);
                    Vector3d normal = new Vector3d(f.plane.getNormal());
                    normal.normalize();
                    normal.scale(0.5);
                    Point3d mpOut = new Point3d(mp);
                    mpOut.add(normal);
                    this.addLine(p1, p2);
                    this.addLine(p2, p3);
                    this.addLine(p3, p1);
                    this.addPoint(p1);
                    this.addPoint(p2);
                    this.addPoint(p3);
                    this.addLine(mp, mpOut, Color.RED);
                }
            }
        }
        this.finalizeData();
    }
}

