/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.scripting.Behavior;
import merlin.mv.displays.AMerlinDispMgr;
import merlin.mv.displays.AgentDisplay;
import merlin.mv.displays.AgentDisplayType;
import merlin.mv.displays.AgentRenderer;
import merlin.mv.displays.scenefinders.DefSceneFinder;
import thunderheadeng.geometry.AABox;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Predicates;

public class AgentDispMgr
extends AMerlinDispMgr<EgressAgent, AgentDisplay> {
    private final AgentRenderer d_renderer;
    private final AgentDisplayType d_type;

    public AgentDispMgr(MerlinData data, ModelScene egressScene, AgentRenderer ar, AgentDisplayType type) {
        super(data, EgressAgent.class, type.getFilter(), new DefSceneFinder(egressScene));
        this.d_renderer = ar;
        this.d_type = type;
    }

    public AABox getBoundingBox(Collection<EgressAgent> agents) {
        if (agents.isEmpty()) {
            return new AABox();
        }
        ArrayList<AgentDisplay> displays = new ArrayList<AgentDisplay>(agents.size());
        for (EgressAgent agent : agents) {
            AgentDisplay display = (AgentDisplay)this.getDisplay(agent);
            if (display == null) continue;
            displays.add(display);
        }
        return this.d_renderer.getBoundingBox(displays);
    }

    @Override
    protected void addDisplays(ModelScene scene, Collection<? extends EgressAgent> objs, Collection<AgentDisplay> disps) {
        this.d_renderer.addDisplays(disps);
        this.updateSelection(objs);
    }

    @Override
    protected void removeDisplays(ModelScene scene, Collection<AgentDisplay> disps) {
        this.d_renderer.removeDisplays(disps);
    }

    @Override
    protected AgentDisplay createDisplay(EgressAgent obj, boolean visible, boolean selected) {
        AgentDisplay disp = new AgentDisplay(this.d_type, obj);
        disp.setVisible(visible);
        return disp;
    }

    public Object getSelectionObj() {
        return null;
    }

    protected List<AgentDisplay> getAgentDisplays(Collection<? extends EgressAgent> objs) {
        ArrayList<AgentDisplay> displays = new ArrayList<AgentDisplay>(objs.size());
        for (EgressAgent egressAgent : objs) {
            AgentDisplay disp = (AgentDisplay)this.getDisplay(egressAgent);
            assert (disp != null);
            displays.add(disp);
        }
        return displays;
    }

    @Override
    public void update(Events events) {
        Predicate filter = this.getFilter();
        if (!Predicates.alwaysTrue(filter)) {
            IEventRecord oevts = events.getEvents(this.getType(), new Class[0]);
            ArrayList<EgressAgent> added = new ArrayList<EgressAgent>();
            ArrayList<EgressAgent> removed = new ArrayList<EgressAgent>();
            for (EgressAgent agent : oevts.getChangedObjs(EgressAgent.PROFILE)) {
                boolean shouldDisplay;
                boolean isDisplayed = this.getDisplay(agent) != null;
                if (isDisplayed == (shouldDisplay = filter.test(agent))) continue;
                if (isDisplayed) {
                    removed.add(agent);
                    continue;
                }
                added.add(agent);
            }
            this.addDisplays(added);
            this.removeDisplays(removed);
        }
        super.update(events);
        ArrayList<EgressAgent> updateAgents = new ArrayList<EgressAgent>();
        Set<Behavior> changedBehaviors = events.getEvents(Behavior.class, new Class[0]).getChangedObjs(new Object[0]);
        if (!changedBehaviors.isEmpty()) {
            for (EgressAgent agent : this.getObjs()) {
                if (!changedBehaviors.contains(agent.getBehavior())) continue;
                updateAgents.add(agent);
            }
        }
        this.updateDisplays((Collection<? extends EgressAgent>)updateAgents);
    }

    @Override
    public void updateDisplays(Collection<? extends EgressAgent> objs) {
        if (objs.isEmpty()) {
            return;
        }
        for (EgressAgent egressAgent : objs) {
            AgentDisplay disp = (AgentDisplay)this.getDisplay(egressAgent);
            disp.update();
            disp.setVisible(this.isVisible(egressAgent));
        }
        this.d_renderer.agentsUpdated(this.getAgentDisplays(objs), 1);
        this.updateSelection(objs);
    }

    @Override
    protected void updateVisibility(Collection<? extends EgressAgent> objs) {
        ArrayList<AgentDisplay> displays = new ArrayList<AgentDisplay>(objs.size());
        for (EgressAgent egressAgent : objs) {
            AgentDisplay display = (AgentDisplay)this.getDisplay(egressAgent);
            assert (display != null);
            display.setVisible(this.isVisible(egressAgent));
            displays.add(display);
        }
        this.d_renderer.agentsUpdated(displays, 2);
    }

    @Override
    protected void updateSelection(Collection<? extends EgressAgent> objs) {
        ArrayList<AgentDisplay> displays = new ArrayList<AgentDisplay>(objs.size());
        boolean[] selection = new boolean[objs.size()];
        int ix = 0;
        for (EgressAgent egressAgent : objs) {
            AgentDisplay disp = (AgentDisplay)this.getDisplay(egressAgent);
            assert (disp != null);
            displays.add(disp);
            selection[ix++] = this.isSelected(egressAgent);
        }
        this.d_renderer.updateAgentSelection(displays, selection);
    }

    @Override
    protected void updateDisplay(EgressAgent obj, AgentDisplay disp) {
        assert (false);
    }

    @Override
    protected void updateSelection(EgressAgent obj, AgentDisplay display) {
        assert (false);
    }

    @Override
    protected void updateVisibility(EgressAgent obj, AgentDisplay display) {
        assert (false);
    }
}

