/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import merlin.data.DisplayFilter;
import merlin.data.MerlinData;
import merlin.mv.displays.IMerlinDispMgr;
import merlin.mv.displays.IMerlinDisplay;
import merlin.mv.displays.scenefinders.ISceneFinder;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public abstract class AMerlinDispMgr<MerlinT, DispT extends IMerlinDisplay>
implements IMerlinDispMgr<MerlinT> {
    private final MerlinData d_md;
    private final Class<MerlinT> d_type;
    private final Predicate<MerlinT> d_filter;
    private final ISceneFinder<MerlinT> d_sceneFinder;
    private Map<MerlinT, DispT> d_dispMap = new LinkedIdentityHashMap<MerlinT, DispT>();

    public AMerlinDispMgr(MerlinData md, Class<MerlinT> type, ISceneFinder<MerlinT> sceneFinder) {
        this(md, type, Filters.acceptAll(), sceneFinder);
    }

    public AMerlinDispMgr(MerlinData md, Class<MerlinT> type, Predicate<MerlinT> filter, ISceneFinder<MerlinT> sceneFinder) {
        this.d_md = md;
        this.d_sceneFinder = sceneFinder;
        this.d_type = type;
        this.d_filter = filter;
    }

    public MerlinData getData() {
        return this.d_md;
    }

    @Override
    public Class<MerlinT> getType() {
        return this.d_type;
    }

    protected abstract DispT createDisplay(MerlinT var1, boolean var2, boolean var3);

    @Override
    public Predicate<MerlinT> getFilter() {
        return this.d_filter;
    }

    protected List<IDisplayable> getDisplays(Collection<DispT> disps) {
        ArrayList<IDisplayable> displays = new ArrayList<IDisplayable>(disps.size());
        for (IMerlinDisplay obj : disps) {
            displays.addAll(Arrays.asList(obj.getDisplayObjs()));
        }
        return displays;
    }

    protected void addDisplays(ModelScene scene, Collection<? extends MerlinT> objs, Collection<DispT> disps) {
        scene.addObjects(this.getDisplays(disps));
    }

    protected void removeDisplays(ModelScene scene, Collection<DispT> disps) {
        scene.removeObjects(this.getDisplays(disps));
    }

    @Override
    public void updateAll() {
        this.updateDisplays((Collection<? extends MerlinT>)this.getObjs());
    }

    public DispT getDisplay(MerlinT obj) {
        return (DispT)((IMerlinDisplay)this.d_dispMap.get(obj));
    }

    public Collection<DispT> getDisplays() {
        return this.d_dispMap.values();
    }

    public Collection<MerlinT> getObjs() {
        return this.d_dispMap.keySet();
    }

    @Override
    public void update(Events events) {
        IEventRecord<MerlinT> oevts = events.getEvents(this.getType(), new Class[0]).filter(this.d_filter);
        this.addDisplays((Collection<? extends MerlinT>)oevts.getAddedObjs());
        this.removeDisplays((Collection<? extends MerlinT>)oevts.getRemovedObjs());
        this.updateDisplays(oevts);
        if (this.updateVis(events)) {
            this.updateVisibility(this.getObjs());
        }
    }

    private boolean updateVis(Events events) {
        for (EventChannel<DisplayFilter> channel : events.getAffectedChannels(DisplayFilter.class, new Class[0])) {
            Set<Object> changedTypes = channel.getChanges();
            for (Object type : changedTypes) {
                if (!(type instanceof Class) || !((Class)type).isAssignableFrom(this.getType())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDisplays(Collection<? extends MerlinT> objs) {
        ModelScene[] scenes;
        if (objs.isEmpty()) {
            return;
        }
        for (ModelScene scene : scenes = this.d_sceneFinder.getPossibleScenes()) {
            IFilteredCollection sobjs = theUtil.filter(objs, this.getType(), this.d_sceneFinder.getFilter(scene));
            ArrayList<DispT> displays = new ArrayList<DispT>(sobjs.size());
            for (Object obj : sobjs) {
                assert (!this.d_dispMap.containsKey(obj));
                DispT disp = this.createDisplay(obj, this.isVisible(obj), this.isSelected(obj));
                this.d_dispMap.put(obj, disp);
                displays.add(disp);
            }
            this.addDisplays(scene, sobjs, displays);
        }
    }

    @Override
    public void removeDisplays(Collection<? extends MerlinT> objs) {
        if (objs.isEmpty()) {
            return;
        }
        ArrayList<IMerlinDisplay> disps = new ArrayList<IMerlinDisplay>(objs.size());
        for (MerlinT obj : objs) {
            IMerlinDisplay disp = (IMerlinDisplay)this.d_dispMap.remove(obj);
            assert (disp != null);
            disps.add(disp);
        }
        for (ModelScene scene : this.d_sceneFinder.getPossibleScenes()) {
            this.removeDisplays(scene, disps);
        }
    }

    @Override
    protected void updateDisplays(IEventRecord<? extends MerlinT> events) {
        Set<? extends MerlinT> visObjs = events.getChangedObjs(MerlinData.VISIBILITY);
        Set<? extends MerlinT> selObjs = events.getChangedObjs(MerlinData.SELECTION_CHANGED);
        Set<MerlinT> genObjs = events.getChangedNotOfType(MerlinData.SELECTION_CHANGED, MerlinData.VISIBILITY);
        if (!genObjs.isEmpty()) {
            LinkedIdentityHashSet<Object> tobjs = new LinkedIdentityHashSet<MerlinT>(visObjs);
            tobjs.removeAll(genObjs);
            visObjs = tobjs;
            tobjs = new LinkedIdentityHashSet<MerlinT>(selObjs);
            tobjs.removeAll(genObjs);
            selObjs = tobjs;
        }
        this.updateVisibility(visObjs);
        this.updateSelection(selObjs);
        this.updateDisplays((Collection<? extends MerlinT>)genObjs);
    }

    @Override
    public void updateDisplays(Collection<? extends MerlinT> objs) {
        for (MerlinT obj : objs) {
            DispT disp = this.getDisplay(obj);
            if (disp == null) continue;
            this.updateDisplay(obj, disp);
        }
    }

    protected void updateDisplay(MerlinT obj, DispT disp) {
        disp.update();
        this.updateSelection(obj, disp);
        this.updateVisibility(obj, disp);
    }

    protected void updateVisibility(Collection<? extends MerlinT> objs) {
        for (MerlinT obj : objs) {
            DispT display = this.getDisplay(obj);
            if (display == null) continue;
            this.updateVisibility(obj, display);
        }
    }

    protected void updateVisibility(MerlinT obj, DispT display) {
        display.setVisible(this.isVisible(obj));
    }

    protected boolean isVisible(MerlinT obj) {
        return this.d_md.isVisible(obj);
    }

    protected void updateSelection(Collection<? extends MerlinT> objs) {
        for (MerlinT obj : objs) {
            DispT display = this.getDisplay(obj);
            if (display == null) continue;
            this.updateSelection(obj, display);
        }
    }

    protected void updateSelection(MerlinT obj, DispT display) {
        display.setSelected(this.isSelected(obj));
    }

    protected boolean isSelected(MerlinT obj) {
        return this.d_md.selection.isSelected(obj) || this.d_md.selection.isProxySelected(obj);
    }

    @Override
    public void removeAll() {
        for (ModelScene scene : this.d_sceneFinder.getPossibleScenes()) {
            scene.removeAllObjects();
        }
        this.d_dispMap.clear();
    }

    protected List<DispT> getDisplays(ModelScene scene, Collection<? extends MerlinT> objs) {
        IFilteredCollection sobjs = theUtil.filter(objs, this.getType(), this.d_sceneFinder.getFilter(scene));
        ArrayList<IMerlinDisplay> displays = new ArrayList<IMerlinDisplay>(sobjs.size());
        for (Object obj : sobjs) {
            IMerlinDisplay disp = (IMerlinDisplay)this.d_dispMap.get(obj);
            if (disp == null) continue;
            displays.add(disp);
        }
        return displays;
    }

    @Override
    public void removeFromScene(Collection<? extends MerlinT> objs) {
        for (ModelScene scene : this.d_sceneFinder.getPossibleScenes()) {
            this.removeDisplays(scene, this.getDisplays(scene, objs));
        }
    }

    @Override
    public void addToScene(Collection<? extends MerlinT> objs) {
        for (ModelScene scene : this.d_sceneFinder.getPossibleScenes()) {
            this.addDisplays(scene, objs, this.getDisplays(scene, objs));
        }
    }

    @Override
    public void setTransform(Matrix4d xform) {
        for (ModelScene scene : this.d_sceneFinder.getPossibleScenes()) {
            scene.setTransform(xform);
        }
    }
}

