/*
 * Decompiled with CFR 0.152.
 */
package merlin.manip;

import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.geom.Geometry;
import merlin.manip.ATransformManip;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitPoint3D;

public class TranslateManip
extends ATransformManip {
    private UnitPoint3D d_moveVec = null;

    public void setMoveVec(UnitPoint3D moveVec) {
        if (!this.lock()) {
            return;
        }
        this.d_moveVec = moveVec;
        this.firePropChanged(TRANSFORM_CHANGED);
        this.release();
    }

    public UnitPoint3D getMoveVec() {
        return this.d_moveVec;
    }

    @Override
    public boolean canTransform() {
        return this.d_moveVec != null && this.d_moveVec.getVector3dValue(Geometry.LENGTH_UNIT).lengthSquared() > 0.0;
    }

    @Override
    protected void reset() {
        this.d_moveVec = null;
    }

    @Override
    protected String getActionName() {
        return Intl.intl("Move");
    }

    @Override
    protected ITransform getXform(int ix) {
        Unit u = Geometry.LENGTH_UNIT;
        Vector3d moveVec = this.d_moveVec.getVector3dValue(u);
        moveVec.scale(ix + 1);
        return TransformUtil.translate(moveVec.x, moveVec.y, moveVec.z);
    }
}

