/*
 * Decompiled with CFR 0.152.
 */
package merlin.manip;

import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.actions.TransformAction;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import merlin.manip.ATransformManip;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class RotateManip
extends ATransformManip {
    private final MerlinData d_data;
    private Vector3d d_axis = null;
    private UnitPoint3D d_base = null;
    private UnitDouble d_angle = null;

    public RotateManip(MerlinData md) {
        this.d_data = md;
        this.d_angle = new UnitDouble(0.0, NonSI.DEGREE_ANGLE);
        this.d_base = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
        this.d_axis = new Vector3d(0.0, 0.0, 1.0);
    }

    @Override
    public void setSelection(Collection<? extends IMerlinObj> objs) {
        this.pause();
        super.setSelection(objs);
        if (this.getNumCopies() == 0) {
            this.setBaseToCenter();
        }
        this.resume();
    }

    public void setRotateAxis(Vector3d rotAxis) {
        if (!this.lock()) {
            return;
        }
        this.d_axis = new Vector3d(rotAxis);
        this.firePropChanged(TRANSFORM_CHANGED);
        this.release();
    }

    public Vector3d getAxis() {
        return this.d_axis;
    }

    public void setBaseToCenter() {
        AABox bounds = new AABox();
        for (IMerlinGeomSrc obj : TransformAction.getGeom(this.d_data, this.getSelection())) {
            bounds.add(obj.getBounds());
        }
        this.setBase(new UnitPoint3D(bounds.getCenter(), Geometry.LENGTH_UNIT));
    }

    public void setBase(UnitPoint3D base) {
        if (!this.lock()) {
            return;
        }
        this.d_base = base;
        this.firePropChanged(TRANSFORM_CHANGED);
        this.release();
    }

    public UnitPoint3D getBase() {
        return this.d_base;
    }

    public void setAngle(UnitDouble angle) {
        if (!this.lock()) {
            return;
        }
        this.d_angle = angle;
        this.firePropChanged(TRANSFORM_CHANGED);
        this.release();
    }

    public UnitDouble getAngle() {
        return this.d_angle;
    }

    @Override
    public boolean canTransform() {
        return this.d_axis.lengthSquared() > 0.0 && this.d_angle.getValueNoUnit() != 0.0;
    }

    @Override
    protected void reset() {
        this.d_angle = new UnitDouble(0.0, NonSI.DEGREE_ANGLE);
    }

    @Override
    protected String getActionName() {
        return Intl.intl("Rotate");
    }

    @Override
    protected ITransform getXform(int ix) {
        Point3d base = this.d_base.getPoint3dValue(Geometry.LENGTH_UNIT);
        double angle = (double)(ix + 1) * this.d_angle.getValue(Geometry.ANGLE_UNIT);
        ITransform xform = TransformUtil.translate(base.x, base.y, base.z);
        xform = xform.concatenate(TransformUtil.rotate(this.d_axis.x, this.d_axis.y, this.d_axis.z, angle));
        xform = xform.concatenate(TransformUtil.translate(-base.x, -base.y, -base.z));
        return xform;
    }
}

