/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinPrefs;
import merlin.actions.NewObject;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.property.INamedProp;
import merlin.gui.ManagerDlg;
import merlin.gui.NewActionListener;
import merlin.gui.ProfilesPanel;
import merlin.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.IPropertySet;

public class ProfilesDlg
extends ManagerDlg<OccProfile, ManagerDlg.IManager<OccProfile>> {
    private final IEditor<OccProfile> d_editor;
    private ManagerDlg.IManager<OccProfile> d_mgr;

    public ProfilesDlg(JFrame owner, UnitSystem uSys) {
        super(owner, Intl.intl("Edit Profiles"), OccProfile.class);
        this.d_editor = new ProfilesPanel(owner);
        String newMsg = Intl.intl("New Profile");
        this.d_actions = new Action[]{this.newAction(new NewActionListener<OccProfile>(NewObject.NEW_PROFILE_OP)), new ManagerDlg.LibraryAction(), new ManagerDlg.RenameAction(OccProfile.PROP_NAME, newMsg, md -> md.profiles), new ManagerDlg.DeleteAction()};
        this.updateActions();
    }

    @Override
    protected boolean validateEditor(IEditor<OccProfile> editor, boolean showWarn, boolean allowModify) {
        boolean modified = this.d_editor.isModified();
        if (!super.validateEditor(editor, showWarn, allowModify)) {
            return false;
        }
        if (modified) {
            int ix = this.d_edix;
            OccProfile prof = (OccProfile)this.getList().getItem(ix);
            if (prof != null && !this.validateProfile(prof, showWarn, allowModify)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateProfile(OccProfile prof, boolean showWarn, boolean allowModify) {
        if (!showWarn) {
            return true;
        }
        boolean showProfWarn = MerlinPrefs.getBoolean(MerlinPrefs.ShowCustomProfilesWarning);
        if (showProfWarn) {
            this.getMerlinData().beginRead();
            try {
                Map<INamedProp, List<EgressAgent>> localPropMap = this.getLocalPropsMap(prof);
                if (!localPropMap.isEmpty()) {
                    String msg;
                    if (localPropMap.size() == 1) {
                        Map.Entry<INamedProp, List<EgressAgent>> entry = localPropMap.entrySet().iterator().next();
                        String dispName = entry.getKey().getDisplayName();
                        msg = entry.getValue().size() == 1 ? String.format(Intl.intl("Occupant <b>%1$s</b> has a custom <b>%2$s</b> defined and will not be<br>affected by the %3$s change."), entry.getValue().get(0).getName(), dispName, dispName) : String.format(Intl.intl("%1$d occupants have a custom <b>%2$s</b> defined and will not be<br>affected by the %3$s change."), entry.getValue().size(), dispName, dispName);
                    } else {
                        HashSet modifiedAgents = new HashSet();
                        for (List list : localPropMap.values()) {
                            modifiedAgents.addAll(list);
                        }
                        msg = modifiedAgents.size() == 1 ? String.format(Intl.intl("Occupant <b>%s</b> has custom profile parameters defined and might not be<br>affected by the profile changes."), ((EgressAgent)modifiedAgents.iterator().next()).getName()) : String.format(Intl.intl("%d occupants have profile parameters defined and might not be<br>affected by the profile changes."), modifiedAgents.size());
                    }
                    msg = "<html>" + msg + "</html>";
                    guiCheckBox neverShowCB = new guiCheckBox(Intl.intl("Do not show this message again."));
                    guiPanel panel = new guiPanel();
                    GridBagHelper gridBagHelper = new GridBagHelper(panel);
                    gridBagHelper.addFilledRow(msg);
                    gridBagHelper.addFilledRow(neverShowCB);
                    gridBagHelper.finalizeRows();
                    JOptionPane.showMessageDialog(this, panel, Intl.intl("Custom Agents"), 2);
                    MerlinPrefs.set(MerlinPrefs.ShowCustomProfilesWarning, !neverShowCB.isSelected());
                }
            }
            finally {
                this.getMerlinData().endRead();
            }
        }
        return true;
    }

    private Map<INamedProp, List<EgressAgent>> getLocalPropsMap(OccProfile prof) {
        Collection<INamedProp> changes = ((ProfilesPanel)this.d_editor).getChanges(prof);
        if (changes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<INamedProp, List<EgressAgent>> localPropMap = new HashMap<INamedProp, List<EgressAgent>>();
        for (EgressAgent agent : this.getMerlinData().agents.getDeepMembers(EgressAgent.class)) {
            if (agent.getProfile().getProfParent() != prof) continue;
            for (INamedProp prop : changes) {
                if (!(prop instanceof IPropertySet.Prop) || !agent.getProfile().isDefinedLocally((IPropertySet.Prop)((Object)prop))) continue;
                localPropMap.computeIfAbsent(prop, k -> new ArrayList()).add(agent);
            }
        }
        return localPropMap;
    }

    public void init(MerlinData md, ManagerDlg.IManager<OccProfile> mgr, OccProfile init) {
        this.d_mgr = mgr;
        super.init(md, this.d_mgr, this.d_editor, this.d_actions);
        this.updateActions();
        if (init != null) {
            this.getList().select(init);
        }
    }

    @Override
    public void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[1].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
        this.d_actions[3].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1 && this.getList().getNumItems() > 1);
    }
}

