/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Optional;
import javax.swing.SwingUtilities;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.data.material.MaterialDB;
import merlin.gui.guiUtil;
import thunderheadeng.gui.ImageBtn;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.image.IImage;

public class ImageBtnListener
implements ActionListener {
    public static final ImageBtnListener INSTANCE = new ImageBtnListener();

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof ImageBtn) {
            this.chooseNewImage((ImageBtn)src);
        }
    }

    public boolean chooseNewImage(ImageBtn btn) {
        guiFileChooser chooser = btn.getImage() == null ? guiUtil.getChooser(MerlinPrefs.OPEN_DIR_PREF, Optional.empty(), MerlinApp.getApp().getData().materials.getFileFilters()) : guiUtil.getChooser(MerlinPrefs.OPEN_DIR_PREF, Optional.of(btn.getImage().getFilename()), MerlinApp.getApp().getData().materials.getFileFilters());
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(btn)) != 0) {
            return false;
        }
        File f = chooser.getSelectedFile();
        IImage img = MaterialDB.loadImage(f.getAbsolutePath());
        if (img == null) {
            return false;
        }
        if (img != btn.getImage()) {
            btn.setImage(img);
            btn.setModified(true);
        }
        return true;
    }
}

