/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import merlin.data.value.ConstVariant;
import merlin.data.value.DiscreteVariant;
import merlin.data.value.IVariant;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;

public class VariantUtil {
    public static <ValType> IVariant<ValType> newVariant(List<DiscreteVariant.Entry<ValType>> vals) {
        assert (vals.size() >= 1 && vals.get((int)0).t.getValue(SI.SECOND) == 0.0);
        Object initVal = vals.get((int)0).val;
        if (vals.size() == 1) {
            return VariantUtil.newVariant(initVal, new DiscreteVariant.Entry[0]);
        }
        ArrayList<DiscreteVariant.Entry<ValType>> entries = new ArrayList<DiscreteVariant.Entry<ValType>>(vals);
        entries.remove(0);
        return VariantUtil.newVariant(initVal, entries);
    }

    public static <ValType> IVariant<ValType> newVariant(ValType initVal, DiscreteVariant.Entry<ValType> ... vals) {
        return VariantUtil.newVariant(initVal, Arrays.asList(vals));
    }

    public static <ValType> IVariant<ValType> newVariant(ValType initVal, List<DiscreteVariant.Entry<ValType>> vals) {
        vals = new ArrayList<DiscreteVariant.Entry<ValType>>(vals);
        Collections.sort(vals);
        if (!vals.isEmpty() && vals.get((int)0).t.equals(new UnitDouble(0.0, SI.SECOND))) {
            initVal = vals.get((int)0).val;
            vals = vals.subList(1, vals.size());
        }
        if (vals.isEmpty()) {
            return new ConstVariant<ValType>(initVal);
        }
        return new DiscreteVariant<ValType>(initVal, vals.toArray(new DiscreteVariant.Entry[vals.size()]));
    }

    public static <ValType> ValType getInitialValue(IVariant<ValType> var) {
        if (var instanceof ConstVariant) {
            return ((ConstVariant)var).value;
        }
        if (var instanceof DiscreteVariant) {
            return ((DiscreteVariant)var).initVal;
        }
        return null;
    }

    public static <ValType> IVariant<ValType> setInitialValue(IVariant<ValType> var, ValType initVal) {
        if (var instanceof ConstVariant) {
            return VariantUtil.newVariant(initVal, new DiscreteVariant.Entry[0]);
        }
        if (var instanceof DiscreteVariant) {
            return VariantUtil.newVariant(initVal, ((DiscreteVariant)var).entries);
        }
        return null;
    }

    public static <ValType> List<DiscreteVariant.Entry<ValType>> getDiscreteValues(IVariant<ValType> var, boolean includeT0) {
        ValType initVal;
        if (var instanceof DiscreteVariant) {
            DiscreteVariant dvar = (DiscreteVariant)var;
            if (includeT0) {
                ArrayList<DiscreteVariant.Entry<ValType>> entries = new ArrayList<DiscreteVariant.Entry<ValType>>(1 + dvar.entries.length);
                entries.add(new DiscreteVariant.Entry(new UnitDouble(0.0, SI.SECOND), dvar.initVal));
                entries.addAll(Arrays.asList(dvar.entries));
                return entries;
            }
            return Arrays.asList(dvar.entries);
        }
        if (includeT0 && (initVal = VariantUtil.getInitialValue(var)) != null) {
            return Collections.singletonList(new DiscreteVariant.Entry<ValType>(new UnitDouble(0.0, SI.SECOND), initVal));
        }
        return Collections.EMPTY_LIST;
    }
}

