/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.queues;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.MerlinApp;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.geom.GeomUtil;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;

public class QueuePathNode
extends NamedMerlinObj
implements IQueueElement,
IEgressObj {
    static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<Point3d> PROP_LOCATION = new IPropertySet.Prop<Point3d>("QueuePathNode.LOCATION", new Point3d());
    public static final IPropertySet.Prop<Vector3d> PROP_NORMAL = new IPropertySet.Prop<Vector3d>("QueuePathNode.NORMAL", GeomConstants.VEC3D_ZPOS);
    public static final Set<Object> PROP_TYPES = new LinkedHashSet<Object>();
    private PropertySet d_props = new PropertySet();
    private boolean d_visible;
    private transient IEgressOccupiable d_room;

    public QueuePathNode(String name, Point3d location, IEgressOccupiable room, Vector3d faceNormal) {
        super(name);
        this.d_props.set(PROP_LOCATION, location);
        this.d_props.set(PROP_NORMAL, faceNormal);
        this.d_visible = true;
        this.d_room = room;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    public Point3d getLocation() {
        return this.getProperty(PROP_LOCATION);
    }

    private void setLocation(Point3d loc) {
        this.setProperty(PROP_LOCATION, loc);
        this.changedEvt(new Object[0]);
    }

    public void setLocationAndUpdateRoom(Point3d loc) {
        if (this.getDomain() != null) {
            GeomUtil.FindResult room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(loc.x, loc.y, loc.z + 1.0E-6), new Point3d(loc.x, loc.y, loc.z - 1.0E-6), 1);
            if (room != null) {
                this.setLocation(room.room, room.faceNormal, loc);
            } else {
                this.setLocation(null, GeomConstants.VEC3D_ZPOS, loc);
            }
        }
    }

    public void setLocation(IEgressOccupiable room, Vector3d normal, Point3d loc) {
        this.setLocation(loc);
        this.setFaceNormal(normal);
        if (room != null && this.getDomain() != null) {
            if (this.d_room != null) {
                this.d_room.disconnectFrom(this);
                this.disconnectFrom(this.d_room);
            }
            room.connectTo(this);
        }
        this.d_room = room;
    }

    public Vector3d getFaceNormal() {
        return this.getProperty(PROP_NORMAL);
    }

    public void setFaceNormal(Vector3d normal) {
        this.setProperty(PROP_NORMAL, normal);
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NAME) {
            return this.getName();
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property instanceof IPropertySet.Prop) {
            return this.getProperty((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    public <T> T getProperty(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.setProperty((IPropertySet.Prop)property, value);
        }
        if (property == NAME) {
            this.setName((String)value);
        }
        if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        }
    }

    public <T> void setProperty(IPropertySet.Prop<T> prop, T value) {
        this.d_props.set(prop, value);
        this.changedEvt(prop);
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        this.pauseUpdates();
        if (geom instanceof PathNodeGeom) {
            PathNodeGeom nGeom = (PathNodeGeom)geom;
            this.setLocation(nGeom.room, nGeom.normal, nGeom.loc);
        } else if (geom instanceof Point) {
            this.setLocationAndUpdateRoom(((Point)geom).loc);
        }
        this.resumeUpdates();
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(new PathNodeGeom(this.getRoom(), this.getFaceNormal(), this.getLocation()));
    }

    @Override
    public QueuePathNode clone() {
        QueuePathNode clone = (QueuePathNode)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof QueuePathNode)) {
            return;
        }
        QueuePathNode n = (QueuePathNode)obj;
        this.pauseUpdates();
        this.d_props = n.d_props;
        this.changedEvt(new Object[0]);
        this.setVisible(n.isVisible());
        this.setLocation(n.getRoom(), n.getFaceNormal(), n.getLocation());
        this.resumeUpdates();
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder qpnProps = new PropsBuilder();
        qpnProps.add(new IPrimProps.Vertex(Color.BLACK, 12.0));
        return new DisplayGeom(geom, qpnProps);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_room == null ? Collections.EMPTY_LIST : Arrays.asList(this.d_room);
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_room == null;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_room) {
            this.d_room = null;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public void connectTo(IEgressObj conn) {
        if (conn instanceof IEgressOccupiable) {
            // empty if block
        }
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_room = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public boolean updateTopo() {
        GeomUtil.FindResult room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(this.getLocation().x, this.getLocation().y, this.getLocation().z + 1.0E-6), new Point3d(this.getLocation().x, this.getLocation().y, this.getLocation().z - 1.0E-6), 1);
        if (room != null) {
            this.setLocation(room.room, room.faceNormal, room.p);
            this.changedEvt(new Object[0]);
        }
        return true;
    }

    @Override
    public Point3d astarGetTestPoint() {
        return this.getLocation();
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.getLocation();
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.getLocation();
    }

    static {
        PROP_TYPES.add(NAME);
        PROP_TYPES.add(MerlinData.VISIBILITY);
        PROP_TYPES.add(PROP_LOCATION);
        PROP_TYPES.add(PROP_NORMAL);
    }

    private static class PathNodeManipHandle
    implements IHandle {
        private PathNodeGeom geom;

        public PathNodeManipHandle(PathNodeGeom geom) {
            this.geom = geom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof PathNodeManipHandle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(this.geom);
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            try {
                GeomUtil.FindResult room = GeomUtil.findRoom(MerlinApp.getApp().getData(), newLoc, 0);
                if (room == null) {
                    throw new ManipException();
                }
                PathNodeGeom pathNodeGeom = this.geom = new PathNodeGeom(room.room, room.faceNormal, newLoc);
                return pathNodeGeom;
            }
            finally {
                md.endRead();
            }
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }

    private static class PathNodeGeom
    extends Point {
        public final IEgressOccupiable room;
        public final Vector3d normal;

        public PathNodeGeom(IEgressOccupiable room, Vector3d normal, Point3d loc) {
            super(loc);
            this.room = room;
            this.normal = normal;
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            return Arrays.asList(new PathNodeManipHandle(this));
        }
    }
}

