/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.queues;

import java.awt.Color;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IOpacity;
import merlin.data.MerlinData;
import merlin.data.Opacity;
import merlin.data.egress.scripting.queues.IGotoQueueDestination;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.mv.displays.MerlinDispProps;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class QueueObject
extends GeomComposite<IQueueElement>
implements IGotoQueueDestination {
    static final long serialVersionUID = 1L;
    private Color d_color = theUtil.newRandomColor();
    private float d_transparency = 0.0f;
    public static final Set<Object> PROP_TYPES = new LinkedHashSet<Object>();
    private static final Predicate<ICompElement> s_filter;

    public QueueObject(String name) {
        super(name);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.changedEvt(new Object[0]);
    }

    public void setColor(Color c) {
        if (!theUtil.equal(this.d_color, c)) {
            this.d_color = c;
            for (IQueueElement elem : this.getMembers(IQueueElement.class)) {
                elem.changedEvt(MerlinData.COLOR);
            }
            this.changedEvt(MerlinData.COLOR);
        }
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setOpacity(float opacity) {
        float trans = 1.0f - opacity;
        if (theUtil.eq(trans, this.d_transparency, 0.0)) {
            return;
        }
        this.d_transparency = trans;
        for (IQueueElement elem : this.getMembers(IQueueElement.class)) {
            elem.changedEvt(MerlinData.OPACITY);
        }
        this.changedEvt(MerlinData.OPACITY);
    }

    public float getOpacity() {
        return 1.0f - this.d_transparency;
    }

    public Color getDisplayColor() {
        return MerlinDispProps.applyAlpha(this.getColor(), this.getOpacity());
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.COLOR) {
            this.setColor((Color)value);
        } else if (property == MerlinData.OPACITY) {
            this.setOpacity(((IOpacity)value).getValue());
        } else if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else assert (false) : "Unsupported Operation: <EgressAgent>.setProperty(" + property + ")";
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NAME) {
            return this.getName();
        }
        if (property == MerlinData.COLOR) {
            return this.getColor();
        }
        if (property == MerlinData.OPACITY) {
            return new Opacity(this.getOpacity());
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        return NOT_SUPPORTED;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof QueueObject)) {
            return;
        }
        QueueObject qo = (QueueObject)obj;
        this.pauseUpdates();
        super.restoreFrom(obj);
        this.setVisible(qo.isVisible());
        this.setOpacity(qo.getOpacity());
        this.setColor(qo.getColor());
        this.resumeUpdates();
    }

    @Override
    public void add(ICompElement obj) {
        if (!this.getFilter().test(obj)) {
            return;
        }
        super.add(obj);
    }

    @Override
    public void addAll(Collection<? extends ICompElement> objs) {
        super.addAll(theUtil.filter(objs, IQueueElement.class));
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return null;
    }

    static {
        PROP_TYPES.add(NAME);
        PROP_TYPES.add(MerlinData.COLOR);
        PROP_TYPES.add(MerlinData.OPACITY);
        PROP_TYPES.add(MerlinData.VISIBILITY);
        s_filter = new TypeFilter<ICompElement>(QueuePath.class, QueueService.class);
    }
}

