/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.SimError;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;

public class GotoExits
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction,
IDirectDependent {
    static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<Set<EgressDoor>> PROP_EXITS = new IPropertySet.Prop("GotoExits.EXITS", Collections.emptySet());
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(NamedMerlinObj.NAME, PROP_EXITS);
    private PropertySet d_props = new PropertySet();

    public GotoExits() {
        this(Collections.EMPTY_SET);
    }

    public GotoExits(Set<EgressDoor> exits) {
        super(null);
        this.set(PROP_EXITS, exits);
    }

    @Override
    public GotoExits clone() {
        GotoExits ge = (GotoExits)super.clone();
        ge.d_props = this.d_props.clone();
        return ge;
    }

    @Override
    public GotoExits getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof GotoExits)) {
            return;
        }
        GotoExits ge = (GotoExits)obj;
        this.pauseUpdates();
        this.set(PROP_EXITS, ge.get(PROP_EXITS));
        this.setName(ge.getSetName());
        this.resumeUpdates();
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    public boolean isGotoAny() {
        return this.get(PROP_EXITS).isEmpty();
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (Objects.equals(this.get(prop), value)) {
            return;
        }
        this.d_props.setIfNotDefault(prop, value);
        this.changedEvt(prop);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        return NOT_SUPPORTED;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            Set<EgressDoor> exits = this.get(PROP_EXITS);
            name = exits.size() == 1 ? String.format(Intl.intl("Exit <%s>"), exits.iterator().next().getName()) : (exits.isEmpty() ? Intl.intl("Exit <any>") : String.format(Intl.intl("Exit <door set>"), new Object[0]));
        }
        return name;
    }

    @Override
    public String getSetName() {
        return super.getName();
    }

    @Override
    public IDestination getDestination() {
        return new ExitDestination();
    }

    public boolean equals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (!(comparable instanceof GotoExits)) {
            return false;
        }
        GotoExits comparableBehavior = (GotoExits)comparable;
        if (comparableBehavior.get(PROP_EXITS).size() != this.get(PROP_EXITS).size() || !this.getName().equals(comparableBehavior.getName())) {
            return false;
        }
        for (EgressDoor exit : this.get(PROP_EXITS)) {
            if (!comparableBehavior.get(PROP_EXITS).stream().noneMatch(c -> c.equals(exit))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void replaceDependency(Object replacement, Object old) {
        assert (old != null);
        this.get(PROP_EXITS).remove(old);
        if (replacement != null && replacement instanceof EgressDoor) {
            this.get(PROP_EXITS).add((EgressDoor)replacement);
        }
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (Collection<? extends Object>)this.get(PROP_EXITS));
    }

    private class ExitDestination
    implements IDestination {
        private final Set<EgressDoor> d_exits;
        private final List<IEgressConnector> d_allExits;

        private ExitDestination() {
            this.d_exits = GotoExits.this.get(PROP_EXITS);
            this.d_allExits = this.d_exits.isEmpty() ? ((MerlinData)GotoExits.this.getDomain()).getAllExits() : Collections.emptyList();
        }

        @Override
        public int hashCode() {
            return 0xF98AF3EE ^ this.d_exits.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof ExitDestination && ((ExitDestination)obj).getExits().equals(this.d_exits);
        }

        protected Set<EgressDoor> getExits() {
            return this.d_exits;
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            return null;
        }

        private IUnreachable allExitsUnreachable() {
            return new IUnreachable(){

                @Override
                public SimError getError(IMerlinObj source) {
                    String name = MerlinUtil.getName(source);
                    return new SimError(SimError.Level.MODERATE, String.format(Intl.intl("\"%s\" cannot reach any exits."), name), String.format(Intl.intl("Move \"%s,\" move the exits, or connect their rooms."), name), source);
                }
            };
        }

        private IUnreachable someExitsUnreachable(final List<? extends IEgressConnector> exits) {
            return new IUnreachable(){

                @Override
                public SimError getError(IMerlinObj source) {
                    IMerlinObj[] objs = new IMerlinObj[1 + exits.size()];
                    for (int m = 0; m < exits.size(); ++m) {
                        objs[m] = (IMerlinObj)exits.get(m);
                    }
                    objs[objs.length - 1] = source;
                    String name = MerlinUtil.getName(source);
                    return new SimError(SimError.Level.MODERATE, String.format(Intl.intl("\"%1$s\" cannot reach %2$d of its exits."), name, exits.size()), String.format(Intl.intl("Move \"%1$s,\" move the unreachable exits, or connect their rooms."), name), objs);
                }
            };
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() {
            return Collections.EMPTY_LIST;
        }
    }
}

