/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.awt.geom.Area;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.vecmath.Vector3d;
import merlin.MerlinPrefs;
import merlin.data.INameGenerator;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.util.BitOptions;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AreaUtil;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class RoomUtil {
    public static final int CLEANUP_EXTERNAL_EXTRA = 1;
    public static final int CLEANUP_INTERNAL_EXTRA = 2;
    public static final int CLEANUP_ADJ_FACES = 4;
    public static final int CLEANUP_ADJ_EDGES = 8;
    public static final int CLEANUP_FACE_ORIENTS = 16;
    public static final int CLEANUP_ALL = 31;
    public static final int MATCH_ALL_GROUP_IDS = 32;
    public static final boolean FORCE_CLEANUP_DEFAULT = false;
    private static final Plane3d s_z0 = new Plane3d(0.0, 0.0, 1.0, 0.0);

    public static Model cleanup(Model original, int options, Predicate<Edge> inUseEdgeFilter) {
        return RoomUtil.cleanup(original, options, inUseEdgeFilter, false);
    }

    public static Model cleanup(Model original, int options, Predicate<Edge> inUseEdgeFilter, boolean forceCleanup) {
        boolean optimize;
        if (options == 0) {
            return original;
        }
        boolean bl = optimize = forceCleanup || MerlinPrefs.get(MerlinPrefs.MESH_OPTIMIZATION) != false;
        if (!optimize) {
            return original;
        }
        try {
            Model model = (Model)original.clone();
            Runnable checkModel = () -> {
                for (Face face : model.getFaces()) {
                    for (FaceLoop loop : face.edgeLoops) {
                        for (EdgeUse eu : loop.edges) {
                            if (model.getEdges().contains(eu.edge)) continue;
                            throw new RuntimeException();
                        }
                        if (loop.vert == null || loop.vert.face == face) continue;
                        throw new RuntimeException();
                    }
                }
            };
            BitOptions opts = new BitOptions(options);
            boolean modified = false;
            if (opts.get(1L)) {
                modified |= RoomUtil.removeExternalExtraneous(model);
            }
            if (opts.get(4L)) {
                modified |= RoomUtil.mergeFaces(model);
            }
            if (opts.get(2L)) {
                modified |= RoomUtil.removeInternalExtraneous(model);
            }
            if (opts.get(8L)) {
                modified |= RoomUtil.mergeEdges(model, options, inUseEdgeFilter);
            }
            if (opts.get(16L)) {
                modified |= RoomUtil.ensureProperFaceOrient(model);
            }
            if (!modified) {
                return original;
            }
            checkModel.run();
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return original;
        }
    }

    private static boolean removeExternalExtraneous(Model model) {
        ArrayList<Edge> eRemove = new ArrayList<Edge>();
        for (Edge edge : model.getEdges()) {
            if (!edge.faces.isEmpty()) continue;
            eRemove.add(edge);
        }
        boolean modified = false;
        modified |= !eRemove.isEmpty();
        for (Edge edge : eRemove) {
            model.deleteEdge(edge, true);
        }
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        for (Vertex vert : model.getVerts()) {
            if (vert.face != null || !vert.edges.isEmpty()) continue;
            arrayList.add(vert);
        }
        modified |= !arrayList.isEmpty();
        for (Vertex vert : arrayList) {
            model.deleteVertex(vert);
        }
        return modified;
    }

    private static boolean mergeFaces(Model model) {
        boolean modified = false;
        ArrayList<Edge> delEdges = new ArrayList<Edge>();
        for (Edge edge : model.getEdges()) {
            if (edge.partOfGroup(1) || edge.faces.size() != 2) continue;
            Face face1 = edge.faces.get(0);
            Face face2 = edge.faces.get(1);
            if (!NmtUtil.equal(face1.groups, face2.groups) || !face1.plane.epsilonEquals(face2.plane, 1.0E-6) && !face1.plane.epsilonEquals(face2.plane.negate(), 1.0E-6)) continue;
            delEdges.add(edge);
        }
        modified |= !delEdges.isEmpty();
        for (Edge delEdge : delEdges) {
            model.removeEdgeFromFaces(delEdge);
        }
        return modified;
    }

    private static boolean removeInternalExtraneous(Model model) {
        boolean modified = false;
        ArrayList<Edge> eRemove = new ArrayList<Edge>();
        for (Edge edge : model.getEdges()) {
            if (edge.partOfGroup(1) || edge.faces.size() != 1) continue;
            eRemove.add(edge);
        }
        modified |= !eRemove.isEmpty();
        for (Edge edge : eRemove) {
            model.removeEdgeFromFace(edge);
        }
        ArrayList<Vertex> vRemove = new ArrayList<Vertex>();
        for (Vertex vert : model.getVerts()) {
            if (!vert.edges.isEmpty() || vert.face == null) continue;
            vRemove.add(vert);
        }
        modified |= !vRemove.isEmpty();
        for (Vertex vert : vRemove) {
            model.removeVertexFromFace(vert);
        }
        return modified;
    }

    private static boolean mergeEdges(Model model, int options, Predicate<Edge> inUseEdgeFilter) {
        boolean modified = false;
        BiPredicate<Edge, Edge> canMerge = (options & 0x20) == 32 ? (e1, e2) -> NmtUtil.equal(e1.groups, e2.groups) : (e1, e2) -> RoomUtil.isBoundary(e1) == RoomUtil.isBoundary(e2);
        ArrayList<Vertex> delVerts = new ArrayList<Vertex>();
        for (Vertex vert : model.getVerts()) {
            double dot;
            if (vert.edges.size() != 2) continue;
            Edge e12 = vert.edges.get(0);
            Edge e22 = vert.edges.get(1);
            Vector3d tan1 = e12.curve.getTangent(0.0);
            tan1.normalize();
            Vector3d tan2 = e22.curve.getTangent(0.0);
            tan2.normalize();
            if (vert == e12.v2) {
                tan1.negate();
            }
            if (vert == e22.v2) {
                tan2.negate();
            }
            if (!theUtil.eq(dot = tan1.dot(tan2), -1.0, 1.0E-6) || !canMerge.test(e12, e22) || inUseEdgeFilter.test(e12) || inUseEdgeFilter.test(e22)) continue;
            delVerts.add(vert);
        }
        boolean bl = !delVerts.isEmpty();
        model.removeVerticesFromEdges(delVerts);
        return modified |= bl;
    }

    public static boolean ensureProperFaceOrient(Model model) {
        boolean modified = false;
        for (Face face : RoomUtil.findFlatFacesThatPointDown(model)) {
            face.flipOrient();
            modified = true;
        }
        LinkedHashSet<Face> invalid = new LinkedHashSet<Face>();
        RoomUtil.findInconsistentFaces(model, invalid, null);
        for (Face face : invalid) {
            face.flipOrient();
            modified = true;
        }
        return modified;
    }

    private static Collection<Face> findFlatFacesThatPointDown(Model m) {
        Collection downFaces = Collections.EMPTY_SET;
        Vector3d down = new Vector3d(0.0, 0.0, -1.0);
        double rad89 = 0.7766715171374766;
        for (Face f : m.getFaces()) {
            if (!(f.plane.getNormal().angle(down) <= 0.7766715171374766)) continue;
            if (downFaces.isEmpty()) {
                downFaces = new ArrayDeque();
                System.err.println("Downward facing face detected.");
            }
            downFaces.add(f);
        }
        return downFaces;
    }

    private static void findInconsistentFaces(Model m, Collection<Face> invalid, Collection<Face> unknown) {
        LinkedHashSet<Face> unknownFaces = new LinkedHashSet<Face>(m.getFaces());
        ArrayDeque<Face> goodFaces = new ArrayDeque<Face>();
        LinkedHashSet<Face> invalidFaces = new LinkedHashSet<Face>();
        Vector3d up = new Vector3d(0.0, 0.0, 1.0);
        Vector3d down = new Vector3d(0.0, 0.0, -1.0);
        double rad89 = 0.7766715171374766;
        for (Face f : unknownFaces) {
            if (!(f.plane.getNormal().angle(up) <= 0.7766715171374766) && !(f.plane.getNormal().angle(down) <= 0.7766715171374766)) continue;
            goodFaces.add(f);
        }
        unknownFaces.removeAll(goodFaces);
        LinkedHashSet<Face> visited = new LinkedHashSet<Face>(goodFaces);
        ArrayDeque<ConnectedFace> toTest = new ArrayDeque<ConnectedFace>();
        for (Face f : goodFaces) {
            visited.add(f);
            for (ConnectedFace cf : RoomUtil.getNeighborFaces(f, true)) {
                if (visited.contains(cf.face)) continue;
                toTest.add(cf);
            }
        }
        while (!toTest.isEmpty()) {
            ConnectedFace connection = (ConnectedFace)toTest.removeFirst();
            if (visited.contains(connection.face)) continue;
            EdgeUse fromEdgeUse = connection.fromEdgeUse;
            EdgeUse testEdgeUse = RoomUtil.getEdgeUse(connection.face, fromEdgeUse.edge);
            boolean testFaceIsGood = fromEdgeUse.orient != testEdgeUse.orient ? connection.fromFaceIsGood : !connection.fromFaceIsGood;
            unknownFaces.remove(connection.face);
            if (!testFaceIsGood) {
                invalidFaces.add(connection.face);
            }
            visited.add(connection.face);
            for (ConnectedFace cf : RoomUtil.getNeighborFaces(connection.face, testFaceIsGood)) {
                if (visited.contains(cf.face)) continue;
                toTest.add(cf);
            }
        }
        if (invalid != null) {
            invalid.addAll(invalidFaces);
        }
        if (unknown != null) {
            unknown.addAll(unknownFaces);
        }
    }

    private static Collection<ConnectedFace> getNeighborFaces(Face f, boolean fIsGood) {
        LinkedHashSet<ConnectedFace> neighbors = new LinkedHashSet<ConnectedFace>();
        for (FaceLoop floop : f.edgeLoops) {
            for (EdgeUse eu : floop.edges) {
                for (Face adjFace : eu.edge.faces) {
                    if (adjFace.equals(f)) continue;
                    neighbors.add(new ConnectedFace(fIsGood, eu, adjFace));
                }
            }
        }
        return neighbors;
    }

    private static EdgeUse getEdgeUse(Face f, Edge e) {
        for (FaceLoop floop : f.edgeLoops) {
            for (EdgeUse eu : floop.edges) {
                if (!eu.edge.equals(e)) continue;
                return eu;
            }
        }
        throw new IllegalArgumentException("Face isn't using that edge.");
    }

    public static List<? extends ICurve> findBoundaries(IEgressOccupiable room, ITest<AABox> test) {
        Model model = room.getModel();
        ArrayList<ICurve> resultEdges = new ArrayList<ICurve>();
        for (Edge nearEdge : model.findEdge(test)) {
            if (!nearEdge.partOfGroup(1)) continue;
            resultEdges.add(GeomUtil.toGeomCurve(nearEdge.curve));
        }
        return resultEdges;
    }

    public static List<Model> separate(Model model) {
        ArrayList<Model> separatedModels = new ArrayList<Model>();
        LinkedIdentityHashSet<Face> closed = new LinkedIdentityHashSet<Face>();
        for (Face face : model.getFaces()) {
            Set<Face> touching = RoomUtil.findTouchingFaces(model, face, closed);
            if (touching.isEmpty()) continue;
            if (touching.size() == model.getFaces().size()) {
                assert (separatedModels.isEmpty());
                return Arrays.asList(model);
            }
            Model newModel = new Model();
            newModel.add(touching, Collections.emptyList(), Collections.emptyList());
            separatedModels.add(newModel);
        }
        return separatedModels;
    }

    private static Set<Face> findTouchingFaces(Model model, Face srcFace, Set<Face> closed) {
        if (!closed.add(srcFace)) {
            return Collections.EMPTY_SET;
        }
        Stack<Face> open = new Stack<Face>();
        open.push(srcFace);
        LinkedIdentityHashSet<Face> result = new LinkedIdentityHashSet<Face>();
        while (!open.isEmpty()) {
            Face face = (Face)open.pop();
            result.add(face);
            for (FaceLoop loop : face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (eu.edge.partOfGroup(1)) continue;
                    for (Face touchingFace : eu.edge.faces) {
                        if (touchingFace == face || !closed.add(touchingFace)) continue;
                        open.push(touchingFace);
                    }
                }
            }
        }
        return result;
    }

    public static void assignSeparatedProps(List<EgressRoom> separatedRooms, INameGenerator roomNameGen) {
        for (int m = 1; m < separatedRooms.size(); ++m) {
            EgressRoom room = separatedRooms.get(m);
            room.setColor(theUtil.newRandomColor());
            room.setName(roomNameGen.getCurrentName());
            roomNameGen.nextName();
        }
    }

    private static boolean isBoundary(Edge edge) {
        return edge.partOfGroup(1);
    }

    public static boolean overlapsSelf(Model model) {
        if (model.getFaces().size() <= 1) {
            return false;
        }
        AABox totBounds = model.getBoundingBox();
        totBounds = totBounds.scale(1.2);
        double minz = totBounds.getMinZ();
        double maxz = totBounds.getMaxZ();
        LinkedIdentityHashSet closed = new LinkedIdentityHashSet();
        IdentityHashMap<Face, Area> faceAreaMap = new IdentityHashMap<Face, Area>();
        double totOverlap = 0.0;
        AABox extrudedFaceBounds = new AABox();
        block0: for (Face face1 : model.getFaces()) {
            if (!closed.add(face1) || RoomUtil.isVertical(face1)) continue;
            AABox faceBounds = face1.getBounds();
            extrudedFaceBounds.set(faceBounds.getMinX(), faceBounds.getMinY(), minz, faceBounds.getMaxX(), faceBounds.getMaxY(), maxz);
            List<Face> nearFaces = model.findFaces(extrudedFaceBounds);
            assert (nearFaces.contains(face1));
            if (nearFaces.size() <= 1) continue;
            for (Face face2 : nearFaces) {
                if (face1 == face2 || RoomUtil.isVertical(face2) || closed.contains(face2)) continue;
                Area area1 = RoomUtil.getArea(face1, faceAreaMap);
                if (area1 == null) continue block0;
                Area area2 = RoomUtil.getArea(face2, faceAreaMap);
                if (area2 == null || !theUtil.gt(totOverlap += RoomUtil.getOverlap(area1, area2), 0.5, 1.0E-9)) continue;
                return true;
            }
        }
        return false;
    }

    private static Area getArea(Face face, Map<Face, Area> areaMap) {
        Area area = areaMap.get(face);
        if (area == null && !areaMap.containsKey(face)) {
            area = GeomUtil.toArea(face, s_z0);
            areaMap.put(face, area);
        }
        return area;
    }

    private static double getOverlap(Area face1, Area face2) {
        Area intersection = (Area)face1.clone();
        intersection.intersect(face2);
        return AreaUtil.area(intersection, null, 0.0, 1.0E-9);
    }

    private static boolean isVertical(Face face) {
        return theUtil.eq0(face.plane.z, 1.0E-9);
    }

    private static final class ConnectedFace {
        public final boolean fromFaceIsGood;
        public final EdgeUse fromEdgeUse;
        public final Face face;

        public ConnectedFace(boolean fromFaceIsGood, EdgeUse fromEdgeUse, Face face) {
            this.fromFaceIsGood = fromFaceIsGood;
            this.fromEdgeUse = fromEdgeUse;
            this.face = face;
        }
    }
}

