/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.util.ArrayList;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import merlin.builders.CorridorUtil;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.Geometry;
import merlin.geom.IMerlinDispProps;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Sets;

public class EgressStair
extends EgressCorridor {
    static final long serialVersionUID = 1L;
    public static final Object TREAD_RISE = "Stairway.RISE";
    public static final Object TREAD_RUN = "Stairway.RUN";
    public static final Set<Object> PROP_TYPES = Sets.appendLHS(EgressCorridor.PROP_TYPES, TREAD_RISE, TREAD_RUN);
    private UnitDouble d_rise;
    private UnitDouble d_run;

    public EgressStair(String name, IEgressOccupiable conn1, IEgressOccupiable conn2, LineSeg attachedEdge1, LineSeg attachedEdge2, UnitDouble rise, UnitDouble run, Point3d[] boundary) {
        super(name, conn1, conn2, attachedEdge1, attachedEdge2, boundary);
        this.d_rise = rise;
        this.d_run = run;
    }

    public EgressStair(String name, IEgressOccupiable conn1, IEgressOccupiable conn2, EgressCorridor.CorridorGeom geom) {
        super(name, conn1, conn2, geom);
    }

    @Override
    public boolean equals(Object obj) {
        return this.propEquals(obj);
    }

    @Override
    public boolean propEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EgressStair)) {
            return false;
        }
        EgressStair stair = (EgressStair)obj;
        return super.propEquals(stair) && this.d_run.equals(stair.d_run) && this.d_rise.equals(stair.d_rise);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == TREAD_RISE) {
            this.setTreadRise((UnitDouble)value);
        } else if (property == TREAD_RUN) {
            this.setTreadRun((UnitDouble)value);
        } else {
            super.setProperty(property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == TREAD_RISE) {
            return this.getTreadRise();
        }
        if (property == TREAD_RUN) {
            return this.getTreadRun();
        }
        return super.getProperty(property);
    }

    public void setTreadRise(UnitDouble rise) {
        this.d_rise = rise;
        this.markTopoDirty();
        this.changedEvt(TREAD_RISE);
    }

    public UnitDouble getTreadRise() {
        return this.d_rise;
    }

    public void setTreadRun(UnitDouble run) {
        this.d_run = run;
        this.changedEvt(TREAD_RUN);
    }

    public UnitDouble getTreadRun() {
        return this.d_run;
    }

    @Override
    protected CorridorUtil.IBoundaryGen getBoundaryGen() {
        return new BoundaryGen(this.d_rise.getValue(Geometry.LENGTH_UNIT), this.d_run.getValue(Geometry.LENGTH_UNIT));
    }

    public boolean isEscalator() {
        return super.isMovingWalkway();
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps dprops) {
        DispStairGeom sgeom;
        if (!(dprops instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps props = (IMerlinDispProps)dprops;
        int drawOptions = props.getCorridorDrawOptions();
        IGeom geom = sgeom = new DispStairGeom(this.getStairGeom(), (drawOptions & 1) != 0, (drawOptions & 2) != 0);
        GeomGroup ggroup = (GeomGroup)sgeom.getGeom(false);
        assert (ggroup.children.size() >= 2);
        PropsBuilder psrc = new PropsBuilder();
        IGeom faces = ggroup.children.get(0);
        IGeom border = ggroup.children.get(1);
        IPrimProps fprops = props.getFaceProps(this, IMerlinDispProps.EgressType.CORRIDOR, this.getColor(), this.getOpacity());
        IPrimProps bprops = props.getEdgeProps(this, IMerlinDispProps.EgressType.BOUNDARY, null, this.getOpacity());
        psrc.add(fprops, faces.getNumPrims(1));
        psrc.add(bprops, border.getNumPrims(2));
        int dispIx = 2;
        IPrimProps eprops = props.getEdgeProps(this, IMerlinDispProps.EgressType.CORRIDOR, null, this.getOpacity());
        if (sgeom.edges) {
            IGeom edges = ggroup.children.get(dispIx++);
            psrc.add(eprops, edges.getNumPrims(2));
        }
        if (sgeom.dirArrow) {
            IGeom arrow = ggroup.children.get(dispIx++);
            IPrimProps.GenericProps aprops = new IPrimProps.GenericProps(eprops.getColor(), null, 2.0, IPrimProps.DEF_STIPPLE, 1.0, 0);
            psrc.add(aprops, arrow.getNumPrims(7));
        }
        geom = this.appendOnewayGeom(props, geom, psrc, sgeom);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(geom), psrc.finalizeProps());
    }

    @Override
    public StairGeom getCorrGeom() {
        return this.getStairGeom();
    }

    public StairGeom getStairGeom() {
        EgressCorridor.CorridorGeom cg = super.getCorrGeom();
        return new StairGeom(cg, this.d_rise.getValue(Geometry.LENGTH_UNIT), this.d_run.getValue(Geometry.LENGTH_UNIT));
    }

    @Override
    public void setGeom(EgressCorridor.CorridorGeom geom, boolean markTopoDirty) {
        if (geom instanceof StairGeom) {
            StairGeom sg = (StairGeom)geom;
            this.pauseUpdates();
            super.setGeom(geom, markTopoDirty);
            this.d_rise = EgressStair.newLenVal(this.d_rise, sg.rise);
            this.d_run = EgressStair.newLenVal(this.d_run, sg.run);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        } else {
            super.setGeom(geom, markTopoDirty);
        }
    }

    private static UnitDouble newLenVal(UnitDouble oldVal, Double newVal) {
        if (newVal == null) {
            return null;
        }
        if (oldVal == null) {
            return new UnitDouble(newVal, Geometry.LENGTH_UNIT);
        }
        return UnitDouble.from(newVal, Geometry.LENGTH_UNIT, oldVal.getUnit());
    }

    public static class BoundaryGen
    implements CorridorUtil.IBoundaryGen {
        private final double d_rise;
        private final double d_run;

        public BoundaryGen(double rise, double run) {
            this.d_rise = rise;
            this.d_run = run;
        }

        @Override
        public Point3d[] getBoundary(LineSeg edge1, Point3d e1p1, Point3d e1p2, CorridorUtil.ITermCriteria termCriteria) {
            Point3d p2;
            Vector3d stairDir = this.getStairDir(edge1);
            Plane3d termPlane = termCriteria.getTermPlane(e1p1, e1p2, stairDir);
            if (!Util3D.areParallel(termPlane, Util3D.vector(edge1.p1, edge1.p2), 1.0E-6)) {
                return null;
            }
            Point3d p1rise1 = new Point3d(e1p1.x, e1p1.y, e1p1.z + this.d_rise);
            Point3d p2rise1 = new Point3d(e1p2.x, e1p2.y, e1p2.z + this.d_rise);
            Point3d p1 = Inter3D.lineSegPlaneIntersection(e1p1, p1rise1, termPlane, 1.0E-6);
            if (p1 == null) {
                p1 = p1rise1;
            }
            if ((p2 = Inter3D.lineSegPlaneIntersection(e1p2, p2rise1, termPlane, 1.0E-6)) == null) {
                p2 = p2rise1;
            }
            Point3d p1a = Inter3D.rayPlaneIntersection(p1, stairDir, termPlane, 1.0E-6);
            Point3d p2a = Inter3D.rayPlaneIntersection(p2, stairDir, termPlane, 1.0E-6);
            if (p1a == null || p2a == null) {
                return null;
            }
            return new Point3d[]{e1p2, e1p1, p1a, p2a};
        }

        private Vector3d getStairDir(LineSeg edge1) {
            Vector3d edgeDir = Util3D.vector(edge1.p1, edge1.p2);
            Vector3d stairDir = new Vector3d(edgeDir.y, -edgeDir.x, 0.0);
            stairDir.normalize();
            stairDir.scale(this.d_run);
            stairDir.z = this.d_rise;
            return stairDir;
        }
    }

    public static class StairGeom
    extends EgressCorridor.CorridorGeom {
        static final long serialVersionUID = 1L;
        public final double rise;
        public final double run;

        public StairGeom(LineSeg edge1, LineSeg edge2, Double door1Width, Double door2Width, Vector2d onewayDir, Point3d[] boundary, double rise, double run) {
            super(edge1, edge2, door1Width, door2Width, onewayDir, boundary);
            this.rise = rise;
            this.run = run;
        }

        protected StairGeom(EgressCorridor.CorridorGeom cg, double rise, double run) {
            this(cg.edge1, cg.edge2, cg.door1Width, cg.door2Width, cg.dirVec, cg.boundary, rise, run);
        }

        @Override
        public EgressCorridor.CorridorGeom setDirection(Vector2d onewayVec) {
            EgressCorridor.CorridorGeom result = super.setDirection(onewayVec);
            if (result == this) {
                return result;
            }
            return new StairGeom(result, this.rise, this.run);
        }

        @Override
        public StairGeom optimize(IPointOptimizer pointOptimizer) {
            EgressCorridor.CorridorGeom corr = super.optimize(pointOptimizer);
            if (corr == this) {
                return this;
            }
            return new StairGeom(corr, this.rise, this.run);
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            IGeom transformed = super.transform(ti, options);
            if (transformed == this) {
                return transformed;
            }
            if (transformed instanceof EgressCorridor.CorridorGeom) {
                return new StairGeom((EgressCorridor.CorridorGeom)transformed, this.rise, this.run);
            }
            return this;
        }

        protected boolean includeEdges() {
            return false;
        }

        @Override
        protected IGeom constructGeom(boolean selectable) {
            int[] edgeIndices;
            int[] borderIndices;
            int[] faceIndices;
            Point3d[] points;
            boolean faces = this.includeFaces();
            boolean border = this.includeBorder();
            boolean dirArrow = this.includeDirArrow();
            boolean edges = this.includeEdges();
            Point3d[] stairPoints = this.getBoundary();
            if (stairPoints == null) {
                return EmptyGeom.INSTANCE;
            }
            Point3d p1 = stairPoints[0];
            Point3d p2 = stairPoints[1];
            Point3d p1a = stairPoints[3];
            Point3d p2a = stairPoints[2];
            double totRise1 = p1a.z - p1.z;
            double totRise2 = p2a.z - p2.z;
            double riseTot = Math.max(totRise1, totRise2);
            double numSteps = this.rise == 0.0 && this.run == 0.0 ? 1.0 : (this.rise == 0.0 ? 0.0 : (riseTot == 0.0 ? 0.0 : Math.max(1.0, (double)Math.round(Math.abs(riseTot / this.rise)))));
            double rise1 = numSteps == 0.0 ? 0.0 : totRise1 / numSteps;
            double rise2 = numSteps == 0.0 ? 0.0 : totRise2 / numSteps;
            Point3d p1h = new Point3d(p1.x, p1.y, p1.z + rise1);
            Point3d p1ah = new Point3d(p1a.x, p1a.y, p1a.z - rise1);
            Point3d p2h = new Point3d(p2.x, p2.y, p2.z + rise2);
            Point3d p2ah = new Point3d(p2a.x, p2a.y, p2a.z - rise2);
            if (Math.abs(numSteps) == 1.0) {
                points = new Point3d[]{p1, p2, p2h, p1h, p2a, p1a};
                faceIndices = new int[]{0, 1, 2, 3, 3, 2, 4, 5};
                borderIndices = new int[]{1, 2, 2, 4, 0, 3, 3, 5};
                edgeIndices = new int[]{2, 3};
            } else if (numSteps == 0.0) {
                double totRun1 = StairGeom.dist2d(p1, p1a);
                double totRun2 = StairGeom.dist2d(p2, p2a);
                double runTot = Math.max(totRun1, totRun2);
                numSteps = Math.max(1L, Math.round(Math.abs(runTot / this.run)));
                int iNumSteps = (int)numSteps;
                int numPoints = iNumSteps * 2 + 2;
                int numFaceIndices = iNumSteps * 4;
                int numBorderIndices = iNumSteps * 4;
                int numEdgeIndices = (iNumSteps - 1) * 2;
                points = new Point3d[numPoints];
                faceIndices = new int[numFaceIndices];
                borderIndices = new int[numBorderIndices];
                edgeIndices = new int[numEdgeIndices];
                double invt = 1.0 / numSteps;
                points[0] = p1;
                points[1] = p2;
                int pix = 2;
                int ixix = 0;
                int eix = 0;
                for (int m = 0; m < iNumSteps; ++m) {
                    double t = (double)(m + 1) * invt;
                    points[pix] = Util3D.linesegPoint(p1, p1a, t);
                    points[pix + 1] = Util3D.linesegPoint(p2, p2a, t);
                    faceIndices[ixix] = pix - 1;
                    faceIndices[ixix + 1] = pix - 2;
                    faceIndices[ixix + 2] = pix;
                    faceIndices[ixix + 3] = pix + 1;
                    borderIndices[ixix] = pix - 1;
                    borderIndices[ixix + 1] = pix + 1;
                    borderIndices[ixix + 2] = pix - 2;
                    borderIndices[ixix + 3] = pix;
                    if (m != iNumSteps - 1) {
                        edgeIndices[eix] = pix;
                        edgeIndices[eix + 1] = pix + 1;
                        eix += 2;
                    }
                    pix += 2;
                    ixix += 4;
                }
            } else {
                int numFaceIndices;
                int numPoints = (int)(numSteps * 4.0);
                int numBorderIndices = numFaceIndices = 4 * (int)(numSteps * 2.0 - 1.0);
                int numEdgeIndices = 2 * (int)((numSteps - 1.0) * 2.0);
                points = new Point3d[numPoints];
                faceIndices = new int[numFaceIndices];
                borderIndices = new int[numBorderIndices];
                edgeIndices = new int[numEdgeIndices];
                points[0] = p1;
                points[1] = p2;
                points[2] = p2h;
                points[3] = p1h;
                faceIndices[0] = 0;
                faceIndices[1] = 1;
                faceIndices[2] = 2;
                faceIndices[3] = 3;
                borderIndices[0] = 0;
                borderIndices[1] = 3;
                borderIndices[2] = 1;
                borderIndices[3] = 2;
                double invt = 1.0 / (numSteps - 1.0);
                int pix = 4;
                int ixix = 4;
                int eix = 0;
                for (double m = 1.0; m < numSteps; m += 1.0) {
                    double t = m * invt;
                    points[pix] = Util3D.linesegPoint(p1, p1ah, t);
                    points[pix + 1] = Util3D.linesegPoint(p2, p2ah, t);
                    points[pix + 2] = Util3D.linesegPoint(p2h, p2a, t);
                    points[pix + 3] = Util3D.linesegPoint(p1h, p1a, t);
                    faceIndices[ixix] = pix - 1;
                    faceIndices[ixix + 1] = pix - 2;
                    faceIndices[ixix + 2] = pix + 1;
                    faceIndices[ixix + 3] = pix;
                    faceIndices[ixix + 4] = pix;
                    faceIndices[ixix + 5] = pix + 1;
                    faceIndices[ixix + 6] = pix + 2;
                    faceIndices[ixix + 7] = pix + 3;
                    borderIndices[ixix] = pix - 1;
                    borderIndices[ixix + 1] = pix;
                    borderIndices[ixix + 2] = pix;
                    borderIndices[ixix + 3] = pix + 3;
                    borderIndices[ixix + 4] = pix - 2;
                    borderIndices[ixix + 5] = pix + 1;
                    borderIndices[ixix + 6] = pix + 1;
                    borderIndices[ixix + 7] = pix + 2;
                    edgeIndices[eix] = pix - 2;
                    edgeIndices[eix + 1] = pix - 1;
                    edgeIndices[eix + 2] = pix + 1;
                    edgeIndices[eix + 3] = pix;
                    pix += 4;
                    ixix += 8;
                    eix += 4;
                }
            }
            ArrayList<Object> geoms = new ArrayList<Object>(4);
            if (faces) {
                geoms.add(new Mesh(points, faceIndices, 3));
            }
            if (border) {
                geoms.add(new Mesh(points, borderIndices, 1));
                if (selectable) {
                    geoms.add(new LineSeg(stairPoints[0], stairPoints[1]));
                    geoms.add(new LineSeg(stairPoints[2], stairPoints[3]));
                }
            }
            if (edges) {
                geoms.add(new Mesh(points, edgeIndices, 1));
            }
            if (dirArrow) {
                geoms.add(StairGeom.generateArrow(this.edge1, this.edge2, new Point3d[]{p1h, p2h, p2a, p1a}, new Point3d[]{p1, p2, p2ah, p1ah}));
            }
            geoms.trimToSize();
            return GeomUtil.group(geoms);
        }

        private static double dist2d(Point3d p1, Point3d p2) {
            double dx = p2.x - p1.x;
            double dy = p2.y - p1.y;
            return Math.sqrt(dx * dx + dy * dy);
        }

        private static IGeom generateArrow(LineSeg edge1, LineSeg edge2, Point3d[] border1, Point3d[] border2) {
            Point3d[] border = border1[0].z > border2[0].z ? border1 : border2;
            return EgressCorridor.CorridorGeom.generateArrow(edge1, edge2, border);
        }
    }

    public static class DispStairGeom
    extends StairGeom {
        public final boolean edges;
        public final boolean dirArrow;

        public DispStairGeom(StairGeom sg, boolean edges, boolean dirArrow) {
            super(sg.edge1, sg.edge2, sg.door1Width, sg.door2Width, sg.dirVec, sg.boundary, sg.rise, sg.run);
            this.edges = edges;
            this.dirArrow = dirArrow;
        }

        @Override
        protected boolean includeEdges() {
            return this.edges;
        }

        @Override
        protected boolean includeDirArrow() {
            return this.dirArrow;
        }
    }
}

