/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.egress.agents.OccProfile;
import thunderheadeng.util.TypeFilter;

public class OccProfileComp
extends Composite<OccProfile> {
    static final long serialVersionUID = 1L;
    public OccProfile NO_CHANGE;
    private static final Predicate<ICompElement> s_filter = new TypeFilter<ICompElement>(OccProfile.class, OccProfileComp.class);

    public OccProfileComp() {
        this(Intl.intl("Profiles"));
        this.addDefault();
        this.initNoChangeProfile();
    }

    public OccProfileComp(String name) {
        super(name);
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new OccProfileComp(name);
    }

    public void addDefault() {
        OccProfile oProf = new OccProfile();
        oProf.setProperty((Object)OccProfile.PROP_NAME, Intl.intl("Default"));
        this.add(oProf);
    }

    private void initNoChangeProfile() {
        this.NO_CHANGE = new OccProfile();
        this.NO_CHANGE.setName(Intl.intl("No Change"));
        this.NO_CHANGE.setProperty(OccProfile.PROP_NO_CHANGE, Boolean.valueOf(true));
    }

    public void restoreFrom(OccProfileComp profComp) {
        super.restoreFrom(profComp);
        if (this.isEmpty()) {
            this.addDefault();
        }
        this.NO_CHANGE = profComp.NO_CHANGE;
        if (this.NO_CHANGE == null) {
            this.initNoChangeProfile();
        }
    }

    public void reset() {
        this.pauseUpdates();
        this.clear();
        this.addDefault();
        this.resumeUpdates();
    }

    @Override
    public Object getProperty(Object property) {
        if (property == OccProfile.PROP_NAME) {
            return this.getName();
        }
        return super.getProperty(property);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Profile Group");
    }
}

