/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.egress.agents.IOccArea;
import merlin.data.egress.agents.OccArea;
import merlin.data.egress.agents.PredefOccArea;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class OccAreaMgr
implements Serializable {
    static final long serialVersionUID = 1L;

    public static Collection<IOccArea> getPredefAreas() {
        ArrayList<IOccArea> areas = new ArrayList<IOccArea>();
        for (PredefOccArea.Token predefTok : PredefOccArea.Token.values()) {
            areas.add(new PredefOccArea(predefTok));
        }
        return areas;
    }

    public static Collection<IOccArea> getNonEmptySpecs() {
        return theUtil.filter(OccAreaMgr.getPredefAreas(), new Predicate<IOccArea>(){

            @Override
            public boolean test(IOccArea o) {
                return !o.getArea().isInfinite();
            }
        });
    }

    public IOccArea get(String name) {
        for (IOccArea area : OccAreaMgr.getPredefAreas()) {
            if (!area.getName().equals(name)) continue;
            return area;
        }
        return null;
    }

    public IOccArea get(UnitDouble density) {
        for (IOccArea area : OccAreaMgr.getPredefAreas()) {
            if (!area.getArea().equals(density)) continue;
            return area;
        }
        return new OccArea(Intl.intl("Custom"), density);
    }

    public IOccArea getDefault() {
        return new PredefOccArea(PredefOccArea.Token.EMPTY);
    }

    public boolean isDefault(IOccArea type) {
        return this.getDefault().equals(type);
    }

    public boolean isCustom(IOccArea type) {
        return type instanceof OccArea;
    }

    public Collection<IOccArea> getTypes() {
        return Collections.unmodifiableCollection(OccAreaMgr.getPredefAreas());
    }

    public UnitDouble getMinDensity() {
        Unit sqMeter = SIUS.unit(2);
        UnitDouble min = UnitDouble.maxValue(sqMeter);
        for (IOccArea type : OccAreaMgr.getPredefAreas()) {
            UnitDouble density;
            if (this.isDefault(type) || (density = type.getArea()).compareTo(min) >= 0) continue;
            min = density;
        }
        return min;
    }

    public UnitDouble getMaxDensity() {
        Unit sqMeter = SIUS.unit(2);
        UnitDouble max = UnitDouble.maxNegValue(sqMeter);
        for (IOccArea type : OccAreaMgr.getPredefAreas()) {
            UnitDouble density;
            if (this.isDefault(type) || (density = type.getArea()).compareTo(max) <= 0) continue;
            max = density;
        }
        return max;
    }
}

