/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import merlin.data.AMerlinObj;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.Proxy;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.SetMetrics;
import thunderheadeng.util.theUtil;

public class MerlinSelectionModel
extends AMerlinObj
implements Serializable,
IRestorable,
Cloneable {
    public static final long serialVersionUID = 1L;
    private final SetMetrics d_selectionSet = new SetMetrics();

    @Override
    public void restoreFrom(Object obj) {
        MerlinSelectionModel aMgr = (MerlinSelectionModel)obj;
        this.pauseUpdates();
        this.clear();
        this.selectAll(aMgr.getSelected(Object.class));
        this.resumeUpdates();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    public void set(Object ... objs) {
        this.set(Arrays.asList(objs));
    }

    public void set(Collection<?> objs) {
        this.pauseUpdates();
        this.clear();
        this.selectAll(objs);
        this.resumeUpdates();
    }

    private <T> void fireHierarchySelEvt(T obj) {
        MerlinData md = obj instanceof IDomainObject ? (MerlinData)((IDomainObject)obj).getDomain() : (MerlinData)this.getDomain();
        if (md != null) {
            md.getEvents().changed(obj, MerlinData.SELECTION_CHANGED);
            for (Object child : md.hierarchy.getChildren(obj)) {
                this.fireHierarchySelEvt(child);
            }
        }
        if (obj instanceof Proxy) {
            this.fireHierarchySelEvt(((Proxy)obj).getObj());
        }
    }

    private <T> void deselectChildren(T obj) {
        for (Object child : ((MerlinData)this.getDomain()).hierarchy.getChildren(obj)) {
            this.d_selectionSet.remove(child);
            this.deselectChildren(child);
        }
    }

    public <T> void select(T obj) {
        this.pauseUpdates();
        if (!this.isSelected(obj) && this.d_selectionSet.add(obj)) {
            this.deselectChildren(obj);
            this.fireHierarchySelEvt(obj);
        }
        this.resumeUpdates();
    }

    public <T> void select(T ... objs) {
        this.select((T)Arrays.asList(objs));
    }

    public <T> void selectAll(Collection<? extends T> objs) {
        this.pauseUpdates();
        for (T o : objs) {
            this.select(o);
        }
        this.resumeUpdates();
    }

    public <T> void deselect(T obj) {
        this.pauseUpdates();
        if (this.d_selectionSet.remove(obj)) {
            this.fireHierarchySelEvt(obj);
        }
        this.resumeUpdates();
    }

    public <T> void deselect(T ... objs) {
        this.deselect((T)Arrays.asList(objs));
    }

    public <T> void deselectAll(Collection<? extends T> objs) {
        this.pauseUpdates();
        for (T o : objs) {
            this.deselect(o);
        }
        this.resumeUpdates();
    }

    public int getSelectionCount() {
        return this.getSelectionCount(Object.class);
    }

    public int getSelectionCount(Class<?> ... types) {
        return this.d_selectionSet.getNum(types);
    }

    public void clear() {
        Set objs = this.d_selectionSet.filter(Object.class);
        this.deselectAll(objs);
    }

    private boolean isHierarchySelected(Object o) {
        MerlinData md = (MerlinData)this.getDomain();
        if (md == null) {
            return false;
        }
        Object parent = md.hierarchy.getParent(o);
        return parent != null ? this.isSelected(parent) : false;
    }

    public boolean isProxySelected(Object o) {
        if (!(o instanceof ICompElement)) {
            return false;
        }
        MerlinData md = (MerlinData)this.getDomain();
        if (md == null) {
            return false;
        }
        return md.proxies.findFirstProxy((ICompElement)o, p -> this.isSelected(p)) != null;
    }

    public boolean isSelected(Object o) {
        if (o == null) {
            return this.isEmpty();
        }
        return this.d_selectionSet.contains(o) || this.isHierarchySelected(o);
    }

    private <T> void collectChildren(Collection<T> coll, T obj, Class<T> type) {
        coll.add(obj);
        for (Object child : ((MerlinData)this.getDomain()).hierarchy.getChildren(obj)) {
            if (!type.isInstance(child)) continue;
            Object childObj = child;
            this.collectChildren(coll, childObj, type);
        }
    }

    public <T> Set<T> getSelectedWithChildren(Class<T> clazz) {
        Set selObjs = this.d_selectionSet.filter(clazz);
        LinkedIdentityHashSet newSel = new LinkedIdentityHashSet();
        for (Object obj : selObjs) {
            this.collectChildren(newSel, obj, clazz);
        }
        return newSel;
    }

    public <T> Set<T> getSelected(Class<? extends T> ... clazzes) {
        return this.d_selectionSet.filter(clazzes);
    }

    public <T> Set<T> getSelected(SetMetrics.IFilter<T> c) {
        return this.d_selectionSet.filter(c);
    }

    public <T> IFilteredCollection<T> get(Class<T> clazz, Predicate<? super T> filter) {
        return theUtil.filter(this.d_selectionSet.flatten(), clazz, filter);
    }

    public <T> Set<T> getDeepSelected(Class<? extends T> ... clazzes) {
        Set<T> objs = this.getSelected(clazzes);
        Set<T> groups = this.getSelected(Composite.class);
        for (Composite comp : groups) {
            for (Class<? extends T> clazz : clazzes) {
                objs.addAll(comp.getDeepMembers(clazz));
            }
        }
        return objs;
    }

    public boolean isDeepEmpty(Class<?> clazz) {
        if (!this.isEmpty(new SetMetrics.DefFilter(clazz))) {
            return false;
        }
        Set groups = this.getSelected(Composite.class);
        for (Composite comp : groups) {
            if (comp.getDeepMembers(clazz).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public <T> IFilteredCollection<T> flatten(Class<T> type) {
        return this.flatten(type, Predicates.alwaysTrue());
    }

    public <T> IFilteredCollection<T> flatten(Class<T> type, Predicate<? super T> filter) {
        return theUtil.filter(MerlinUtil.flatten(theUtil.filter(this.d_selectionSet.flatten(), IMerlinObj.class), Object.class), type, filter);
    }

    public boolean isExclusive(Class<?> ... clazzes) {
        return this.d_selectionSet.isExclusive(clazzes);
    }

    public boolean isSingleExclusive(Class<?> ... clazzes) {
        return this.isExclusive(clazzes) && this.getSelected(clazzes).size() == 1;
    }

    public boolean isEmpty() {
        return this.d_selectionSet.isEmpty();
    }

    public <T> boolean isEmpty(SetMetrics.IFilter<T> c) {
        return this.d_selectionSet.isEmpty(c);
    }

    public boolean isEmpty(Class<?> clazz) {
        return this.d_selectionSet.isEmpty(new SetMetrics.DefFilter(clazz));
    }

    public boolean contains(Class<?> ... clazzes) {
        for (Class<?> clazz : clazzes) {
            if (!this.d_selectionSet.containsAny(clazz, Predicates.alwaysTrue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public MerlinSelectionModel clone() {
        MerlinSelectionModel copy = (MerlinSelectionModel)super.clone();
        try {
            theUtil.assignFinalField(copy, MerlinSelectionModel.class, "d_selectionSet", this.d_selectionSet.clone());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
        return copy;
    }

    public String toString() {
        return String.format("MerlinSelectionModel[d_selectionSet=%s]", this.d_selectionSet.toString());
    }
}

