/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.SubtractAction;
import merlin.actions.Undo;
import merlin.builders.NewCompUtil;
import merlin.builders.PlanarGeomBuilder;
import merlin.data.INameGenerator;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.geom.EgressRoom;
import merlin.geom.GeomUtil;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.util.IResponder;
import thunderheadeng.util.theUtil;

public class RoomGeomBuilder
implements PlanarGeomBuilder.IGeomBuilder {
    private final IResponder<String> d_responder;
    private final BooleanOp d_bo;

    public RoomGeomBuilder(BooleanOp op, IResponder<String> responder) {
        this.d_bo = op;
        this.d_responder = responder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(MerlinData md, PlanarGeomBuilder builder, IGeom shape) {
        EgressRoom geom;
        IResponder<String> responder = this.d_responder;
        BooleanOp op = this.d_bo;
        INameGenerator nameGenerator = md.roomNameGen;
        if (!(shape instanceof IPlanarFace)) {
            return;
        }
        IPlanarFace face = (IPlanarFace)shape;
        ArrayList<ICurve> boundary = new ArrayList<ICurve>();
        face.getBoundary(boundary);
        List<LineSeg> bsegs = thunderheadeng.geometry.objs.GeomUtil.getLineSegs(0.0, boundary);
        List<IParametric3D> boundaryParms = theUtil.map(bsegs, ls -> new LineSeg3D(ls.p1, ls.p2));
        Model model = new Model();
        GeomUtil.addFaceToModel(model, 0, face.getPlane(true), boundaryParms);
        int[] boundaryid = new int[]{1};
        for (Edge edge : model.getEdges()) {
            edge.groups = boundaryid;
        }
        ArrayList<EgressAgent> agentsToDelete = Collections.EMPTY_LIST;
        md.beginRead();
        try {
            String name = nameGenerator.getCurrentName();
            nameGenerator.nextName();
            geom = new EgressRoom(name, model);
            if (op == BooleanOp.SUBTRACT) {
                AABoxTest test = new AABoxTest(geom.getBounds(), 1.0E-6);
                ArrayList agents = new ArrayList();
                CollResult result = new CollResult(agents, EgressAgent.class);
                md.agentOverlapDetector.getLocator().find(test, result, 3);
                if (!agents.isEmpty()) {
                    ArrayList<EgressAgent> potInvalidAgents = new ArrayList<EgressAgent>();
                    for (EgressAgent agent : agents) {
                        Point3d loc = agent.getLocation();
                        if (!geom.isWalkable(loc)) continue;
                        potInvalidAgents.add(agent);
                    }
                    if (!potInvalidAgents.isEmpty()) {
                        String response;
                        String desc = Intl.intl("Subtraction area contains occupants");
                        String message = String.format("The area to be removed contains %d occupant(s).  Area you sure you\nwant to remove the area and the occupants within?", potInvalidAgents.size());
                        String[] responses = new String[]{Intl.intl("Yes"), Intl.intl("No")};
                        if (!responses[0].equals(response = md.ui(() -> responder.getResponse(desc, message, responses[1], responses)))) {
                            return;
                        }
                    }
                    agentsToDelete = potInvalidAgents;
                }
            }
        }
        finally {
            md.endRead();
        }
        ArrayList<EgressAgent> delAgents = agentsToDelete;
        md.beginWrite();
        try {
            String actionName = op == BooleanOp.ADD ? Intl.intl("New Room") : Intl.intl("Subtract Area");
            Undo.begin(actionName);
            if (!delAgents.isEmpty()) {
                EntryPoint<EgressAgent> ep = EntryPointFactory.get(EgressAgent.class);
                Undo.insertUndoEntry_add(md, delAgents);
                for (EgressAgent agent : delAgents) {
                    ep.delete(md, agent);
                }
            }
            ArrayList toClean = new ArrayList();
            switch (op) {
                case ADD: {
                    this.addArea(md, geom, toClean::add);
                    break;
                }
                case SUBTRACT: {
                    this.subArea(md, geom, toClean::add);
                }
            }
            EgressRoom.cleanup(md, toClean);
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }

    private void addArea(MerlinData md, EgressRoom room, Consumer<? super EgressRoom> toClean) {
        toClean.accept(room);
        this.subArea(md, room, toClean);
        room.setColor(theUtil.newRandomColor());
        NewCompUtil.addEgressComp(md, room);
    }

    private void subArea(MerlinData md, EgressRoom room, Consumer<? super EgressRoom> toClean) {
        SubtractAction.subtract(MerlinApp.getApp(), md, 0, toClean, room);
    }

    public static enum BooleanOp {
        ADD,
        SUBTRACT;

    }
}

