/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.vecmath.Point2d;
import merlin.builders.ATwoPointBuilder;
import merlin.builders.PlanarGeomBuilder;
import merlin.builders.WorkingPlane;
import merlin.data.MerlinData;

public class RectBuilder
extends ATwoPointBuilder {
    public RectBuilder(MerlinData data, WorkingPlane workingPlane, PlanarGeomBuilder.IGeomBuilder builder) {
        super(data, workingPlane, builder);
    }

    @Override
    public Shape getShape() {
        Point2d p1 = this.getP1();
        Point2d p2 = this.getP2();
        if (p1 == null || p2 == null) {
            return new Rectangle2D.Double();
        }
        double width = Math.abs(p2.x - p1.x);
        double height = Math.abs(p2.y - p1.y);
        double miny = Math.min(p1.y, p2.y);
        double minx = Math.min(p1.x, p2.x);
        return new Rectangle2D.Double(minx, miny, width, height);
    }
}

