/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.floorextract.ExtractFloor2D;
import merlin.actions.floorextract.ExtractFloor3D;
import merlin.data.ImportedGeom;
import merlin.geom.Geometry;
import merlin.util.MerlinProps;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class FloorExtractor3D
extends MerlinProps {
    private static final boolean EXTRACT_V2 = false;
    public static final Object PICK_POINT_CHANGED = "FloorExtractor3D.PICK_POINT_CHANGED";
    public static final Object SLOPE_CHANGED = "FloorExtractor3D.SLOPE_CHANGED";
    public static final Object HEAD_HEIGHT_CHANGED = "FloorExtractor3D.HEAD_HEIGHT_CHANGED";
    public static final Object GAP_TOLERANCE = "FloorExtractor3D.GAP_TOLERANCE";
    private UnitPoint3D d_pickPoint = null;
    private ImportedGeom d_pickGeom = null;
    private UnitDouble d_maxSlope = new UnitDouble(45.0, NonSI.DEGREE_ANGLE);
    private UnitDouble d_maxHeadHeight = new UnitDouble(6.0, NonSI.FOOT);
    private UnitDouble d_closeGapSize = new UnitDouble(6.0, NonSI.INCH);

    public void setGapTolerance(UnitDouble tol) {
        if (!this.lock()) {
            return;
        }
        this.d_closeGapSize = tol;
        this.firePropChanged(GAP_TOLERANCE);
        this.release();
    }

    public UnitDouble getGapTolerance() {
        return this.d_closeGapSize;
    }

    public void setPickPoint(UnitPoint3D pickPoint, ImportedGeom pickGeom) {
        if (!this.lock()) {
            return;
        }
        this.d_pickPoint = pickPoint;
        this.d_pickGeom = pickGeom;
        this.firePropChanged(PICK_POINT_CHANGED);
        this.release();
    }

    public UnitPoint3D getPickPoint() {
        return this.d_pickPoint;
    }

    public ImportedGeom getPickGeom() {
        return this.d_pickGeom;
    }

    public void setMaxSlope(UnitDouble maxSlope) {
        if (!this.lock()) {
            return;
        }
        this.d_maxSlope = maxSlope;
        this.firePropChanged(SLOPE_CHANGED);
        this.release();
    }

    public UnitDouble getMaxSlope() {
        return this.d_maxSlope;
    }

    public void setMaxHeadHeight(UnitDouble maxHeadHeight) {
        if (!this.lock()) {
            return;
        }
        this.d_maxHeadHeight = maxHeadHeight;
        this.firePropChanged(HEAD_HEIGHT_CHANGED);
        this.release();
    }

    public UnitDouble getMaxHeadHeight() {
        return this.d_maxHeadHeight;
    }

    public boolean canExtractFloor() {
        return this.d_pickPoint != null;
    }

    public void extractFloor(Component c) {
        if (!this.canExtractFloor()) {
            return;
        }
        AMerlinOp op = this.d_pickGeom != null ? new ExtractFloor3D(this.d_pickGeom, this.d_pickPoint.getPoint3dValue(Geometry.LENGTH_UNIT), this.d_maxSlope.getValue(SI.RADIAN), this.d_maxHeadHeight.getValue(Geometry.LENGTH_UNIT), this.d_closeGapSize.getValue(Geometry.LENGTH_UNIT)) : new ExtractFloor2D(this.d_pickPoint.getPoint3dValue(Geometry.LENGTH_UNIT), this.d_closeGapSize.getValue(Geometry.LENGTH_UNIT));
        UIHook.run(c, "FloorExtractor3D.extractFloor", op, 4);
    }
}

