/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.util.Collections;
import java.util.Random;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.geom.Geometry;
import merlin.util.MerlinProps;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.stat.ICurve;

public class AgentDropper
extends MerlinProps
implements IEventObserver {
    public static final Object NAME_CHANGED = "AgentDropper.NAME_CHANGED";
    public static final Object LOC_CHANGED = "AgentDropper.LOC_CHANGED";
    public static final Object CREATE_AGENT = "AgentDropper.CREATE_AGENT";
    public static final Object PROFILE_CHANGED = "AgentDropper.PROFILE_CHANGED";
    public static final Object BEHAVIOR_CHANGED = "AgentDropper.BEHAVIOR_CHANGED";
    private final MerlinData d_data;
    private String d_name;
    private UnitPoint3D d_location = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
    private IEgressOccupiable d_room = null;
    private OccProfile d_currentProfile;
    private Behavior d_behavior;
    private long d_profileSeed = OccProfile.newSeed();

    public AgentDropper(MerlinData data) {
        this.d_data = data;
        this.d_currentProfile = (OccProfile)data.profiles.getMembers().iterator().next();
        this.d_behavior = (Behavior)data.behaviors.getMembers().iterator().next();
        this.d_name = null;
        this.d_data.getEvents().addObserver(this);
    }

    public void setProfile(OccProfile prof) {
        if (!this.lock()) {
            return;
        }
        this.d_currentProfile = prof;
        this.firePropChanged(PROFILE_CHANGED);
        this.release();
    }

    public OccProfile getProfile() {
        return this.d_currentProfile;
    }

    public void setBehavior(Behavior behavior) {
        if (!this.lock()) {
            return;
        }
        this.d_behavior = behavior;
        this.firePropChanged(BEHAVIOR_CHANGED);
        this.release();
    }

    public Behavior getBehavior() {
        return this.d_behavior;
    }

    @Override
    public void update(Events events) {
        if (events.getEvents(OccProfile.class, new Class[0]).getRemovedObjs().contains(this.d_currentProfile)) {
            this.setProfile(this.d_data.profiles.getDeepMembers(OccProfile.class).iterator().next());
        }
        if (events.getEvents(Behavior.class, new Class[0]).getRemovedObjs().contains(this.d_behavior)) {
            this.setBehavior(this.d_data.behaviors.getDeepMembers(Behavior.class).iterator().next());
        }
    }

    public long getProfileSeed() {
        return this.d_profileSeed;
    }

    public boolean canCreate() {
        return this.d_room != null;
    }

    public void setName(String name) {
        if (!this.lock()) {
            return;
        }
        this.d_name = name;
        this.firePropChanged(NAME_CHANGED);
        this.release();
    }

    public String getName() {
        return this.d_name;
    }

    public void setLocation(UnitPoint3D loc) {
        if (!this.lock()) {
            return;
        }
        Predicate<IEgressOccupiable> roomFilter = EgressAgent.getRoomFilter(this.d_currentProfile);
        double angleDeg = ((UnitDouble)this.d_currentProfile.getDistVal(OccProfile.PROP_INIT_ORIENT, new Random(), this.d_profileSeed)).getValue(MerlinApp.getApp().getUnitSystem().getAngle());
        int options = 8;
        OccLocation result = this.d_data.findValidOccLocation(this.d_currentProfile.getProperty(OccProfile.PROP_SHAPE), loc.getPoint3dValue(Geometry.LENGTH_UNIT), this.getShoulderWidth(), angleDeg, options, roomFilter);
        if (result.room == null || result.isOverlappingAgents() || result.overlapsWalls || result.failsFilter) {
            this.d_location = loc;
            this.d_room = null;
        } else {
            this.d_location = UnitPoint3D.convert(result.point, Geometry.LENGTH_UNIT, loc.getUnit());
            this.d_room = result.room;
        }
        this.firePropChanged(LOC_CHANGED);
        this.release();
    }

    public UnitPoint3D getLocation() {
        return this.d_location;
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    public OccLocation getOccLocation() {
        return new OccLocation(this.d_room, Collections.EMPTY_LIST, false, false, this.d_location.getPoint3dValue(Geometry.LENGTH_UNIT));
    }

    public UnitDouble getShoulderWidth() {
        ICurve diam = this.d_currentProfile.getProperty(OccProfile.PROP_DIAMETER);
        return diam.getMax();
    }

    public UnitDouble getGeomShoulderWidth() {
        return this.getProfile().getProperty(OccProfile.PROP_GEOM_DIAMETER);
    }

    public EgressAgent createAgent() {
        if (this.d_room == null) {
            return null;
        }
        EgressAgent agent = new EgressAgent(new OccProfile(this.d_currentProfile), this.d_behavior, this.d_profileSeed);
        agent.setName(this.d_data.occNameGen.nextName(false));
        agent.setLocation(this.getOccLocation());
        return agent;
    }

    public void createAndAddAgent(Component c) {
        final EgressAgent agent = this.createAgent();
        if (agent == null) {
            return;
        }
        this.d_profileSeed = OccProfile.newSeed();
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData data) {
                data.beginWrite();
                try {
                    Undo.begin(Intl.intl("New Occupant"));
                    Undo.insertUndoEntry_delete(AgentDropper.this.d_data, ((AgentDropper)AgentDropper.this).d_data.agents, agent);
                    ((AgentDropper)AgentDropper.this).d_data.agents.add(agent);
                    ((AgentDropper)AgentDropper.this).d_data.selection.set(agent);
                    Undo.end(data);
                }
                finally {
                    data.endWrite();
                }
            }
        };
        UIHook.run(c, "AgentDropper.createAndAddAgent", op, 4);
        this.pause();
        this.firePropChanged(CREATE_AGENT);
        this.resume();
    }
}

