/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.util.MerlinProps;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public abstract class AQueueElementBuilder
extends MerlinProps
implements IEventObserver {
    public static final Object QUEUE_CHANGED = "AQueueElementBuilder.QUEUE_CHANGED";
    public static final Object COMMITTED = "AQueueElementBuilder.COMMITTED";
    public static final Object CANCELLED = "AQueueElementBuilder.CANCELLED";
    public static final Object VALIDITY = "AQueueElementBuilder.VALID";
    protected final MerlinData d_data;
    private QueueObject d_currQueue;
    private IQueueElement d_elem;
    private QueuePathNode d_node;

    public AQueueElementBuilder(MerlinData md) {
        this.d_data = md;
        SelectionObserver.add(this, QueueObject.class, IQueueElement.class);
    }

    protected abstract IQueueElement create();

    protected abstract void reset();

    @Override
    public void update(Events events) {
        QueueObject queue = null;
        IQueueElement elem = null;
        QueuePathNode node = null;
        if (this.d_data.selection.isExclusive(QueueObject.class)) {
            queue = (QueueObject)this.d_data.selection.getSelected(QueueObject.class).iterator().next();
        } else if (this.d_data.selection.isExclusive(QueuePath.class, QueueService.class)) {
            elem = (IQueueElement)this.d_data.selection.getSelected(IQueueElement.class).iterator().next();
            queue = (QueueObject)this.d_data.hierarchy.getParent(elem);
        } else if (this.d_data.selection.isExclusive(QueuePathNode.class)) {
            node = (QueuePathNode)this.d_data.selection.getSelected(QueuePathNode.class).iterator().next();
            elem = (IQueueElement)this.d_data.hierarchy.getParent(node);
            queue = (QueueObject)this.d_data.hierarchy.getParent(elem);
        }
        this.setCurrentQueue(queue, elem, node);
    }

    protected void setCurrentQueue(QueueObject queue, IQueueElement elem, QueuePathNode node) {
        if (!this.lock()) {
            return;
        }
        this.d_currQueue = queue;
        this.d_elem = elem;
        this.d_node = node;
        this.firePropChanged(QUEUE_CHANGED);
        this.release();
    }

    public QueueObject getCurrentQueue() {
        return this.d_currQueue;
    }

    public IQueueElement getInsertAfterElem() {
        return this.d_elem;
    }

    public QueuePathNode getInsertAfterNode() {
        return this.d_node;
    }

    public void cancel() {
        this.reset();
        this.firePropChanged(CANCELLED);
    }

    public abstract boolean isValid();

    public void commit(Component c) {
        assert (this.d_currQueue != null);
        if (!this.isValid()) {
            return;
        }
        final IQueueElement newElem = this.create();
        AMerlinOp op = new AMerlinOp(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(MerlinApp app, MerlinData md) {
                md.beginWrite();
                try {
                    Undo.begin(Intl.intl("Add Queue Element"));
                    if (!(newElem instanceof QueuePathNode)) {
                        IQueueElement insertAfter = AQueueElementBuilder.this.d_elem;
                        int ix = 0;
                        for (IQueueElement qe : AQueueElementBuilder.this.d_currQueue.getMembers(IQueueElement.class)) {
                            ++ix;
                            if (qe != insertAfter) continue;
                            break;
                        }
                        AddObject.add((MerlinData)md, (Composite)AQueueElementBuilder.this.d_currQueue, (int)ix, (ICompElement[])new IQueueElement[]{newElem});
                    } else {
                        QueuePath path = (QueuePath)AQueueElementBuilder.this.d_elem;
                        QueuePathNode insertAfter = AQueueElementBuilder.this.d_node;
                        int ix = 0;
                        for (QueuePathNode pn : path.getMembers(QueuePathNode.class)) {
                            ++ix;
                            if (pn != insertAfter) continue;
                            break;
                        }
                        AddObject.add((MerlinData)md, (Composite)path, (int)ix, (ICompElement[])new QueuePathNode[]{(QueuePathNode)newElem});
                    }
                    Undo.end(md);
                }
                finally {
                    md.endWrite();
                }
                AQueueElementBuilder.this.reset();
            }
        };
        UIHook.run(c, "AQueueElementBuilder.commit", op, 4);
        this.firePropChanged(COMMITTED);
    }
}

