/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.geomops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.Delete;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.RoomUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;

public class SeparateGeom
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SeparateGeom(), Intl.intl("Sepa&rate,P,Separate the selected rooms,Separate disjoint rooms from one another."));

    public SeparateGeom() {
        SelectionObserver.add(this, EgressRoom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(!md.selection.isDeepEmpty(EgressRoom.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set<EgressRoom> sel = md.selection.getDeepSelected(EgressRoom.class);
        if (sel.isEmpty()) {
            return;
        }
        app.beginWaitCursor();
        try {
            md.beginWrite();
            try {
                ArrayList toClean = new ArrayList();
                SeparateGeom.separate(md, sel, toClean::add, (key, child) -> {});
                EgressRoom.cleanup(md, toClean);
            }
            finally {
                md.endWrite();
            }
        }
        finally {
            app.endWaitCursor();
        }
    }

    public static Map<EgressRoom, List<EgressRoom>> separate(MerlinData md, Collection<EgressRoom> rooms, Consumer<? super EgressRoom> toClean) {
        return SeparateGeom.separate(md, rooms, toClean, (parent, child) -> {});
    }

    public static Map<EgressRoom, List<EgressRoom>> separate(MerlinData md, Collection<EgressRoom> rooms, Consumer<? super EgressRoom> toClean, BiConsumer<? super EgressRoom, ? super EgressRoom> toSelect) {
        Undo.begin(Intl.intl("Separate"));
        LinkedIdentityHashMap<EgressRoom, List<EgressRoom>> result = new LinkedIdentityHashMap<EgressRoom, List<EgressRoom>>();
        boolean modified = false;
        for (EgressRoom geom : rooms) {
            if (!geom.getModificationsAllowed()) continue;
            List<EgressRoom> comps = geom.separate();
            result.put(geom, comps);
            if (comps.size() <= 1) continue;
            RoomUtil.assignSeparatedProps(comps, md.roomNameGen);
            Composite parent = (Composite)md.hierarchy.getParent(geom);
            Undo.insertUndoEntry_delete(md, parent, comps);
            parent.addAll(comps);
            modified = true;
            comps.forEach(toClean);
            for (EgressRoom comp : comps) {
                toSelect.accept(geom, comp);
            }
        }
        Set toDelete = result.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(e -> (EgressRoom)e.getKey()).collect(Collectors.toSet());
        if (!toDelete.isEmpty()) {
            Delete.deleteAll(md, toDelete);
        }
        Undo.end(md, modified);
        return result;
    }
}

