/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.geomops;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CancelledException;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressModelGeom;
import merlin.data.egress.geom.EgressRoom;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;

public class CleanupRooms
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new CleanupRooms(), Intl.intl("Remove extra vertices...,-,Remove extra vertices on unused edges."));

    public CleanupRooms() {
        SelectionObserver.add(this, EgressRoom.class);
        this.update(null);
    }

    protected Set<EgressRoom> getValidRooms(MerlinData md) {
        return theUtil.filter(md.selection.getDeepSelected(EgressRoom.class), EgressRoom::getModificationsAllowed);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(MerlinApp.getApp().getData().selection.isExclusive(EgressRoom.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        TaskProgress progress = new TaskProgress();
        guiProgressMonitor pm = new guiProgressMonitor(app.getMainFrame(), Intl.intl("Removing Extra Vertices"), true, progress);
        pm.begin();
        try {
            EgressRoom room;
            LinkedIdentityHashMap<EgressRoom, Model> newRoomGeom = new LinkedIdentityHashMap<EgressRoom, Model>();
            int vertsRemoved = 0;
            md.beginRead();
            try {
                Set<EgressRoom> rooms = this.getValidRooms(md);
                Iterator<EgressRoom> iterator = rooms.iterator();
                while (iterator.hasNext()) {
                    room = iterator.next();
                    this.checkCancelled(progress);
                    Model model = room.getModel();
                    Model newModel = room.cleanup(model);
                    if (newModel == model) continue;
                    if (newModel.getVerts().size() < model.getVerts().size()) {
                        vertsRemoved += model.getVerts().size() - newModel.getVerts().size();
                    }
                    newRoomGeom.put(room, newModel);
                }
            }
            finally {
                md.endRead();
            }
            this.checkCancelled(progress);
            if (!newRoomGeom.isEmpty()) {
                md.beginWrite();
                try {
                    Undo.begin(Intl.intl("Remove Extra Vertices"));
                    for (Map.Entry entry : newRoomGeom.entrySet()) {
                        room = (EgressRoom)entry.getKey();
                        Model newModel = (Model)entry.getValue();
                        Undo.insertUndoEntry_restore(md, room);
                        room.setGeom(new EgressModelGeom(newModel));
                    }
                    Undo.end(md);
                }
                finally {
                    md.endWrite();
                }
            }
            int removed = vertsRemoved;
            md.uiLater(() -> JOptionPane.showMessageDialog(app.getActiveFrame(), String.format(Intl.intl("Vertices removed: %d"), removed), Intl.intl("Removed Vertices"), 1));
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            pm.end();
        }
    }
}

