/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.floorextract;

import java.awt.Component;
import java.awt.Window;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import merlin.Intl;
import merlin.actions.floorextract.GenerateModelFromBIM;
import merlin.data.ImportType;
import merlin.gui.MerlinValueFields;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.ComponentGroup2;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;

public class GenerateModelPropsDlg
extends guiDialog {
    private final guiCheckBox d_nameFromImportedGeom;
    private final ValueField<UnitDouble> d_maxSlope;
    private final ValueField<UnitDouble> d_maxHeadHeight;
    private final ValueField<UnitDouble> d_maxStairRiser;
    private final ValueField<UnitDouble> d_maxStairTreadGap;
    private final guiCheckBox d_closeGaps;
    private final ValueField<UnitDouble> d_gapTolerance;
    private final guiCheckBox d_delSmallRooms;
    private final ValueField<UnitDouble> d_minRoomArea;
    private final guiCheckBox d_delRoomsInSolids;
    private final guiCheckBox d_topsOfSolids;
    private final guiCheckBox d_extractDoors;
    private final guiCheckBox d_extractStairs;
    private final ValueField<UnitDouble> d_minStairWidth;

    public GenerateModelPropsDlg(Window parent) {
        super(parent, Intl.intl("Generate Settings"), 9);
        BiFunction<String, String, guiLabel> lbl = (name, tt) -> {
            guiLabel label = new guiLabel((String)name);
            label.setToolTipText((String)tt);
            return label;
        };
        this.d_nameFromImportedGeom = new guiCheckBox(Intl.intl("Use imported names"));
        this.d_nameFromImportedGeom.setToolTipText(Intl.intl("Sets the names of resulting objects to the names of the imported objects from which they derived."));
        guiLabel slopeLbl = lbl.apply(Intl.intl("Max slope:"), Intl.intl("Maximum traversable slope of 3D geometry."));
        this.d_maxSlope = MerlinValueFields.udFld(7);
        this.d_maxSlope.setFilter(UnitDoubleVR.above(0.0, SI.RADIAN, true));
        guiLabel headHeightLbl = lbl.apply(Intl.intl("Max head height:"), Intl.intl("Height at which to cut obstructions from the floor."));
        this.d_maxHeadHeight = MerlinValueFields.udFld(0);
        this.d_maxHeadHeight.setFilter(UnitDoubleVR.above(0.0, SI.METER, false));
        this.d_maxStairRiser = MerlinValueFields.udFld(0);
        this.d_maxStairRiser.setFilter(UnitDoubleVR.above(0.0, SI.METER, false));
        this.d_maxStairTreadGap = MerlinValueFields.udFld(0);
        this.d_maxStairTreadGap.setFilter(UnitDoubleVR.above(0.0, SI.METER, true));
        this.d_delRoomsInSolids = new guiCheckBox(Intl.intl("Exclude rooms in solids"));
        this.d_delRoomsInSolids.setToolTipText(Intl.intl("Whether to exclude rooms from the result that appear to be inside solid objects, such as walls."));
        this.d_topsOfSolids = new guiCheckBox(Intl.intl("Generate from tops of solids"));
        this.d_topsOfSolids.setToolTipText(Intl.intl("For solid floor objects, only try to generate rooms from the top faces of the objects."));
        this.d_closeGaps = new guiCheckBox(Intl.intl("Close gaps smaller than:"));
        this.d_closeGaps.setToolTipText(Intl.intl("Whether to close gaps between room boundaries that are smaller than the specified value (e.g. area behind a desk)."));
        this.d_gapTolerance = MerlinValueFields.udFld(0);
        this.d_gapTolerance.setFilter(UnitDoubleVR.above(0.0, SI.METER, true));
        this.d_delSmallRooms = new guiCheckBox(Intl.intl("Exclude rooms with area less than:"));
        this.d_delSmallRooms.setToolTipText(Intl.intl("Whether to exclude rooms with area less than the specified value."));
        this.d_minRoomArea = MerlinValueFields.udFld(4);
        this.d_minRoomArea.setFilter(UnitDoubleVR.above(0.0, SI.METER.pow(2), true));
        this.d_extractStairs = new guiCheckBox(Intl.intl("Generate stairs"));
        this.d_extractStairs.setToolTipText(String.format("<html>" + Intl.intl("Whether to generate Pathfinder stairs from imported objects with <b>Import Type</b>, %s."), ImportType.STAIR.name));
        this.d_extractDoors = new guiCheckBox(Intl.intl("Generate doors"));
        this.d_extractDoors.setToolTipText("<html>" + String.format(Intl.intl("Whether to generate Pathfinder doors from imported objects with <b>Import Type</b>, %s."), ImportType.DOOR.name));
        this.d_minStairWidth = MerlinValueFields.udFld(0);
        this.d_minStairWidth.setFilter(UnitDoubleVR.above(0.0, SI.METER, false));
        JButton defaultsBtn = new JButton(Intl.intl("Load Defaults"));
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addTitle(Intl.intl("Walking Surface"));
        gb.indent();
        gb.addRow(slopeLbl, this.d_maxSlope, 0);
        gb.addRow(headHeightLbl, this.d_maxHeadHeight, 0);
        gb.addRow(this.d_topsOfSolids, 0);
        gb.addRow(this.d_delRoomsInSolids, 0);
        gb.addRow(this.d_closeGaps, this.d_gapTolerance, 0);
        gb.addRow(this.d_delSmallRooms, this.d_minRoomArea, 0);
        gb.unindent();
        gb.addTitle(Intl.intl("Components"));
        gb.indent();
        gb.addRow(this.d_nameFromImportedGeom, 0);
        gb.addRow(this.d_extractDoors, 0);
        gb.addRow(this.d_extractStairs, 0);
        gb.indent();
        gb.beginGroup("stair");
        gb.addRow(lbl.apply(Intl.intl("Max vertical step distance:"), Intl.intl("The maximum distance between one step and the next above or below.")), this.d_maxStairRiser);
        gb.addRow(lbl.apply(Intl.intl("Max horizontal step distance:"), Intl.intl("The maximum horizontal distance between the end of one step and the beginning of another.")), this.d_maxStairTreadGap);
        gb.addRow(lbl.apply(Intl.intl("Min stair width:"), Intl.intl("The minimum width of resulting stairs.")), this.d_minStairWidth);
        ComponentGroup2<Component> stairGroup = gb.endGroup();
        gb.finalizeRows();
        defaultsBtn.addActionListener(e -> this.load(new PropertySet()));
        JButton ok = this.getButton(1);
        ok.setText(Intl.intl("Generate"));
        ok.setPreferredSize(null);
        ok.setPreferredSize(ok.getPreferredSize());
        this.setButtons(defaultsBtn, ok, this.getButton(8));
        guiUtil.link((AbstractButton)this.d_closeGaps, this.d_gapTolerance);
        guiUtil.link((AbstractButton)this.d_delSmallRooms, this.d_minRoomArea);
        guiUtil.link((AbstractButton)this.d_extractStairs, stairGroup);
    }

    public void load(IPropertySet props) {
        this.processProps((prop, cb) -> cb.setSelected((Boolean)props.get(prop)), (prop, fld) -> fld.setValue(props.get(prop)));
    }

    public void save(IPropertySet props) {
        this.processProps((prop, cb) -> props.set(prop, cb.isSelected()), (prop, fld) -> props.set(prop, fld.getValue()));
    }

    private void processProps(BiConsumer<IPropertySet.Prop<Boolean>, guiCheckBox> b, BiConsumer<IPropertySet.Prop<UnitDouble>, ValueField<UnitDouble>> ud) {
        b.accept(GenerateModelFromBIM.NAME_FROM_IMPORTED_GEOM, this.d_nameFromImportedGeom);
        ud.accept(GenerateModelFromBIM.MAX_SLOPE, this.d_maxSlope);
        ud.accept(GenerateModelFromBIM.HEAD_HEIGHT, this.d_maxHeadHeight);
        b.accept(GenerateModelFromBIM.EXTRACT_ONLY_TOPS_OF_SOLIDS, this.d_topsOfSolids);
        b.accept(GenerateModelFromBIM.DEL_ROOMS_IN_SOLIDS, this.d_delRoomsInSolids);
        b.accept(GenerateModelFromBIM.CLOSE_GAPS, this.d_closeGaps);
        ud.accept(GenerateModelFromBIM.CLOSE_GAP_TOLERANCE, this.d_gapTolerance);
        b.accept(GenerateModelFromBIM.DEL_SMALL_ROOMS, this.d_delSmallRooms);
        ud.accept(GenerateModelFromBIM.MIN_ROOM_AREA, this.d_minRoomArea);
        b.accept(GenerateModelFromBIM.EXTRACT_DOORS, this.d_extractDoors);
        b.accept(GenerateModelFromBIM.EXTRACT_STAIRS, this.d_extractStairs);
        ud.accept(GenerateModelFromBIM.MAX_STAIR_RISER, this.d_maxStairRiser);
        ud.accept(GenerateModelFromBIM.MAX_STAIR_TREAD_GAP, this.d_maxStairTreadGap);
        ud.accept(GenerateModelFromBIM.MIN_COMP_WIDTH, this.d_minStairWidth);
    }
}

