/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.FloorSortActions;
import merlin.actions.SubtractAction;
import merlin.actions.TransformAction;
import merlin.actions.Undo;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.actions.importgeom.ImportUtil;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.material.Material;
import merlin.geom.IMerlinGeomSrc;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Warning;

public class FloorPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootClassName) {
        return FloorComposite.class.getName().equals(mdRootClassName);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, Map<IDomainObject, String> pasteObjMap, IDomainObject pasteObj) {
        PasteHints hints = new PasteHints();
        AABoxTest test = new AABoxTest(FloorPasteHandler.getBounds(pasteObj), 1.0E-6);
        final ArrayList hitComps = new ArrayList();
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc src, Containment ctmt) {
                if (src instanceof IEgressComp) {
                    hitComps.add((IEgressComp)src);
                }
            }
        };
        md.geomLocation.getLocator().find(test, (IResult<? super IDisplayableGeomSrc>)result, 3);
        hints.geomTransformShouldPrompt = !hitComps.isEmpty();
        return hints;
    }

    private static AABox getBounds(IDomainObject<MerlinData> obj) {
        Collection<IMerlinGeomSrc> elems = FloorPasteHandler.flattenToType(obj, IMerlinGeomSrc.class);
        AABox bounds = new AABox();
        for (IMerlinGeomSrc elem : elems) {
            bounds.add(elem.getBounds());
        }
        return bounds;
    }

    private static <T> Collection<T> flattenToType(IDomainObject<MerlinData> obj, Class<T> type) {
        if (obj instanceof Composite) {
            return ((Composite)obj).flatten(type);
        }
        if (obj != null && type.isAssignableFrom(obj.getClass())) {
            return Arrays.asList(obj);
        }
        assert (false) : "Unknown geom element: " + obj.getClass();
        return Collections.emptyList();
    }

    private boolean isFloor(IDomainObject<MerlinData> pasteObj) {
        return pasteObj.getClass().equals(Floor.class);
    }

    private boolean isGeomComposite(IDomainObject<MerlinData> pasteObj) {
        return pasteObj.getClass().equals(GeomComposite.class);
    }

    private HashMap<Floor, List<IMerlinGeomSrc>> transformPasteObjs(MerlinApp app, MerlinData md, Collection<IMerlinObj> geomObjs, TransformInfo xform) {
        ArrayList<EgressRoom> subtractors = new ArrayList<EgressRoom>();
        HashMap<Floor, List<IMerlinGeomSrc>> floorMap = new HashMap<Floor, List<IMerlinGeomSrc>>();
        for (IMerlinGeomSrc obj : TransformAction.getGeom(md, geomObjs)) {
            double minZ;
            Floor floor;
            obj.transform(xform);
            if (obj instanceof EgressRoom) {
                subtractors.add((EgressRoom)obj);
            }
            if (floorMap.get(floor = FloorSortActions.chooseFloor(md, new UnitDouble(minZ = obj.getBounds().getMinZ(), SI.METER))) == null) {
                floorMap.put(floor, new ArrayList());
            }
            floorMap.get(floor).add(obj);
        }
        int subtractOptions = TransformAction.getSubtractOptions(xform);
        ArrayList toClean = new ArrayList();
        SubtractAction.subtract(app, md, subtractOptions, toClean::add, subtractors);
        EgressRoom.cleanup(md, toClean);
        return floorMap;
    }

    private void geomGroupPaste(MerlinData md, GeomComposite geomGroup, HashMap<Floor, List<IMerlinGeomSrc>> floorMap, Floor floor, Collection<IDomainObject> selectAccum) {
        for (IMerlinGeomSrc obj : floorMap.get(floor)) {
            Undo.AddOp op = new Undo.AddOp(geomGroup, Arrays.asList(obj));
            Undo.insertEntry(md, op.perform(md.selection));
        }
        Undo.AddOp op = new Undo.AddOp(floor, Arrays.asList(geomGroup));
        Undo.insertEntry(md, op.perform(md.selection));
        selectAccum.add(geomGroup);
    }

    private void floorPaste(MerlinData md, HashMap<Floor, List<IMerlinGeomSrc>> floorMap, Floor floor, IDomainObject<MerlinData> pasteObj, Collection<IDomainObject> selectAccum) {
        for (IMerlinGeomSrc obj : floorMap.get(floor)) {
            Undo.AddOp op = new Undo.AddOp(floor, Arrays.asList(obj));
            Undo.insertEntry(md, op.perform(md.selection));
            selectAccum.add((IDomainObject)((Object)obj));
        }
        if (this.isFloor(pasteObj)) {
            selectAccum.add(floor);
        }
    }

    private void floorMapPasteApply(MerlinData md, HashMap<Floor, List<IMerlinGeomSrc>> floorMap, IDomainObject<MerlinData> pasteObj, Collection<IDomainObject> selectAccum) {
        for (Floor floor : floorMap.keySet()) {
            if (this.isGeomComposite(pasteObj)) {
                GeomComposite geomGroup = (GeomComposite)((GeomComposite)pasteObj).clone();
                this.geomGroupPaste(md, geomGroup, floorMap, floor, selectAccum);
                continue;
            }
            this.floorPaste(md, floorMap, floor, pasteObj, selectAccum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Map<IDomainObject, String> pasteObjMap, Map.Entry<IDomainObject, String> pasteEntry, PasteHints hints, Collection<IDomainObject> selectAccum, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves, Collection<Warning> warnings) {
        IDomainObject pasteObj = pasteEntry.getKey();
        Collection<IMerlinObj> geomObjs = FloorPasteHandler.flattenToType(pasteObj, IMerlinObj.class);
        IdentityHashSet<Material> usedMats = new IdentityHashSet<Material>();
        ImportUtil.getUsedMaterials(geomObjs, usedMats);
        md.beginWrite();
        try {
            Undo.begin(Intl.intl("Set Offset"));
            for (Material mat : usedMats) {
                if (md.materials.isLocal(mat)) continue;
                md.materials.add(mat);
            }
            HashMap<Floor, List<IMerlinGeomSrc>> floorMap = this.transformPasteObjs(app, md, geomObjs, hints.geomTransform);
            this.floorMapPasteApply(md, floorMap, pasteObj, selectAccum);
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }
}

