/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.copypaste.Paste;
import merlin.actions.copypaste.PthCopyDataContainer;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.io.MerlinIO;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.io.ObjectSelection;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Predicates;

public class Copy
extends AMerlinOp
implements IEventObserver {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Copy16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Copy(), Intl.intl("&Copy...,C,Copy selected objects"), ICON);

    public Copy() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    public static boolean canCopy(MerlinData md) {
        Map<IDomainObject, String> objMap = Copy.getPasteMap(md);
        return !objMap.isEmpty() && !objMap.entrySet().stream().allMatch(entry -> Paste.isUnsupported((IDomainObject)entry.getKey(), (String)entry.getValue()));
    }

    public static Map<IDomainObject, String> getPasteMap(MerlinData md) {
        LinkedHashMap<IDomainObject, String> objMap = new LinkedHashMap<IDomainObject, String>();
        IFilteredCollection<IDomainObject> rawObjs = md.selection.get(IDomainObject.class, Predicates.alwaysTrue());
        for (IDomainObject obj : rawObjs) {
            Object[] pathToObj = md.hierarchy.getPath(obj);
            if (pathToObj[0] != md) {
                System.err.printf("object not reachable from MerlinData, skipping: [%s] %s%n", obj.getClass().getName(), obj.toString());
                continue;
            }
            assert (pathToObj.length > 1 && pathToObj[0] == md);
            String mdRootClassName = "";
            if (pathToObj.length > 1) {
                mdRootClassName = pathToObj[1].getClass().getName();
                objMap.put(obj, mdRootClassName);
            }
            if (pathToObj.length != 2) continue;
            objMap.remove(obj);
            Composite mdRoot = (Composite)pathToObj[1];
            for (IDomainObject iDomainObject : mdRoot.getChildren()) {
                objMap.put(iDomainObject, mdRootClassName);
            }
        }
        return objMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Clipboard systemClipboard = defaultToolkit.getSystemClipboard();
        md.beginRead();
        try {
            Map<IDomainObject, String> objMap = Copy.getPasteMap(md);
            PthCopyDataContainer data = new PthCopyDataContainer(MerlinIO.Version.curr().num, objMap);
            ObjectSelection contents = new ObjectSelection(data, data.toString(), PthCopyDataContainer.DATAFLAVOR_BINARY);
            systemClipboard.setContents(contents, null);
        }
        finally {
            md.endRead();
        }
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(Copy.canCopy(md));
    }
}

