/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import common.geom.Trig;
import common.io.FileUtil;
import inferno.data2.ANode;
import inferno.data2.Blockage;
import inferno.data2.Camera;
import inferno.data2.Counter;
import inferno.data2.CylinderShape;
import inferno.data2.DoorDir;
import inferno.data2.EdgeData;
import inferno.data2.ElevatorLevel;
import inferno.data2.IAgentBodyShape;
import inferno.data2.IElevator;
import inferno.data2.IIdentifiable;
import inferno.data2.Material;
import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.data2.QBaseQueue;
import inferno.data2.QMetaQueue;
import inferno.data2.QPath;
import inferno.data2.QServicePoint;
import inferno.data2.StairData;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.data2.ai.AssistOccupantsGoal;
import inferno.data2.ai.AssistedEvacTeam;
import inferno.data2.ai.ChangeBehaviorGoal;
import inferno.data2.ai.ChangeCounterGoal;
import inferno.data2.ai.ChangeProfileGoal;
import inferno.data2.ai.ChangeTagGoal;
import inferno.data2.ai.DetachGoal;
import inferno.data2.ai.ElevatorGoal;
import inferno.data2.ai.ExitGoal;
import inferno.data2.ai.FillRoomGoal;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IWaitUntilSrc;
import inferno.data2.ai.JoinOccGroupGoal;
import inferno.data2.ai.PointGoal;
import inferno.data2.ai.QueueGoal;
import inferno.data2.ai.RoomGoal;
import inferno.data2.ai.SetOccPropGoal;
import inferno.data2.ai.WaitForAssistanceGoal;
import inferno.data2.ai.WaitForCounterGoal;
import inferno.data2.ai.WaitGoal;
import inferno.data2.ai.WaitUntilGoal;
import inferno.data2.ai.WaitUntilInsideGoal;
import inferno.data2.ai.WaitUntilTaggedGoal;
import inferno.data2.value.IFunction1d;
import inferno.sim.BehaviorSim;
import inferno.sim.DoorQueue;
import inferno.sim.ElevatorModel;
import inferno.sim.EngineOp;
import inferno.sim.IDoorFlowrate;
import inferno.sim.IOccGroup;
import inferno.sim.KB;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.OccProfileSim;
import inferno.sim.OccSource;
import inferno.sim.Param;
import inferno.sim.VehicleBody;
import inferno.util.BigDecimalOp;
import inferno.util.ComparePredicate;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.CancelledException;
import merlin.actions.InfernoUtil;
import merlin.actions.RunInferno;
import merlin.actions.UIHook;
import merlin.actions.WriteViews;
import merlin.actions.WriteVis;
import merlin.data.AMerlinObj;
import merlin.data.IGetJson;
import merlin.data.JsonObj;
import merlin.data.MeasurementRegionObj;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.scripting.ScriptObj;
import merlin.gui.guiUtil;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.io.IOUtil;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class WriteMesh
extends AMerlinOp {
    public static final int VERSION_001 = 1;
    public static final int VERSION_002 = 2;
    public static final int VERSION_003 = 3;
    public static final int VERSION_004 = 4;
    public static final int VERSION_005 = 5;
    public static final int VERSION_006 = 6;
    public static final int VERSION_007 = 7;
    public static final int VERSION_008 = 8;
    public static final int VERSION_009 = 9;
    public static final int CURR_VERSION = 9;
    public static final UIHook UI_HOOK = new UIHook(new WriteMesh(), Intl.intl("Save Si&mulator Input...,-,Write simulator input"));
    public static final Unit LENGTH_UNIT = SI.METER;
    public static final Unit VEL_UNIT = SI.METER.divide(SI.SECOND);
    public static final Unit TIME_UNIT = SI.SECOND;
    private static final Object DO_NOT_WRITE = "DO_NOT_WRITE";
    public static final Pattern GOAL_ESCAPE = Pattern.compile("([ ])|([\\;\\(\\)\\\"\\\\])");
    public static final Pattern NAME_ESCAPE = Pattern.compile("[\\\"\\\\]");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        try {
            app.beginWaitCursor();
            RunInferno.quickCheckForErrors(app, md);
        }
        catch (CancelledException e) {
            return;
        }
        finally {
            app.endWaitCursor();
        }
        File f = guiUtil.getSaveFile(app, md, MerlinPrefs.OPEN_DIR_PREF, md.getNewFilename(".txt"), "txt", Intl.intl("Inferno Mesh Files"));
        if (f == null) {
            return;
        }
        String rootFn = InfernoUtil.rootFn(f.getName());
        File dir = f.getParentFile();
        Param p = InfernoUtil.mkInfernoParam(app, md, dir, rootFn, false);
        ArrayList<SimError> errors = new ArrayList<SimError>();
        InfernoUtil.KBInfo kb = InfernoUtil.mkInfernoKB(md, p, app.getPrefs().getBoolean(MerlinPrefs.KEY_ANNOTATE), errors);
        WriteMesh.writeInputFile(app, md, f, kb, p);
    }

    private static String df(double d) {
        return Double.toString(d);
    }

    private static String ff(float f) {
        return Float.toString(f);
    }

    public static boolean writeInputFile(MerlinApp app, MerlinData md, File f, InfernoUtil.KBInfo kb, Param p) {
        try {
            WriteMesh.writeInputFile(md, f.getParentFile(), InfernoUtil.rootFn(f.getName()), kb, p);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            app.error(Intl.intl("File Error"), String.format(Intl.intl("Could not write file: %s"), f.getAbsolutePath()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputFile(MerlinData md, File dir, String rootFn, InfernoUtil.KBInfo kb, Param p) throws IOException {
        WriteMesh.createMetaFiles(md, p);
        File inputFile = FileUtil.getInputFn(dir, rootFn);
        try (PrintWriter fWrite = IOUtil.newPrintWriterUTF8(inputFile.getAbsolutePath());){
            md.beginRead();
            try {
                Map<BehaviorSim, Integer> behaviors = WriteMesh.getBehaviors(kb.kb);
                Map<OccProfileSim, Integer> profiles = WriteMesh.getProfiles(kb.kb, behaviors);
                Map<OccProfileSim.IShapeGen, Integer> shapes = WriteMesh.getShapes(kb.kb);
                Map<QMetaQueue, Integer> queuesMap = WriteMesh.getQueues(kb.kb);
                Map<IFunction1d, Integer> functions = WriteMesh.getFunctions(kb.kb, profiles.keySet(), behaviors.keySet());
                Map<IDistributedVal<?>, Integer> distributions = WriteMesh.buildDistributionIxMap(kb.kb, profiles, behaviors, queuesMap);
                Map<Material, Integer> mats = WriteMesh.getMatMap(kb.kb);
                Map<Counter, Integer> counters = WriteMesh.getCounters(kb.kb, behaviors.keySet());
                Map<AssistedEvacTeam, Integer> aeteams = WriteMesh.getAETeams(kb.kb);
                Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap = WriteMesh.getCompRestrictions(kb.kb);
                WriteMesh.writeVersion(fWrite);
                WriteMesh.writeParam(fWrite, p);
                WriteMesh.writeMaterials(fWrite, kb.kb, mats);
                WriteMesh.writeFloors(fWrite, md);
                Map<ANode, Integer> nodeMap = WriteMesh.writeNodes(fWrite, kb);
                Map<Vertex, Integer> vertMap = WriteMesh.writeVerts(fWrite, kb.kb);
                WriteMesh.writeStairs(fWrite, kb.kb, nodeMap);
                WriteMesh.writeDoors(fWrite, kb.kb, nodeMap, distributions);
                WriteMesh.writeEdges(fWrite, kb.kb, nodeMap, vertMap);
                WriteMesh.writeMesh(fWrite, kb.kb, nodeMap, vertMap);
                WriteMesh.writeCameras(fWrite, kb.kb);
                WriteMesh.writeBlockages(fWrite, kb.kb, mats);
                WriteMesh.writeElevators(fWrite, kb.kb, nodeMap);
                WriteMesh.writeEvents(fWrite, kb.kb, nodeMap);
                WriteMesh.writeJson(fWrite, md, kb.kb);
                WriteMesh.writeQueues(fWrite, queuesMap, distributions);
                WriteMesh.writeShapes(fWrite, kb.kb, shapes, distributions);
                WriteMesh.writeAssistedEvacTeams(fWrite, aeteams);
                WriteMesh.writeBehaviors(fWrite, kb.kb, behaviors, profiles, nodeMap, distributions, counters, shapes, aeteams, functions, compRestrictionsMap, queuesMap);
                WriteMesh.writeTags(fWrite, kb.kb);
                WriteMesh.writeProfiles(fWrite, profiles.keySet(), shapes, functions, distributions, compRestrictionsMap);
                WriteMesh.writeFunctions(fWrite, functions.keySet());
                WriteMesh.writeDistributions(fWrite, distributions.keySet());
                WriteMesh.writeCompRestrictions(fWrite, compRestrictionsMap, nodeMap);
                WriteMesh.writeOccs(fWrite, kb.kb, profiles, behaviors, functions, shapes, compRestrictionsMap);
                WriteMesh.writeOccSources(fWrite, kb.kb, profiles, behaviors, functions, nodeMap, distributions);
                WriteMesh.writeOccGroups(fWrite, kb.kb, profiles, behaviors, distributions);
                WriteMesh.writeCounters(fWrite, counters);
            }
            finally {
                md.endRead();
            }
        }
    }

    public static void createMetaFiles(MerlinData md, Param p) throws IOException {
        File visFile = new File(p.imported_geom);
        File viewsFile = new File(p.views);
        WriteViews.writeInputFile(md, viewsFile.getAbsolutePath());
        try {
            WriteVis.writeVis(md, visFile, false);
        }
        catch (IOException e) {
            System.err.println("[WriteMesh] Could not create geom file:");
            e.printStackTrace();
        }
    }

    private static Map<Counter, Integer> getCounters(KB kb, Collection<BehaviorSim> behaviors) {
        LinkedIdentityHashMap<Counter, Integer> counters = new LinkedIdentityHashMap<Counter, Integer>();
        Consumer<Counter> add = c -> counters.putIfAbsent((Counter)c, counters.size());
        for (BehaviorSim behavior : behaviors) {
            for (IGoal goal : behavior) {
                if (goal instanceof ChangeCounterGoal) {
                    add.accept(((ChangeCounterGoal)goal).counter);
                    continue;
                }
                if (!(goal instanceof WaitForCounterGoal)) continue;
                add.accept(((WaitForCounterGoal)goal).counter);
            }
        }
        return counters;
    }

    private static Map<OccProfileSim, Integer> getProfiles(KB kb, Map<BehaviorSim, Integer> behaviors) {
        LinkedHashMap<OccProfileSim, Integer> profileIxMap = new LinkedHashMap<OccProfileSim, Integer>();
        for (Occupant occ : kb.getOccs()) {
            profileIxMap.putIfAbsent(occ.parentProfile, profileIxMap.size());
        }
        for (OccSource occSource : kb.getOccSources()) {
            for (OccProfileSim prof : occSource.getProfiles(false)) {
                profileIxMap.putIfAbsent(prof, profileIxMap.size());
            }
        }
        IdentityHashSet visitedBehaviors = new IdentityHashSet();
        for (BehaviorSim behavior : behaviors.keySet()) {
            behavior.getReferencedProfiles(visitedBehaviors, profile -> profileIxMap.putIfAbsent((OccProfileSim)profile, profileIxMap.size()));
        }
        return profileIxMap;
    }

    private static Map<BehaviorSim, Integer> getBehaviors(KB kb) {
        LinkedHashMap<BehaviorSim, Integer> result = new LinkedHashMap<BehaviorSim, Integer>();
        LinkedHashSet usedBehaviors = new LinkedHashSet();
        kb.getOccs().forEach(occ -> usedBehaviors.add(occ.behavior));
        kb.getOccSources().forEach(source -> usedBehaviors.addAll(source.getBehaviors()));
        LinkedHashSet allUsedBehaviors = new LinkedHashSet(usedBehaviors);
        usedBehaviors.forEach(b -> b.getReferencedBehaviors(allUsedBehaviors));
        allUsedBehaviors.forEach(b -> result.putIfAbsent((BehaviorSim)b, result.size()));
        return result;
    }

    private static Map<QueueObject, Integer> getQueues(MerlinData md) {
        LinkedHashMap<QueueObject, Integer> result = new LinkedHashMap<QueueObject, Integer>();
        md.queues.flatten(QueueObject.class).forEach(q -> result.putIfAbsent((QueueObject)q, result.size()));
        return result;
    }

    private static Map<QMetaQueue, Integer> getQueues(KB kb) {
        LinkedHashMap<QMetaQueue, Integer> result = new LinkedHashMap<QMetaQueue, Integer>();
        kb.getBaseQueues().forEach(q -> result.putIfAbsent((QMetaQueue)q, result.size()));
        kb.getMetaQueues().forEach(q -> result.putIfAbsent((QMetaQueue)q, result.size()));
        return result;
    }

    private static Map<OccProfileSim.IShapeGen, Integer> getShapes(KB kb) {
        LinkedHashMap<OccProfileSim.IShapeGen, Integer> shapeIxMap = new LinkedHashMap<OccProfileSim.IShapeGen, Integer>();
        Consumer<OccProfileSim.IShapeGen> addShape = shape -> shapeIxMap.putIfAbsent((OccProfileSim.IShapeGen)shape, shapeIxMap.size());
        IdentityHashSet visitedBehaviors = new IdentityHashSet();
        for (Occupant occ : kb.getOccs()) {
            if (occ.bodyShape instanceof PolygonShape) {
                addShape.accept(occ.bodyShape.toShapeGen());
            }
            addShape.accept(occ.parentProfile.getProp(OccProfileSim.PROP_SHAPE));
            occ.behavior.getFutureProfileValues(visitedBehaviors, OccProfileSim.PROP_SHAPE, addShape);
        }
        for (OccSource occSource : kb.getOccSources()) {
            occSource.getFutureProfileValues(OccProfileSim.PROP_SHAPE, addShape);
        }
        return shapeIxMap;
    }

    private static Map<IFunction1d, Integer> getFunctions(KB kb, Collection<OccProfileSim> profiles, Collection<BehaviorSim> behaviors) {
        LinkedHashMap<IFunction1d, Integer> functions = new LinkedHashMap<IFunction1d, Integer>();
        Consumer<IFunction1d> add = f -> functions.putIfAbsent((IFunction1d)f, functions.size());
        for (Occupant o : kb.getOccs()) {
            add.accept(o.fundamental);
            add.accept(o.stairSpeed.upSpeed);
            add.accept(o.stairSpeed.upFundamental);
            add.accept(o.stairSpeed.downSpeed);
            add.accept(o.stairSpeed.downFundamental);
            add.accept(o.rampSpeed.upSpeed);
            add.accept(o.rampSpeed.upFundamental);
            add.accept(o.rampSpeed.downSpeed);
            add.accept(o.rampSpeed.downFundamental);
        }
        for (OccSource occSource : kb.getOccSources()) {
            add.accept(occSource.getFlowrate());
        }
        for (OccProfileSim prof : profiles) {
            add.accept(prof.getProperty(OccProfileSim.PROP_FUNDAMENTAL));
            add.accept(prof.getProperty(OccProfileSim.PROP_STAIR_SPEED_UP));
            add.accept((IFunction1d)prof.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_UP).apply(prof));
            add.accept(prof.getProperty(OccProfileSim.PROP_STAIR_SPEED_DOWN));
            add.accept((IFunction1d)prof.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_DOWN).apply(prof));
            add.accept(prof.getProperty(OccProfileSim.PROP_RAMP_SPEED_UP));
            add.accept((IFunction1d)prof.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_UP).apply(prof));
            add.accept(prof.getProperty(OccProfileSim.PROP_RAMP_SPEED_DOWN));
            add.accept((IFunction1d)prof.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_DOWN).apply(prof));
        }
        for (BehaviorSim behavior : behaviors) {
            for (IGoal goal : behavior) {
                if (!(goal instanceof SetOccPropGoal)) continue;
                SetOccPropGoal sopg = (SetOccPropGoal)goal;
                if (!(sopg.value instanceof IFunction1d)) continue;
                add.accept((IFunction1d)sopg.value);
            }
        }
        return functions;
    }

    private static Map<IDistributedVal<?>, Integer> buildDistributionIxMap(KB kb, Map<OccProfileSim, Integer> profiles, Map<BehaviorSim, Integer> behaviors, Map<QMetaQueue, Integer> queues) {
        LinkedHashMap distributions = new LinkedHashMap();
        Consumer<IDistributedVal> addDist = dist -> distributions.putIfAbsent((IDistributedVal<?>)dist, distributions.size());
        Map<Object, IPropertySet.Prop<?>> allProps = OccProfileSim.PROP_TYPES_MAP;
        for (OccProfileSim prof : profiles.keySet()) {
            for (IPropertySet.Prop<?> p : allProps.values()) {
                Object prop = WriteMesh.getProfileProp(prof, p);
                if (prop instanceof IDistributedVal) {
                    addDist.accept((IDistributedVal)prop);
                    continue;
                }
                if (!(prop instanceof OccProfileSim.CylShapeGen)) continue;
                OccProfileSim.CylShapeGen cyl = (OccProfileSim.CylShapeGen)prop;
                if (!(cyl.shoulderWidth instanceof ConstantCurve)) {
                    addDist.accept(cyl.shoulderWidth);
                }
                if (cyl.height instanceof ConstantCurve) continue;
                addDist.accept(cyl.height);
            }
        }
        for (BehaviorSim goal : behaviors.keySet()) {
            for (IGoal g : goal) {
                if (g instanceof WaitGoal) {
                    addDist.accept(((WaitGoal)g).time);
                    continue;
                }
                if (g instanceof WaitUntilGoal) {
                    WaitUntilGoal wg = (WaitUntilGoal)g;
                    if (wg.waitSrc instanceof IWaitUntilSrc.SimpleWaitUntilSrc) {
                        addDist.accept(((IWaitUntilSrc.SimpleWaitUntilSrc)wg.waitSrc).d_waitTime);
                        continue;
                    }
                    if (wg.waitSrc instanceof IWaitUntilSrc.CycledWaitUntilSrc) {
                        addDist.accept(((IWaitUntilSrc.CycledWaitUntilSrc)wg.waitSrc).d_initialTime);
                        addDist.accept(((IWaitUntilSrc.CycledWaitUntilSrc)wg.waitSrc).d_intervalTime);
                        continue;
                    }
                    if (!(wg.waitSrc instanceof IWaitUntilSrc.ListedWaitUntilSrc)) continue;
                    IWaitUntilSrc.ListedWaitUntilSrc listSrc = (IWaitUntilSrc.ListedWaitUntilSrc)wg.waitSrc;
                    for (ICurve curve : listSrc.d_goTimes) {
                        addDist.accept(curve);
                    }
                    continue;
                }
                if (!(g instanceof SetOccPropGoal)) continue;
                SetOccPropGoal sopg = (SetOccPropGoal)g;
                if (!(sopg.value instanceof IDistributedVal)) continue;
                addDist.accept((IDistributedVal)sopg.value);
            }
        }
        for (OccGroupType groupType : kb.getOccupantGroupTypes()) {
            if (groupType.allowSmallerGroups) {
                addDist.accept(groupType.minNumberOfMembers);
            }
            addDist.accept(groupType.prefNumberOfMembers);
            if (groupType.profileMap == null) continue;
            for (OccProfileSim prof : groupType.profileMap.keySet()) {
                OccGroupType.GroupCreationData groupCreationData = groupType.profileMap.get(prof);
                addDist.accept(groupCreationData.prefNumberOfMembers);
                if (!groupCreationData.allowSmallerGroups) continue;
                addDist.accept(groupCreationData.minNumberOfMembers);
            }
        }
        for (ANode door : kb.getDoorNodes()) {
            IDistributedVal waitTime = door.doorQueue.getWaitTime();
            if (waitTime == null || waitTime instanceof ConstantCurve && theUtil.eq0(((ConstantCurve)waitTime).getValue().getValueNoUnit(), 1.0E-6)) continue;
            addDist.accept(waitTime);
        }
        for (OccSource source : kb.getOccSources()) {
            addDist.accept(WriteMesh.toIndexUrn(source.getProfileUrn(), profiles::get));
            addDist.accept(WriteMesh.toIndexUrn(source.getBehaviorUrn(), behaviors::get));
            if (source.getGroupUrn() == null) continue;
            addDist.accept(WriteMesh.toIndexUrn(source.getGroupUrn(), type -> type.getID()));
        }
        for (BehaviorSim behavior : behaviors.keySet()) {
            for (IGoal goal : behavior.goals) {
                if (goal instanceof ChangeBehaviorGoal) {
                    ChangeBehaviorGoal changeBehaviorGoal = (ChangeBehaviorGoal)goal;
                    addDist.accept(WriteMesh.toIndexUrn(changeBehaviorGoal.getBehaviorUrn(), behaviors::get));
                    continue;
                }
                if (!(goal instanceof ChangeProfileGoal)) continue;
                ChangeProfileGoal changeProfileGoal = (ChangeProfileGoal)goal;
                addDist.accept(WriteMesh.toIndexUrn(changeProfileGoal.getProfileUrn(), profiles::get));
            }
        }
        for (QBaseQueue baseQueue : kb.getBaseQueues()) {
            for (QServicePoint qsp : baseQueue.getServicePoints()) {
                addDist.accept(qsp.getServiceTimeDistribution());
            }
            for (QPath qolp : baseQueue.getPaths()) {
                addDist.accept(qolp.getPathSpacingDistribution());
            }
            if (baseQueue.getDistributionUrn() == null) continue;
            addDist.accept(WriteMesh.toIndexUrn(baseQueue.getDistributionUrn(), queues::get));
        }
        return distributions;
    }

    private static Object getProfileProp(OccProfileSim prof, IPropertySet.Prop<?> p) {
        if (!prof.isDefined(p)) {
            return DO_NOT_WRITE;
        }
        Object prop = prof.getProperty(p);
        if (Objects.equals(prop, p.defVal)) {
            return DO_NOT_WRITE;
        }
        return prop;
    }

    public static void writeVersion(PrintWriter out) {
        out.println("[version]");
        out.println(9);
        out.println();
    }

    public static void writeParam(PrintWriter out, Param p) {
        out.println("[param]");
        WriteMesh.writeParam(out, p, 8, "show_vis");
        out.println();
        WriteMesh.writeParam(out, p, 12, "dt_init");
        WriteMesh.writeParam(out, p, 12, "max_time");
        WriteMesh.writeParam(out, p, 12, "dt_csv_data");
        WriteMesh.writeParam(out, p, 12, "dt_vis");
        WriteMesh.writeParam(out, p, 12, "dt_wall_meta");
        WriteMesh.writeParam(out, p, 12, "dt_snapshot");
        out.println();
        WriteMesh.writeParam(out, p, 17, "reactive_steering");
        WriteMesh.writeParam(out, p, 17, "inertia");
        WriteMesh.writeParam(out, p, 17, "handle_collisions");
        WriteMesh.writeParam(out, p, 17, "vel_from_density");
        WriteMesh.writeParam(out, p, 17, "density_max");
        out.println();
        WriteMesh.writeParam(out, p, 17, "specific_flowrate_max");
        WriteMesh.writeParam(out, p, 27, "door_flow_from_density");
        WriteMesh.writeParam(out, p, 27, "door_flow_density_min");
        WriteMesh.writeParam(out, p, 27, "door_flow_density_max");
        WriteMesh.writeParam(out, p, 27, "boundary_layer");
        WriteMesh.writeParam(out, p, 27, "low_speed_threshold");
        WriteMesh.writeParam(out, p, 27, "max_trim_error");
        WriteMesh.writeParam(out, p, 27, "min_flowrate_factor");
        WriteMesh.writeParam(out, p, 27, "occ_csv_file_as_one");
        WriteMesh.writeParam(out, p, 27, "write_occ_params_file");
        WriteMesh.writeParam(out, p, 27, "measurement_region_seekspeed");
        WriteMesh.writeParam(out, p, 27, "force_separation");
        WriteMesh.writeParam(out, p, 27, "social_distance_csv_output");
        WriteMesh.writeParam(out, p, 27, "social_distance_value");
        WriteMesh.writeParam(out, p, 27, "out_occ_time_history", true);
        WriteMesh.writeParam(out, p, 27, "out_geom_time_history", true);
        WriteMesh.writeParam(out, p, 27, "out_room_usage", true);
        WriteMesh.writeParam(out, p, 27, "out_door_usage", true);
        WriteMesh.writeParam(out, p, 27, "out_summary", true);
        WriteMesh.writeParam(out, p, 27, "out_performance", true);
        WriteMesh.writeParam(out, p, 27, "out_snapshot_base", true);
        WriteMesh.writeParam(out, p, 27, "out_results", true);
        File geomFile = new File(p.imported_geom);
        File viewsFile = new File(p.views);
        if (geomFile.exists()) {
            WriteMesh.writeParam(out, p, 27, "imported_geom", true);
        }
        if (viewsFile.exists()) {
            WriteMesh.writeParam(out, p, 27, "views", true);
        }
        if (p.smvDataEnable) {
            out.println();
            WriteMesh.writeParam(out, p, 19, "smvDataEnable");
            if (p.smvSmokeSlowEnable) {
                WriteMesh.writeParam(out, p, 19, "smvSmokeSlowEnable");
            }
            WriteMesh.writeParam(out, p, 19, "smvDataFilePath");
            WriteMesh.writeParam(out, p, 19, "smvDataLastModified");
            WriteMesh.writeParam(out, p, 19, "smvHypoxiaLimit");
        }
        out.println();
    }

    private static void writeParam(PrintWriter out, Param p, int w, String var) {
        WriteMesh.writeParam(out, p, w, var, false);
    }

    private static void writeParam(PrintWriter out, Param p, int w, String var, boolean isFileName) {
        String sVal;
        Object oVal = p.get(var);
        assert (oVal != null);
        if (oVal instanceof Boolean) {
            sVal = (Boolean)oVal != false ? "1" : "0";
        } else if (oVal instanceof String) {
            if (isFileName) {
                oVal = ((String)oVal).substring(((String)oVal).lastIndexOf("\\") + 1);
            }
            sVal = WriteMesh.escapeName(oVal.toString());
        } else {
            sVal = oVal.toString();
        }
        String formatStr = "%-" + w + "s %s%n";
        out.printf(formatStr, var, sVal);
    }

    public static void writeMaterials(PrintWriter out, KB kb, Map<Material, Integer> mats) {
        if (mats.isEmpty()) {
            return;
        }
        out.println("[materials]");
        for (Map.Entry<Material, Integer> entry : mats.entrySet()) {
            Material mat = entry.getKey();
            out.printf("%d: %s %s %s%n", entry.getValue(), mat.imageName, WriteMesh.df(mat.worldWidth), WriteMesh.df(mat.worldHeight));
        }
        out.println();
    }

    private static Map<Material, Integer> getMatMap(KB kb) {
        int ix = 0;
        LinkedHashMap<Material, Integer> mats = new LinkedHashMap<Material, Integer>();
        for (Blockage blkg : kb.getBlockages()) {
            Material mat = blkg.getDisplay();
            if (mat == null || mats.containsKey(mat)) continue;
            mats.put(mat, ix++);
        }
        return mats;
    }

    public static void writeFloors(PrintWriter out, MerlinData md) {
        out.println("[floors]");
        int ix = 0;
        for (Floor floor : md.floors.getMembers(Floor.class)) {
            out.printf("%d: %s %s%n", ix, WriteMesh.escapeName(floor.getName()), WriteMesh.df(floor.getWorkingZ().getValue(InfernoUtil.LENGTH_UNIT)));
            ++ix;
        }
        out.println();
    }

    public static Map<ANode, Integer> writeNodes(PrintWriter out, InfernoUtil.KBInfo kb) {
        int m;
        IdentityHashMap<ANode, IEgressComp> nodeMap = new IdentityHashMap<ANode, IEgressComp>();
        for (Map.Entry<IEgressComp, ANode> entry : kb.nodeMap.entrySet()) {
            nodeMap.put(entry.getValue(), entry.getKey());
        }
        IdentityHashMap<ANode, Integer> nodeIxMap = new IdentityHashMap<ANode, Integer>();
        HashMap<IPrimProps, Integer> nodeDispMap = new HashMap<IPrimProps, Integer>();
        int[] nodeDisps = new int[kb.kb.getNodes().size()];
        out.println("[nodedisp]");
        for (m = 0; m < kb.kb.getNodes().size(); ++m) {
            ANode node = kb.kb.getNodes().get(m);
            nodeIxMap.put(node, m);
            nodeDisps[m] = WriteMesh.getNodeDisplay(node, nodeMap, nodeDispMap, out);
        }
        out.println();
        out.println("[nodes]");
        for (m = 0; m < kb.kb.getNodes().size(); ++m) {
            ANode n = kb.kb.getNodes().get(m);
            String capacityStr = "";
            ANode.Capacity c = n.getCapacity();
            if (c != null) {
                if (c instanceof ANode.Count) {
                    capacityStr = capacityStr + String.format(", %s %d", "count", c.getMaxOccCount());
                } else if (c instanceof ANode.Density) {
                    capacityStr = capacityStr + String.format(", %s %f", "dens", ((ANode.Density)c).getDensity());
                } else assert (false);
            }
            out.printf("%d: %s %d, %d%s%n", m, WriteMesh.escapeName(n.name), nodeDisps[m], n.getAnimationId(), capacityStr);
        }
        out.println();
        return nodeIxMap;
    }

    private static int getNodeDisplay(ANode node, Map<ANode, IEgressComp> nodeMap, Map<IPrimProps, Integer> nodeDispMap, PrintWriter out) {
        IPrimProps.Face props;
        Integer dix;
        IEgressComp comp = nodeMap.get(node);
        assert (comp != null);
        if (comp == null || comp.getColor() == null) {
            return -1;
        }
        Color color = comp.getColor();
        int alpha = (int)(comp.getOpacity() * 255.0f);
        if (alpha != color.getAlpha()) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        if ((dix = nodeDispMap.get(props = new IPrimProps.Face(color, null, 0))) == null) {
            dix = nodeDispMap.size();
            nodeDispMap.put(props, dix);
            out.print(dix);
            out.print(": ");
            float[] ccomps = new float[4];
            color.getComponents(ccomps);
            for (float c : ccomps) {
                out.print(c);
                out.print(" ");
            }
            out.println();
        }
        return dix;
    }

    public static Map<Vertex, Integer> writeVerts(PrintWriter out, KB kb) {
        out.println("[verts]");
        IdentityHashMap<Vertex, Integer> vertMap = new IdentityHashMap<Vertex, Integer>();
        int ix = 0;
        for (Vertex v : kb.getMesh().getVerts()) {
            out.printf("%d: %s %s %s%n", ix, WriteMesh.df(v.p.x), WriteMesh.df(v.p.y), WriteMesh.df(v.p.z));
            vertMap.put(v, ix);
            ++ix;
        }
        out.println();
        return vertMap;
    }

    public static void writeStairs(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap) {
        out.println("[stairs]");
        int ix = 0;
        for (ANode stair : kb.getStairNodes()) {
            int ixNode = nodeMap.get(stair);
            StairData sd = stair.stairData;
            out.printf("%d: %d %s %s%n", ix, ixNode, WriteMesh.df(sd.rise), WriteMesh.df(sd.tread));
            ++ix;
        }
        out.println();
    }

    public static void writeDoors(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap, Map<IDistributedVal<?>, Integer> distributions) {
        out.println("[doors]");
        int ix = 0;
        for (ANode door : kb.getDoorNodes()) {
            DoorQueue dq = door.doorQueue;
            int ixNode = nodeMap.get(door);
            double effWid = dq.getEffWidth();
            String r1 = "-";
            String r2 = "-";
            if (dq.getR1() != null) {
                r1 = nodeMap.get(dq.getR1()).toString();
            }
            if (dq.getR2() != null) {
                r2 = nodeMap.get(dq.getR2()).toString();
            }
            IDoorFlowrate fr = dq.getFlowrate();
            DoorDir onewayDir = door.getOnewayDir();
            IDistributedVal waitTime = door.doorQueue.getWaitTime();
            String wt = waitTime == null || waitTime instanceof ConstantCurve && theUtil.eq0(((ConstantCurve)waitTime).getAvg().getValueNoUnit(), 1.0E-6) ? "-" : "" + distributions.get(waitTime);
            out.printf("%d: %d %s %s %s %s %s %s%n", ix, ixNode, WriteMesh.df(effWid), r1, r2, WriteMesh.format(fr), WriteMesh.format(onewayDir), wt);
            ++ix;
        }
        out.println();
    }

    private static String format(IDoorFlowrate fr) {
        if (fr instanceof IDoorFlowrate.Fixed) {
            IDoorFlowrate.Fixed fixed = (IDoorFlowrate.Fixed)fr;
            return WriteMesh.df(fixed.flowrate);
        }
        return "-";
    }

    private static String format(DoorDir dir) {
        if (dir == null) {
            return "-";
        }
        if (dir == DoorDir.POSITIVE) {
            return "dir+";
        }
        return "dir-";
    }

    public static void writeMesh(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap, Map<Vertex, Integer> vertMap) {
        out.println("[navmesh]");
        int ix = 0;
        for (Tri mt : kb.getMesh().getTris()) {
            int ixNode = nodeMap.get(mt.node);
            String strType = WriteMesh.getTypeStr(mt.terrain);
            out.printf("%d: %d %s %d %d %d%n", ix, ixNode, strType, vertMap.get(mt.v[0]), vertMap.get(mt.v[1]), vertMap.get(mt.v[2]));
            ++ix;
        }
        out.println();
    }

    private static void writeIndexes(PrintWriter out, int ... ixes) {
        for (int triid : ixes) {
            out.print(triid);
            out.print(' ');
        }
    }

    private static void writeIndexes(PrintWriter out, Collection<Integer> ixes) {
        for (int triid : ixes) {
            out.print(triid);
            out.print(' ');
        }
    }

    private static void writeObjIndexes(PrintWriter out, Collection<? extends IIdentifiable> ixes) {
        for (IIdentifiable iIdentifiable : ixes) {
            out.print(iIdentifiable.getId());
            out.print(' ');
        }
    }

    public static void writeBlockages(PrintWriter out, KB kb, Map<Material, Integer> mats) {
        if (kb.getBlockages().isEmpty()) {
            return;
        }
        out.println("[blockages]");
        int ix = 0;
        for (Blockage blkg : kb.getBlockages()) {
            Integer matix = mats.get(blkg.getDisplay());
            if (matix == null) {
                matix = -1;
            }
            out.printf("%d: %s %d %s ", ix, WriteMesh.escapeName(blkg.getName()), matix, WriteMesh.df(blkg.getVelFactor()));
            WriteMesh.writeIndexes(out, blkg.getTriIds());
            out.println();
            ++ix;
        }
        out.println();
    }

    public static void writeCameras(PrintWriter out, KB kb) {
        if (kb.getCameras().isEmpty()) {
            return;
        }
        out.println("[cameras]");
        int ix = 0;
        for (Camera cam : kb.getCameras()) {
            Point3d loc = cam.get(Camera.PROP_LOC);
            Point3d ref = cam.get(Camera.PROP_REF);
            Vector3d up = cam.get(Camera.PROP_UP);
            Point2d zoomLoc = cam.get(Camera.PROP_ZOOM_LOC);
            out.printf("%d: %s %s %s (%s %s %s) (%s %s %s) (%s %s %s) %s (%s %s) %d", ix, WriteMesh.escapeName(cam.get(Camera.PROP_NAME)), cam.get(Camera.PROP_TYPE) == Camera.Type.ORTHO ? "2D" : "3D", WriteMesh.df(cam.get(Camera.PROP_FOV)), WriteMesh.df(loc.x), WriteMesh.df(loc.y), WriteMesh.df(loc.z), WriteMesh.df(ref.x), WriteMesh.df(ref.y), WriteMesh.df(ref.z), WriteMesh.df(up.x), WriteMesh.df(up.y), WriteMesh.df(up.z), WriteMesh.df(cam.get(Camera.PROP_ZOOM)), WriteMesh.df(zoomLoc.x), WriteMesh.df(zoomLoc.y), cam.get(Camera.PROP_SECURITY) != false ? 1 : 0);
            if (cam.get(Camera.PROP_SECURITY).booleanValue()) {
                Vector3d panAxis = cam.get(Camera.PROP_PTZ_ORIENT);
                Camera.PTZSpec pan = cam.get(Camera.PROP_PAN_INFO);
                Camera.PTZSpec tilt = cam.get(Camera.PROP_TILT_INFO);
                Camera.PTZSpec zoom = cam.get(Camera.PROP_ZOOM_INFO);
                out.printf(" (%s %s %s) (%s %s %s) (%s %s %s) (%s %s %s)", WriteMesh.df(panAxis.x), WriteMesh.df(panAxis.y), WriteMesh.df(panAxis.z), WriteMesh.df(pan.rangeMin), WriteMesh.df(pan.rangeMax), WriteMesh.df(pan.maxSpeed), WriteMesh.df(tilt.rangeMin), WriteMesh.df(tilt.rangeMax), WriteMesh.df(tilt.maxSpeed), WriteMesh.df(zoom.rangeMin), WriteMesh.df(zoom.rangeMax), WriteMesh.df(zoom.maxSpeed));
            }
            out.println();
            ++ix;
        }
        System.out.println();
    }

    public static void writeJson(PrintWriter out, MerlinData md, KB kb) {
        ArrayList<AMerlinObj> stuffToWriteAsJson = new ArrayList<AMerlinObj>();
        stuffToWriteAsJson.addAll(md.json.flatten(JsonObj.class));
        stuffToWriteAsJson.addAll(md.regions.flatten(MeasurementRegionObj.class, r -> r.isEnabled()));
        stuffToWriteAsJson.addAll(md.customScripts.flatten(ScriptObj.class));
        if (!stuffToWriteAsJson.isEmpty()) {
            out.println("[json]");
            for (IGetJson iGetJson : stuffToWriteAsJson) {
                String str = iGetJson.getJson();
                str = str.replaceAll("\n", " ");
                out.println(str);
            }
            out.println();
        }
    }

    public static void writeEvents(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap) {
        NavigableMap<Double, EngineOp> events = kb.getEvents();
        if (events.isEmpty()) {
            return;
        }
        out.println("[events]");
        IdentityHashMap<Blockage, Integer> blkgIdMap = new IdentityHashMap<Blockage, Integer>();
        for (int m = 0; m < kb.getBlockages().size(); ++m) {
            blkgIdMap.put(kb.getBlockages().get(m), m);
        }
        ArrayList<EngineOp> tevents = new ArrayList<EngineOp>();
        for (Map.Entry entry : events.entrySet()) {
            tevents.clear();
            WriteMesh.flatten((EngineOp)entry.getValue(), tevents);
            for (EngineOp op : tevents) {
                out.print(WriteMesh.df((Double)entry.getKey()));
                out.print(' ');
                if (op instanceof EngineOp.AddBlockage) {
                    EngineOp.AddBlockage ablkg = (EngineOp.AddBlockage)op;
                    out.printf("add_blockage %s", blkgIdMap.get(ablkg.b));
                } else if (op instanceof EngineOp.RemoveBlockage) {
                    EngineOp.RemoveBlockage rblkg = (EngineOp.RemoveBlockage)op;
                    out.printf("remove_blockage %s", blkgIdMap.get(rblkg.b));
                } else if (op instanceof EngineOp.SetDoorState) {
                    EngineOp.SetDoorState sds = (EngineOp.SetDoorState)op;
                    int ix = nodeMap.get(sds.door);
                    double openTime = sds.est == null || sds.est.getTime(kb, null) == Double.POSITIVE_INFINITY ? -1.0 : sds.est.getTime(kb, null);
                    String cmd = "";
                    if (sds.openOrClose) {
                        cmd = sds.est == null ? "open_door" : "close_door";
                    } else if (sds.setDirection) {
                        cmd = "change_door_dir " + sds.onewayVec.x + " " + sds.onewayVec.y;
                    }
                    out.printf("%s %d %.1f", cmd, ix, openTime);
                } else if (op instanceof EngineOp.SetSpeedModifier) {
                    String type;
                    EngineOp.SetSpeedModifier sm = (EngineOp.SetSpeedModifier)op;
                    switch (sm.modifier.type) {
                        case CONSTANT: {
                            type = "CONSTANT";
                            break;
                        }
                        case FACTOR: {
                            type = "FACTOR";
                            break;
                        }
                        default: {
                            assert (false);
                            type = "";
                        }
                    }
                    out.printf("set_speed_mod %s %s ", type, WriteMesh.df(sm.modifier.value));
                    WriteMesh.writeObjIndexes(out, sm.tris);
                }
                out.println();
            }
        }
        out.println();
    }

    private static void flatten(EngineOp op, List<EngineOp> ops) {
        ArrayDeque<EngineOp> open = new ArrayDeque<EngineOp>();
        open.push(op);
        while (!open.isEmpty()) {
            op = (EngineOp)open.pop();
            if (op instanceof EngineOp.MultiOp) {
                EngineOp.MultiOp mop = (EngineOp.MultiOp)op;
                for (EngineOp cop : mop.ops) {
                    open.push(cop);
                }
                continue;
            }
            ops.add(op);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeElevators(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap) {
        void var7_14;
        Object elevator;
        int m;
        ElevatorModel em = kb.getElevatorModel();
        List<IElevator> elevators = em.getElevators();
        if (elevators.isEmpty()) {
            return;
        }
        out.println("[elevators]");
        for (m = 0; m < elevators.size(); ++m) {
            elevator = elevators.get(m);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("id", m);
            jSONObject.put("name", elevator.getName());
            jSONObject.put("call_distance", elevator.getCallDistance());
            jSONObject.put("double_deck", elevator.isDoubleDeck());
            jSONObject.put("initial_floor", nodeMap.get(elevator.getInitNode()));
            if (elevator.isDoubleDeck()) {
                jSONObject.put("lower_deck_discharge", nodeMap.get(elevator.getTargetNode()));
                jSONObject.put("upper_deck_discharge", nodeMap.get(elevator.getUpperTargetNode()));
            }
            out.println(jSONObject.toString());
        }
        out.println();
        out.println("[elevator-discharge]");
        for (m = 0; m < elevators.size(); ++m) {
            elevator = elevators.get(m);
            int n = nodeMap.get(elevator.getTargetNode());
            double openTime = elevator.getOpenTime();
            double closeDelay = elevator.getCloseDelay();
            double sizeFactor = elevator.getSizeFactor();
            double maxDensity = elevator.getMaxDensity();
            out.printf("%d: %d, %s, %s, %s, %s%n", m, n, WriteMesh.df(openTime), WriteMesh.df(closeDelay), WriteMesh.df(sizeFactor), WriteMesh.df(maxDensity));
        }
        out.println();
        out.println("[elevator-level-data]");
        for (m = 0; m < elevators.size(); ++m) {
            elevator = elevators.get(m);
            List<ElevatorLevel> list = elevator.getLevels();
            Collections.sort(list, new Comparator<ElevatorLevel>(){

                @Override
                public int compare(ElevatorLevel o1, ElevatorLevel o2) {
                    AABox bounds1 = o1.pickupNode.getGeometryBounds();
                    AABox bounds2 = o2.pickupNode.getGeometryBounds();
                    return Double.compare(bounds1.getMinZ(), bounds2.getMinZ());
                }
            });
            if (m != 0) {
                out.println();
            }
            for (ElevatorLevel level : list) {
                double firstAvailable = level.isEnabled() ? level.tFirstAvailable : Double.POSITIVE_INFINITY;
                out.printf("%d, %d, %d, %s, %s, %s, %s, %s%n", m, nodeMap.get(level.pickupNode), level.levelId, WriteMesh.df(level.openTime), WriteMesh.df(level.closeTime), WriteMesh.df(level.getPickupTime()), WriteMesh.df(level.getDischargeTime()), WriteMesh.df(firstAvailable));
            }
        }
        out.println();
        Collection<Set<IElevator>> linkedElevators = em.getLinkedElevators();
        if (!linkedElevators.isEmpty()) {
            out.println("[elevator-links]");
            for (Set set : linkedElevators) {
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    int ix = elevators.indexOf(it.next());
                    assert (ix >= 0);
                    out.print(ix);
                    if (!it.hasNext()) continue;
                    out.print(", ");
                }
                out.println();
            }
            out.println();
        }
        boolean priorityHeaderWritten = false;
        boolean bl = false;
        while (var7_14 < elevators.size()) {
            List<Integer> floorPriority = elevators.get((int)var7_14).getTopPriorityFloors();
            if (!floorPriority.isEmpty()) {
                if (!priorityHeaderWritten) {
                    out.println("[elevator-priority]");
                    priorityHeaderWritten = true;
                }
                out.printf("%d,  ", (int)var7_14);
                for (int n = 0; n < floorPriority.size(); ++n) {
                    if (n != 0) {
                        out.print(", ");
                    }
                    out.print(floorPriority.get(n));
                }
                out.println();
            }
            ++var7_14;
        }
        if (priorityHeaderWritten) {
            out.println();
        }
    }

    public static void writeEdges(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap, Map<Vertex, Integer> vertMap) {
        EdgeData ed;
        out.println("[edges]");
        LinkedHashMap<UEdge, EdgeData> edgeMap = new LinkedHashMap<UEdge, EdgeData>();
        for (WingedEdge e : kb.getMesh().getEdges()) {
            boolean overwrite;
            int i2;
            ed = e.data;
            int i1 = vertMap.get(e.base.n1);
            UEdge uedge = new UEdge(i1, i2 = vertMap.get(e.base.n2).intValue());
            EdgeData edExisting = (EdgeData)edgeMap.get(uedge);
            boolean bl = overwrite = edExisting == null || (ed.type & 1) > 0 || ed.type == 4 && edExisting.type == 0;
            if (!overwrite) continue;
            edgeMap.put(uedge, ed);
        }
        int ix = 0;
        for (Map.Entry entry : edgeMap.entrySet()) {
            UEdge edge = (UEdge)entry.getKey();
            ed = (EdgeData)entry.getValue();
            switch (ed.type) {
                case 4: {
                    out.printf("%d: boundary  %d %d%n", ix, edge.i1, edge.i2);
                    ++ix;
                    break;
                }
                case 1: {
                    int ixNode = nodeMap.get(ed.node);
                    out.printf("%d: door      %d %d %d%n", ix, ixNode, edge.i1, edge.i2);
                    ++ix;
                    break;
                }
                case 3: {
                    int ixNode = nodeMap.get(ed.node);
                    out.printf("%d: exit_door %d %d %d%n", ix, ixNode, edge.i1, edge.i2);
                    ++ix;
                    break;
                }
            }
        }
        out.println();
    }

    private static String strNodeList(Collection<ANode> nodes, Map<ANode, Integer> nodeMap) {
        StringBuilder out = new StringBuilder();
        if (nodes != null) {
            for (ANode n : nodes) {
                int ixNode = nodeMap.get(n);
                out.append(String.format("%d, ", ixNode));
            }
            out.replace(out.length() - 2, out.length(), "");
        } else {
            out.append("any");
        }
        return out.toString();
    }

    public static String escape(Pattern escapePattern, String s) {
        if (s.isEmpty()) {
            return s;
        }
        Matcher matcher = escapePattern.matcher(s);
        if (!matcher.find()) {
            return s;
        }
        int prevEnd = 0;
        StringBuffer result = new StringBuffer("\"");
        do {
            result.append(s, prevEnd, matcher.start());
            String group1 = matcher.group(1);
            if (group1 != null) {
                result.append(group1);
            } else {
                result.append('\\');
                result.append(s, matcher.start(), matcher.end());
            }
            prevEnd = matcher.end();
        } while (matcher.find());
        result.append(s, prevEnd, s.length());
        result.append("\"");
        return result.toString();
    }

    public static String quoteAndEscape(Pattern escapePattern, String s) {
        Matcher matcher = escapePattern.matcher(s);
        int prevEnd = 0;
        StringBuffer result = new StringBuffer("\"");
        while (matcher.find()) {
            result.append(s, prevEnd, matcher.start());
            result.append('\\');
            result.append(s, matcher.start(), matcher.end());
            prevEnd = matcher.end();
        }
        result.append(s, prevEnd, s.length());
        result.append("\"");
        return result.toString();
    }

    public static String escapeName(String name) {
        return WriteMesh.quoteAndEscape(NAME_ESCAPE, name);
    }

    public static void writeBehaviors(PrintWriter out, KB kb, Map<BehaviorSim, Integer> behaviors, Map<OccProfileSim, Integer> profiles, Map<ANode, Integer> nodeMap, Map<IDistributedVal<?>, Integer> distributions, Map<Counter, Integer> counters, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<AssistedEvacTeam, Integer> aeTeams, Map<IFunction1d, Integer> functions, Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap, Map<QMetaQueue, Integer> qMap) {
        BiConsumer<StringBuilder, Collection> formatTags = (action, itags) -> {
            List tags = itags.stream().map(tag -> WriteMesh.escape(GOAL_ESCAPE, tag.name)).collect(Collectors.toList());
            action.append('(');
            action.append(String.join((CharSequence)", ", tags));
            action.append(')');
        };
        out.println("[behaviors]");
        int ix = 0;
        for (BehaviorSim script : behaviors.keySet()) {
            out.printf("%d: ", ix);
            ArrayList<String> strVals = new ArrayList<String>(script.size());
            for (IGoal goal : script) {
                Collection<ANode> nodeTargets;
                String action2;
                IIdleGoal wg;
                CharSequence action3;
                String action4;
                if (goal instanceof ExitGoal) {
                    action4 = String.format("goto exit %s", WriteMesh.strNodeList(((ExitGoal)goal).exits, nodeMap));
                    strVals.add(action4);
                    continue;
                }
                if (goal instanceof PointGoal) {
                    Point3d pt = ((PointGoal)goal).ptSrc.getTriPoint().p;
                    action3 = String.format("goto point (%s, %s, %s) %s", WriteMesh.df(pt.x), WriteMesh.df(pt.y), WriteMesh.df(pt.z), WriteMesh.df(((PointGoal)goal).radius));
                    strVals.add((String)action3);
                    continue;
                }
                if (goal instanceof WaitGoal) {
                    wg = (WaitGoal)goal;
                    action3 = String.format("wait curve %d", distributions.get(((WaitGoal)wg).time));
                    strVals.add((String)action3);
                    continue;
                }
                if (goal instanceof WaitUntilGoal) {
                    WaitUntilGoal wug = (WaitUntilGoal)goal;
                    if (wug.waitSrc instanceof IWaitUntilSrc.SimpleWaitUntilSrc) {
                        IWaitUntilSrc.SimpleWaitUntilSrc simpleSrc = (IWaitUntilSrc.SimpleWaitUntilSrc)wug.waitSrc;
                        String action5 = String.format("wait_until %s %d", simpleSrc.getType(), distributions.get(simpleSrc.d_waitTime));
                        strVals.add(action5);
                        continue;
                    }
                    if (wug.waitSrc instanceof IWaitUntilSrc.CycledWaitUntilSrc) {
                        IWaitUntilSrc.CycledWaitUntilSrc cycleSrc = (IWaitUntilSrc.CycledWaitUntilSrc)wug.waitSrc;
                        String action6 = String.format("wait_until %s %d %d", cycleSrc.getType(), distributions.get(cycleSrc.d_initialTime), distributions.get(cycleSrc.d_intervalTime));
                        strVals.add(action6);
                        continue;
                    }
                    if (!(wug.waitSrc instanceof IWaitUntilSrc.ListedWaitUntilSrc)) continue;
                    IWaitUntilSrc.ListedWaitUntilSrc listSrc = (IWaitUntilSrc.ListedWaitUntilSrc)wug.waitSrc;
                    StringBuilder curveStr = new StringBuilder();
                    for (ICurve goTime : listSrc.d_goTimes) {
                        curveStr.append(String.format("%d ", distributions.get(goTime)));
                    }
                    curveStr.replace(curveStr.length() - 2, curveStr.length(), "");
                    action2 = String.format("wait_until %s %s", listSrc.getType(), curveStr.toString());
                    strVals.add(action2);
                    continue;
                }
                if (goal instanceof RoomGoal) {
                    RoomGoal rg = (RoomGoal)goal;
                    nodeTargets = rg.getRooms();
                    String action7 = String.format("goto room %s", WriteMesh.strNodeList(nodeTargets, nodeMap));
                    strVals.add(action7);
                    continue;
                }
                if (goal instanceof QueueGoal) {
                    QueueGoal queueGoal = (QueueGoal)goal;
                    action3 = String.format("goto queue %d", qMap.get(queueGoal.qSrc));
                    strVals.add((String)action3);
                    continue;
                }
                if (goal instanceof WaitUntilInsideGoal) {
                    wg = (WaitUntilInsideGoal)goal;
                    nodeTargets = ((WaitUntilInsideGoal)wg).getGoals();
                    String action8 = String.format("wait_until_inside %s", WriteMesh.strNodeList(nodeTargets, nodeMap));
                    strVals.add(action8);
                    continue;
                }
                if (goal instanceof ElevatorGoal) {
                    ElevatorGoal eg = (ElevatorGoal)goal;
                    action3 = WriteMesh.writeElevatorGoal(eg, kb.getElevatorModel());
                    strVals.add((String)action3);
                    continue;
                }
                if (goal instanceof ChangeCounterGoal) {
                    String opStr;
                    ChangeCounterGoal ccg = (ChangeCounterGoal)goal;
                    assert (ccg.operator instanceof BigDecimalOp);
                    if (!(ccg.operator instanceof BigDecimalOp)) continue;
                    BigDecimalOp bdo = (BigDecimalOp)ccg.operator;
                    switch (bdo.type) {
                        case ADD: {
                            opStr = "+";
                            break;
                        }
                        case SUBTRACT: {
                            opStr = "-";
                            break;
                        }
                        case DIVIDE: {
                            opStr = "/";
                            break;
                        }
                        case MULTIPLY: {
                            opStr = "*";
                            break;
                        }
                        default: {
                            assert (false);
                            opStr = "+";
                        }
                    }
                    action2 = String.format("change_counter %d %s %s", counters.get(ccg.counter), opStr, bdo.rval.toString());
                    strVals.add(action2);
                    continue;
                }
                if (goal instanceof WaitForCounterGoal) {
                    String opStr;
                    WaitForCounterGoal wfcg = (WaitForCounterGoal)goal;
                    assert (wfcg.condition instanceof ComparePredicate);
                    if (!(wfcg.condition instanceof ComparePredicate)) continue;
                    ComparePredicate cp = (ComparePredicate)wfcg.condition;
                    switch (cp.type) {
                        case EQUAL: {
                            opStr = "==";
                            break;
                        }
                        case GEQUAL: {
                            opStr = ">=";
                            break;
                        }
                        case GREATER: {
                            opStr = ">";
                            break;
                        }
                        case LEQUAL: {
                            opStr = "<=";
                            break;
                        }
                        case LESS: {
                            opStr = "<";
                            break;
                        }
                        default: {
                            assert (false);
                            opStr = "==";
                        }
                    }
                    action2 = String.format("wait_counter %d %s %s", counters.get(wfcg.counter), opStr, ((BigDecimal)cp.rval).toString());
                    strVals.add(action2);
                    continue;
                }
                if (goal instanceof JoinOccGroupGoal) {
                    JoinOccGroupGoal jog = (JoinOccGroupGoal)goal;
                    action3 = "";
                    if (jog.group instanceof OccGroup) {
                        action3 = String.format("join_group %d", jog.group.getID());
                    } else if (jog.group instanceof OccGroupType) {
                        action3 = String.format("join_group_type %d", jog.group.getID());
                    }
                    strVals.add((String)action3);
                    continue;
                }
                if (goal instanceof SetOccPropGoal) {
                    SetOccPropGoal sopg = (SetOccPropGoal)goal;
                    IPropertySet.Prop prop = (IPropertySet.Prop)((Object)sopg.prop);
                    Object jsonVal = WriteMesh.convertProfilePropToJson(prop, sopg.value, shapes, functions, distributions, compRestrictionsMap);
                    assert (jsonVal != null);
                    if (jsonVal == null) continue;
                    JSONObject jsonobj = new JSONObject();
                    jsonobj.put("val", jsonVal);
                    String jsonStr = jsonobj.toJSONString();
                    String action9 = String.format("set_prop %s, %s", prop.key.toString(), jsonStr);
                    strVals.add(action9);
                    continue;
                }
                if (goal instanceof WaitForAssistanceGoal) {
                    WaitForAssistanceGoal wfa = (WaitForAssistanceGoal)goal;
                    action3 = new StringBuilder("get_assistance");
                    Iterator<AssistedEvacTeam> it = wfa.teams.iterator();
                    if (it.hasNext()) {
                        ((StringBuilder)action3).append(' ');
                    }
                    while (it.hasNext()) {
                        AssistedEvacTeam team = it.next();
                        ((StringBuilder)action3).append(aeTeams.get(team));
                        if (!it.hasNext()) continue;
                        ((StringBuilder)action3).append(", ");
                    }
                    strVals.add(((StringBuilder)action3).toString());
                    continue;
                }
                if (goal instanceof DetachGoal) {
                    action4 = "detach_assistants";
                    strVals.add(action4);
                    continue;
                }
                if (goal instanceof AssistOccupantsGoal) {
                    AssistOccupantsGoal aog = (AssistOccupantsGoal)goal;
                    action3 = new StringBuilder("assist ");
                    ((StringBuilder)action3).append(aeTeams.get(aog.team));
                    strVals.add(((StringBuilder)action3).toString());
                    continue;
                }
                if (goal instanceof WaitUntilTaggedGoal && Predicates.alwaysTrue(((WaitUntilTaggedGoal)goal).occFilter) && Predicates.alwaysTrue(((WaitUntilTaggedGoal)goal).occSourceFilter)) {
                    WaitUntilTaggedGoal wutg = (WaitUntilTaggedGoal)goal;
                    action3 = new StringBuilder("wait_until_all_tagged ");
                    formatTags.accept((StringBuilder)action3, theUtil.filter(kb.getTags(), wutg.tagFilter));
                    strVals.add(((StringBuilder)action3).toString());
                    continue;
                }
                if (goal instanceof ChangeTagGoal) {
                    String opStr;
                    ChangeTagGoal ctg = (ChangeTagGoal)goal;
                    switch (ctg.operator) {
                        case TAG: {
                            opStr = "tag";
                            break;
                        }
                        case UNTAG: {
                            opStr = "untag";
                            break;
                        }
                        default: {
                            assert (false);
                            opStr = "";
                        }
                    }
                    StringBuilder action10 = new StringBuilder(opStr);
                    action10.append(' ');
                    formatTags.accept(action10, ctg.tags);
                    strVals.add(action10.toString());
                    continue;
                }
                if (goal instanceof FillRoomGoal) {
                    if (((FillRoomGoal)goal).onlyIfNeeded) {
                        strVals.add("fill_room_if_necessary");
                        continue;
                    }
                    strVals.add("fill_room");
                    continue;
                }
                if (goal instanceof ChangeBehaviorGoal) {
                    ChangeBehaviorGoal changeBehaviorGoal = (ChangeBehaviorGoal)goal;
                    action3 = new StringBuilder("change_behavior ");
                    int urnId = distributions.get(WriteMesh.toIndexUrn(changeBehaviorGoal.getBehaviorUrn(), behaviors::get));
                    ((StringBuilder)action3).append(urnId);
                    strVals.add(((StringBuilder)action3).toString());
                    continue;
                }
                if (goal instanceof ChangeProfileGoal) {
                    ChangeProfileGoal changeProfileGoal = (ChangeProfileGoal)goal;
                    assert (changeProfileGoal.getPropFilter() == ChangeProfileGoal.UI_PROP_FILTER) : "We don't support other property filters yet for ChangeProfileGoal";
                    action3 = new StringBuilder("change_profile ");
                    int urnId = distributions.get(WriteMesh.toIndexUrn(changeProfileGoal.getProfileUrn(), profiles::get));
                    ((StringBuilder)action3).append(urnId);
                    strVals.add(((StringBuilder)action3).toString());
                    continue;
                }
                System.err.println("Simulator Input File Invalid, Unknown goal type: " + goal.getClass().getName());
            }
            JSONObject json = new JSONObject();
            json.put("name", script.name);
            json.put("color", WriteMesh.convertColorToJSON(script.color));
            json.put("script", String.join((CharSequence)"; ", strVals));
            out.println(json.toJSONString());
            ++ix;
        }
        out.println();
    }

    public static void writeTags(PrintWriter out, KB kb) {
        out.println("[tags]");
        int ix = 0;
        for (Tag tag : kb.getTags()) {
            if (tag.predefined) continue;
            out.printf("%d: ", ix++);
            JSONObject json = new JSONObject();
            json.put("name", tag.name);
            json.put("desc", tag.desc);
            json.put("predefined", tag.predefined);
            out.println(json.toJSONString());
        }
        out.println();
    }

    private static String writeElevatorGoal(ElevatorGoal eg, ElevatorModel elevatorModel) {
        StringBuilder sb = new StringBuilder();
        sb.append("goto elevator ");
        if (eg.useAnyElevator()) {
            sb.append("any");
        } else {
            for (int m = 0; m < eg.getElevators().size(); ++m) {
                IElevator el = eg.getElevators().get(m);
                int index = elevatorModel.getElevators().indexOf(el);
                sb.append(index);
                if (m == eg.getElevators().size() - 1) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    private static void writeProfiles(PrintWriter out, Collection<OccProfileSim> profiles, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<IFunction1d, Integer> functions, Map<IDistributedVal<?>, Integer> distributions, Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap) {
        if (profiles.isEmpty()) {
            return;
        }
        out.println("[profiles]");
        int ix = 0;
        for (OccProfileSim occProfile : profiles) {
            out.printf("%d: %s %n", ix, WriteMesh.convertOccProfileToJson(occProfile, shapes, functions, distributions, compRestrictionsMap).toJSONString());
            ++ix;
        }
        out.println();
    }

    public static void writeShapes(PrintWriter out, KB kb, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<IDistributedVal<?>, Integer> distributions) {
        if (shapes.isEmpty()) {
            return;
        }
        out.println("[occshapes]");
        for (Map.Entry<OccProfileSim.IShapeGen, Integer> entry : shapes.entrySet()) {
            OccProfileSim.IShapeGen shape = entry.getKey();
            out.print(entry.getValue());
            out.print(": ");
            out.println(WriteMesh.formatBodyShape(shape, distributions));
        }
        out.println();
    }

    public static void writeQueues(PrintWriter out, Map<QMetaQueue, Integer> qMap, Map<IDistributedVal<?>, Integer> distributions) {
        ArrayList<QBaseQueue> baseQueues = new ArrayList<QBaseQueue>();
        ArrayList<QMetaQueue> metaQueues = new ArrayList<QMetaQueue>();
        for (QMetaQueue queue : qMap.keySet()) {
            if (queue instanceof QBaseQueue) {
                baseQueues.add((QBaseQueue)queue);
                continue;
            }
            metaQueues.add(queue);
        }
        if (!baseQueues.isEmpty()) {
            out.println("[basequeues]");
            for (QBaseQueue base : baseQueues) {
                out.print(qMap.get(base));
                out.print(": ");
                JSONObject jsonQueue = base.toJSON(distributions);
                out.println(jsonQueue.toJSONString());
            }
            out.println();
        }
        if (!metaQueues.isEmpty()) {
            assert (!baseQueues.isEmpty());
            out.println("[metaqueues]");
            for (QMetaQueue meta : metaQueues) {
                out.print(qMap.get(meta));
                out.print(": ");
                JSONObject obj = new JSONObject();
                JSONArray childJSON = new JSONArray();
                for (QMetaQueue child : meta.getChildren()) {
                    childJSON.add(qMap.get(child));
                }
                obj.put("children", childJSON);
                obj.put("sorting", meta.getBalancingType().type);
                out.println(obj.toJSONString());
            }
        }
    }

    private static JSONObject convertOccProfileToJson(OccProfileSim prof, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<IFunction1d, Integer> functions, Map<IDistributedVal<?>, Integer> distributions, Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap) {
        JSONObject json = new JSONObject();
        Map<Object, IPropertySet.Prop<?>> allProps = OccProfileSim.PROP_TYPES_MAP;
        for (Map.Entry<Object, IPropertySet.Prop<?>> entry : allProps.entrySet()) {
            Object jsonProp;
            IPropertySet.Prop<?> p = entry.getValue();
            Object prop = WriteMesh.getProfileProp(prof, p);
            if (prop == DO_NOT_WRITE || (jsonProp = WriteMesh.convertProfilePropToJson(p, prop, shapes, functions, distributions, compRestrictionsMap)) == null) continue;
            json.put(entry.getKey(), jsonProp);
        }
        return json;
    }

    private static <T> Object convertProfilePropToJson(IPropertySet.Prop<T> key, T prop, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<IFunction1d, Integer> functions, Map<IDistributedVal<?>, Integer> distributions, Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap) {
        if (prop instanceof String) {
            return prop;
        }
        if (prop instanceof IFunction1d) {
            return functions.get(prop);
        }
        if (prop instanceof IDistributedVal) {
            return distributions.get(prop);
        }
        if (key instanceof OccProfileSim.UnitDoubleOccProp) {
            return ((UnitDouble)prop).getValue(((OccProfileSim.UnitDoubleOccProp)key).defaultUnit);
        }
        if (prop instanceof Double) {
            return prop;
        }
        if (prop instanceof Boolean) {
            return prop;
        }
        if (prop instanceof OccProfileSim.FromLevelFundamental) {
            return "fromlevelfundamental";
        }
        if (prop instanceof OccProfileSim.ConstProfileFunction) {
            return functions.get(((OccProfileSim.ConstProfileFunction)prop).function);
        }
        if (prop instanceof OccProfileSim.Spacing) {
            OccProfileSim.Spacing sp = (OccProfileSim.Spacing)prop;
            JSONObject jsonProp = new JSONObject();
            jsonProp.put("type", sp.type.toString());
            jsonProp.put("val", WriteMesh.curveToJson(sp.val));
            return jsonProp;
        }
        if (prop instanceof OccProfileSim.IShapeGen) {
            return shapes.get(prop);
        }
        if (key == OccProfileSim.PROP_COLOR) {
            return WriteMesh.convertColorToJSON((Point3f)prop);
        }
        if (key.key.equals(OccProfile.PROP_RESTRICTED_COMPONENTS.key)) {
            return compRestrictionsMap.get(prop);
        }
        if (prop == null && key instanceof OccProfileSim.NullableProp) {
            return "null";
        }
        return null;
    }

    public static Object convertColorToJSON(Color color) {
        if (color == null) {
            return null;
        }
        float[] comps = new float[4];
        color.getComponents(comps);
        JSONArray arr = new JSONArray();
        for (float c : comps) {
            arr.add(Double.valueOf(c));
        }
        return arr;
    }

    public static Object convertColorToJSON(Point3f color) {
        if (color == null) {
            return null;
        }
        JSONArray arr = new JSONArray();
        arr.add(Double.valueOf(color.x));
        arr.add(Double.valueOf(color.y));
        arr.add(Double.valueOf(color.z));
        arr.add(1.0);
        return arr;
    }

    private static String format(VehicleBody.AnimType at) {
        switch (at) {
            case BED: {
                return "bed";
            }
            case WHEELCHAIR: {
                return "wheelchair";
            }
            case NORMAL: {
                return "normal";
            }
        }
        assert (false);
        return "normal";
    }

    private static String format(Tuple3d p) {
        return String.format("%s %s %s", WriteMesh.df(p.x), WriteMesh.df(p.y), WriteMesh.df(p.z));
    }

    private static String formatBodyShape(OccProfileSim.IShapeGen shapeGen, Map<IDistributedVal<?>, Integer> distributions) {
        StringBuilder sb = new StringBuilder();
        if (shapeGen instanceof OccProfileSim.PolyShapeGen) {
            sb.append("name=");
            sb.append(WriteMesh.escapeName(((OccProfileSim.PolyShapeGen)shapeGen).shape.name));
            sb.append(", ");
        }
        sb.append("type=");
        if (shapeGen instanceof OccProfileSim.PolyShapeGen) {
            VehicleBody shape = ((OccProfileSim.PolyShapeGen)shapeGen).shape;
            Point3d[] points = shape.getStaticInnerPoints();
            sb.append(String.format("poly %d", points.length));
            for (Point3d p : points) {
                sb.append(' ');
                sb.append(WriteMesh.format(p));
            }
            sb.append(", height=");
            sb.append(WriteMesh.df(shape.height));
            sb.append(", attachedAgentsPositions=");
            sb.append(WriteMesh.formatAttachedPositions(shape));
            sb.append(", anim=");
            sb.append(WriteMesh.format(shape.animType));
            sb.append(", lateral=");
            sb.append(shape.allowLateral);
            if (shape.avatar != null) {
                sb.append(", model=");
                if (!shape.avatar.isEmpty()) {
                    sb.append(shape.avatar);
                } else {
                    sb.append("<shape>");
                }
            }
            if (!shape.occAvatarOffset.equals(GeomConstants.PNT3D_ORIGIN)) {
                sb.append(", occavataroffset=");
                sb.append(WriteMesh.format(shape.occAvatarOffset));
            }
            if (!shape.origin.equals(GeomConstants.PNT3D_ORIGIN)) {
                sb.append(", origin=");
                sb.append(WriteMesh.format(shape.origin));
            }
        } else if (shapeGen instanceof OccProfileSim.CylShapeGen) {
            OccProfileSim.CylShapeGen cyl = (OccProfileSim.CylShapeGen)shapeGen;
            sb.append("cylinder");
            TriConsumer<String, String, ICurve> writeCurve = (constKey, curveKey, curve) -> {
                if (curve instanceof ConstantCurve) {
                    sb.append(String.format(", %s=%s", constKey, WriteMesh.df(curve.getMin().get(LENGTH_UNIT))));
                } else {
                    sb.append(String.format(", %s=%d", curveKey, distributions.get(curve)));
                }
            };
            writeCurve.accept("diameter", "diameterdist", cyl.shoulderWidth);
            writeCurve.accept("height", "heightdist", cyl.height);
            if (cyl.geomWidth != null) {
                sb.append(", geomdiameter=");
                sb.append(WriteMesh.df(cyl.geomWidth.get(LENGTH_UNIT)));
            }
        } else {
            assert (false);
            sb.append("unknown");
        }
        return sb.toString();
    }

    private static String formatAttachedPositions(VehicleBody vehicleShape) {
        List<Point3d> points = vehicleShape.getStaticAttachedAgentsPositions();
        StringBuilder sb = new StringBuilder();
        sb.append(points.size());
        for (Point3d p : points) {
            sb.append(' ');
            sb.append(WriteMesh.format(p));
        }
        return sb.toString();
    }

    public static void writeFunctions(PrintWriter out, Collection<? extends IFunction1d> functions) {
        if (functions.isEmpty()) {
            return;
        }
        out.println("[functions]");
        int ix = 0;
        for (IFunction1d iFunction1d : functions) {
            out.println(ix + ": " + iFunction1d.toJson().toJSONString());
            ++ix;
        }
        out.println();
    }

    public static void writeDistributions(PrintWriter out, Collection<? extends IDistributedVal<?>> distributions) {
        if (distributions.isEmpty()) {
            return;
        }
        out.println("[distributions]");
        int ix = 0;
        for (IDistributedVal<?> distribution : distributions) {
            JSONObject obj = null;
            if (distribution instanceof ICurve) {
                obj = WriteMesh.curveToJson((ICurve)distribution);
            } else if (distribution instanceof IUrn) {
                obj = WriteMesh.urnToJson((IUrn)distribution);
            } else assert (false);
            out.println(ix + ": " + obj.toJSONString());
            ++ix;
        }
        out.println();
    }

    private static JSONObject curveToJson(ICurve curve) {
        JSONObject obj = new JSONObject();
        if (curve instanceof ConstantCurve) {
            obj.put("type", "cc");
            obj.put("val", curve.getValue(null).toString());
        } else if (curve instanceof LogNormCurve) {
            LogNormCurve c = (LogNormCurve)curve;
            obj.put("type", "logNorm");
            obj.put("mean", c.getAvg().toString());
            obj.put("stDev", c.getStdDev().toString());
            obj.put("min", c.getMin().toString());
            obj.put("max", c.getMax().toString());
        } else if (curve instanceof StdNormCurve) {
            StdNormCurve c = (StdNormCurve)curve;
            obj.put("type", "stdNorm");
            obj.put("mean", c.getAvg().toString());
            obj.put("stDev", c.getStdDev().toString());
            obj.put("min", c.getMin().toString());
            obj.put("max", c.getMax().toString());
        } else if (curve instanceof UniformCurve) {
            UniformCurve c = (UniformCurve)curve;
            obj.put("type", "unif");
            obj.put("min", c.getMin().toString());
            obj.put("max", c.getMax().toString());
        }
        return obj;
    }

    public static void writeOccs(PrintWriter out, KB kb, Map<OccProfileSim, Integer> profiles, Map<BehaviorSim, Integer> behaviors, Map<IFunction1d, Integer> curves, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap) {
        out.println("[occupants]");
        int ix = 0;
        for (Occupant o : kb.getOccs()) {
            double angle;
            int ixGoalProf = behaviors.get(o.behavior);
            Point3d loc = o.loc;
            out.printf("%d: ", ix++);
            JSONObject json = new JSONObject();
            json.put("profile", profiles.get(o.parentProfile));
            Random rnd = new Random();
            WriteMesh.writeOccProp(json, rnd, null, o, "name", o.name, o.name);
            WriteMesh.writeOccProp(json, rnd, null, o, "id", o.id, o.id);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_OCCMODEL, o, (String)OccProfileSim.PROP_OCCMODEL.key, o.avatar == null ? "<null>" : o.avatar, o.avatar);
            WriteMesh.writeOccProp(json, rnd, null, o, "behavior", ixGoalProf, ixGoalProf);
            WriteMesh.writeOccProp(json, rnd, null, o, "loc", WriteMesh.format(loc), loc);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_MAXVEL, o, (String)OccProfileSim.PROP_MAXVEL.key, WriteMesh.ff(o.maxVel), Float.valueOf(o.maxVel), VEL_UNIT);
            IAgentBodyShape profileShape = o.parentProfile.getProperty(OccProfileSim.PROP_SHAPE).generateShape(o, rnd, o.getSeed(OccProfileSim.PROP_SHAPE), kb);
            if (!profileShape.getStaticHash().equals(o.bodyShape.getStaticHash())) {
                OccProfileSim.IShapeGen shapeGen = o.bodyShape.toShapeGen();
                Integer shapeix = shapes.get(shapeGen);
                if (shapeix != null) {
                    json.put(OccProfileSim.PROP_SHAPE.key, shapeix);
                } else if (o.bodyShape instanceof CylinderShape) {
                    CylinderShape cshape = (CylinderShape)o.bodyShape;
                    json.put("OccProfile.DIAMETER", cshape.getOccRadius() * 2.0);
                    json.put("OccProfile.HEIGHT", cshape.getHeight());
                    if (cshape.getGeomRadius() != cshape.getOccRadius()) {
                        json.put("OccProfile.GEOM_DIAMETER", cshape.getGeomRadius() * 2.0);
                    }
                } else assert (false);
            }
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_ACCEL_TIME, o, (String)OccProfileSim.PROP_ACCEL_TIME.key, WriteMesh.df(1.0 / (double)o.accelFactor), 1.0 / (double)o.accelFactor, TIME_UNIT);
            if (!WriteMesh.sameColor(o)) {
                Color3f colorf = new Color3f(theUtil.toCCf(o.visColor.x), theUtil.toCCf(o.visColor.y), theUtil.toCCf(o.visColor.z));
                WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_COLOR, o, (String)OccProfileSim.PROP_COLOR.key, colorf.toString(), colorf);
            }
            WriteMesh.writeOccProp(json, rnd, null, o, (String)OccProfileSim.PROP_REAC_TIME.key, WriteMesh.ff(o.reacTime), Float.valueOf(o.reacTime), TIME_UNIT);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_PRIORITY_LEVEL, o, (String)OccProfileSim.PROP_PRIORITY_LEVEL.key, WriteMesh.df(o.priority), o.priority);
            WriteMesh.writeOccProp(json, rnd, null, o, "rseed", o.rseed, o.rseed);
            WriteMesh.writeOccProp(json, rnd, null, o, "orientSeed", o.orientSeed, o.orientSeed);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_MIN_SQUEEZE_FACTOR_CONST, o, (String)OccProfileSim.PROP_MIN_SQUEEZE_FACTOR_CONST.key, WriteMesh.ff(o.minSqueezeFactor), (double)o.minSqueezeFactor != 1.0 ? Float.valueOf(o.minSqueezeFactor) : null, Unit.ONE);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_PERSIST_TIME, o, (String)OccProfileSim.PROP_PERSIST_TIME.key, WriteMesh.ff(o.persistTime), Float.valueOf(o.persistTime), TIME_UNIT);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_COLLISION_RESPONSE_TIME, o, (String)OccProfileSim.PROP_COLLISION_RESPONSE_TIME.key, WriteMesh.ff(o.collisionResponseTime), Float.valueOf(o.collisionResponseTime), TIME_UNIT);
            WriteMesh.writeComfortDist(json, rnd, o);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_SOCIAL_DIST, o, (String)OccProfileSim.PROP_SOCIAL_DIST.key, WriteMesh.ff(o.socialDist), Float.valueOf(o.socialDist), LENGTH_UNIT);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_SLOW_FACTOR, o, (String)OccProfileSim.PROP_SLOW_FACTOR.key, WriteMesh.ff(o.slowFactor), Float.valueOf(o.slowFactor), Unit.ONE);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_ASSIST, o, (String)OccProfileSim.PROP_ASSIST.key, "" + o.reqAssistedBy, o.reqAssistedBy);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_REQUIRES_ASSISTANCE, o, (String)OccProfileSim.PROP_REQUIRES_ASSISTANCE.key, "" + o.requiresAssistance, o.requiresAssistance);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_OBEY_ONEWAY_DOORS, o, (String)OccProfileSim.PROP_OBEY_ONEWAY_DOORS.key, "" + o.obeyOnewayDoors, o.obeyOnewayDoors);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_ESCALATOR_PREF, o, (String)OccProfileSim.PROP_ESCALATOR_PREF.key, "" + (Object)((Object)o.movingTerrainPref), (Object)o.movingTerrainPref);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_LOCAL_QUEUE_TIME_FACTOR, o, (String)OccProfileSim.PROP_LOCAL_QUEUE_TIME_FACTOR.key, WriteMesh.df(o.localQueueTimeFactor), o.localQueueTimeFactor, Unit.ONE);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_LOCAL_TRAVEL_TIME_FACTOR, o, (String)OccProfileSim.PROP_LOCAL_TRAVEL_TIME_FACTOR.key, WriteMesh.df(o.localTravelTimeFactor), o.localTravelTimeFactor, Unit.ONE);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_TAIL_TIME_FACTOR, o, (String)OccProfileSim.PROP_TAIL_TIME_FACTOR.key, WriteMesh.df(o.tailTimeFactor), o.tailTimeFactor, Unit.ONE);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_CURR_DOOR_PREF, o, (String)OccProfileSim.PROP_CURR_DOOR_PREF.key, WriteMesh.df(o.currDoorFactor), o.currDoorFactor, Unit.ONE);
            WriteMesh.writeOccProp(json, rnd, null, o, (String)OccProfileSim.PROP_CURRENT_ROOM_DIST_PENALTY.key, WriteMesh.df(o.distTravelledFactor), o.distTravelledFactor, LENGTH_UNIT);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_BOUNDARY_LAYER, o, (String)OccProfileSim.PROP_BOUNDARY_LAYER.key, WriteMesh.ff(o.boundaryLayer), Float.valueOf(o.boundaryLayer), LENGTH_UNIT);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_PRINT_EXTRA_OUTPUT, o, (String)OccProfileSim.PROP_PRINT_EXTRA_OUTPUT.key, o.outputTimeHistory, o.outputTimeHistory, Unit.ONE);
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_FUNDAMENTAL).equals(o.fundamental)) {
                WriteMesh.writeOccProp(json, rnd, null, o, (String)OccProfileSim.PROP_FUNDAMENTAL.key, curves.get(o.fundamental), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_STAIR_SPEED_UP).equals(o.stairSpeed.upSpeed)) {
                WriteMesh.writeOccProp(json, rnd, null, o, (String)OccProfileSim.PROP_STAIR_SPEED_UP.key, curves.get(o.stairSpeed.upSpeed), null);
            }
            if (!((IFunction1d)o.parentProfile.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_UP).apply(o.parentProfile)).equals(o.stairSpeed.upFundamental)) {
                WriteMesh.writeOccProp(json, rnd, null, o, (String)OccProfileSim.PROP_STAIR_FUNDAMENTAL_UP.key, curves.get(o.stairSpeed.upFundamental), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_STAIR_SPEED_DOWN).equals(o.stairSpeed.downSpeed)) {
                WriteMesh.writeOccProp(json, rnd, null, o, (String)OccProfileSim.PROP_STAIR_SPEED_DOWN.key, curves.get(o.stairSpeed.downSpeed), null);
            }
            if (!((IFunction1d)o.parentProfile.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_DOWN).apply(o.parentProfile)).equals(o.stairSpeed.downFundamental)) {
                WriteMesh.writeOccProp(json, rnd, null, o, (String)OccProfileSim.PROP_STAIR_FUNDAMENTAL_DOWN.key, curves.get(o.stairSpeed.downFundamental), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_RAMP_SPEED_UP).equals(o.rampSpeed.upSpeed)) {
                WriteMesh.writeOccProp(json, rnd, null, o, (String)OccProfileSim.PROP_RAMP_SPEED_UP.key, curves.get(o.rampSpeed.upSpeed), null);
            }
            if (!((IFunction1d)o.parentProfile.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_UP).apply(o.parentProfile)).equals(o.rampSpeed.upFundamental)) {
                WriteMesh.writeOccProp(json, rnd, null, o, (String)OccProfileSim.PROP_RAMP_FUNDAMENTAL_UP.key, curves.get(o.rampSpeed.upFundamental), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_RAMP_SPEED_DOWN).equals(o.rampSpeed.downSpeed)) {
                WriteMesh.writeOccProp(json, rnd, null, o, (String)OccProfileSim.PROP_RAMP_SPEED_DOWN.key, curves.get(o.rampSpeed.downSpeed), null);
            }
            if (!((IFunction1d)o.parentProfile.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_DOWN).apply(o.parentProfile)).equals(o.rampSpeed.downFundamental)) {
                WriteMesh.writeOccProp(json, rnd, null, o, (String)OccProfileSim.PROP_RAMP_FUNDAMENTAL_DOWN.key, curves.get(o.rampSpeed.downFundamental), null);
            }
            if ((angle = Trig.angle(new Vector3d(1.0, 0.0, 0.0), o.orient)) < 0.0) {
                angle += Math.PI * 2;
            }
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_INIT_ORIENT, o, (String)OccProfileSim.PROP_INIT_ORIENT.key, WriteMesh.format(o.orient), angle, SI.RADIAN);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_RESTRICTED_COMPONENTS, o, (String)OccProfileSim.PROP_RESTRICTED_COMPONENTS.key, compRestrictionsMap.get(o.compRestrictions), o.compRestrictions, null);
            WriteMesh.writeOccProp(json, rnd, OccProfileSim.PROP_ELEVATOR_WAIT_TIME, o, (String)OccProfileSim.PROP_ELEVATOR_WAIT_TIME.key, WriteMesh.df(o.elevatorWaitTime.maxWaitTime), o.elevatorWaitTime.maxWaitTime, SI.SECOND);
            out.println(json.toJSONString());
        }
        out.println();
    }

    private static boolean sameColor(Occupant o) {
        Point3f c = o.parentProfile.getProperty(OccProfileSim.PROP_COLOR);
        Color3b profCol = new Color3b(theUtil.toCCb(c.x), theUtil.toCCb(c.y), theUtil.toCCb(c.z));
        Color3b occCol = o.visColor;
        return profCol.equals(occCol);
    }

    private static void writeOccProp(JSONObject json, Random rnd, OccProfileSim.Prop<?> prop, Occupant o, String key, Object formatedValue, Object compareValue) {
        WriteMesh.writeOccProp(json, rnd, prop, o, key, formatedValue, compareValue, null);
    }

    private static void writeComfortDist(JSONObject json, Random rnd, Occupant o) {
        UnitDouble parentComfortDist = o.parentProfile.getComfortDistance(rnd, o.rseed, new UnitDouble(o.bodyShape.getOccRadius(), SI.METER));
        if ((float)parentComfortDist.get(SI.METER) == o.comfortDist) {
            return;
        }
        json.put("comfortDist", WriteMesh.ff(o.comfortDist));
    }

    private static void writeOccProp(JSONObject json, Random rnd, OccProfileSim.Prop prop, Occupant o, String key, Object formatedValue, Object compareValue, Unit unit) {
        OccProfileSim parentProfile = o.parentProfile;
        boolean write = false;
        if (prop == null) {
            write = true;
        } else {
            Object profileProp = prop.isDistributed() ? parentProfile.getDistVal(prop, rnd, o.getSeed(prop)) : parentProfile.getProperty(prop);
            if (profileProp instanceof OccProfileSim.Spacing) {
                profileProp = parentProfile.getSpacingVal(rnd, o.rseed);
            }
            if (profileProp instanceof UnitDouble) {
                profileProp = unit != null ? ((UnitDouble)profileProp).getValue(unit) : ((UnitDouble)profileProp).getValueNoUnit();
            }
            if (profileProp == null && compareValue == null) {
                write = false;
            } else if (profileProp == null && compareValue != null || profileProp != null && compareValue == null) {
                write = true;
            } else if (profileProp == null) {
                write = true;
            } else if (profileProp instanceof Double && compareValue instanceof Double) {
                write = !theUtil.eq((Double)profileProp, (Double)compareValue, 1.0E-6);
            } else if (profileProp instanceof VehicleBody && compareValue instanceof VehicleBody) {
                write = !((VehicleBody)profileProp).equals((VehicleBody)compareValue);
            } else if (!profileProp.toString().equals(compareValue.toString())) {
                write = true;
            }
        }
        if (write) {
            json.put(key, formatedValue);
        }
    }

    private static String writeAETeamName(String assistedEvacuationTeamName) {
        if (assistedEvacuationTeamName == null) {
            return "NA";
        }
        return assistedEvacuationTeamName.replace(" ", "_");
    }

    private static Map<AssistedEvacTeam, Integer> getAETeams(KB kb) {
        LinkedIdentityHashMap<AssistedEvacTeam, Integer> teams = new LinkedIdentityHashMap<AssistedEvacTeam, Integer>();
        Consumer<AssistedEvacTeam> add = team -> teams.putIfAbsent((AssistedEvacTeam)team, teams.size());
        Consumer<Collection> addGoals = goals -> {
            for (IGoal goal : goals) {
                if (goal instanceof WaitForAssistanceGoal) {
                    for (AssistedEvacTeam team : ((WaitForAssistanceGoal)goal).teams) {
                        add.accept(team);
                    }
                    continue;
                }
                if (!(goal instanceof AssistOccupantsGoal)) continue;
                add.accept(((AssistOccupantsGoal)goal).team);
            }
        };
        for (OccSource occSource : kb.getOccSources()) {
            for (BehaviorSim behavior : occSource.getBehaviors()) {
                addGoals.accept(behavior.deepFlatten());
            }
        }
        for (Occupant occ : kb.getOccs()) {
            addGoals.accept(occ.behavior.deepFlatten());
        }
        return teams;
    }

    public static void writeAssistedEvacTeams(PrintWriter out, Map<AssistedEvacTeam, Integer> validTeams) {
        if (validTeams.isEmpty()) {
            return;
        }
        out.println("[assisted-evac-teams]");
        for (Map.Entry<AssistedEvacTeam, Integer> entry : validTeams.entrySet()) {
            AssistedEvacTeam aeData = entry.getKey();
            out.printf("%d: goals=%s,name=%s%n", entry.getValue(), WriteMesh.writeAEOccIDs(aeData), WriteMesh.writeAETeamName(aeData.teamName));
        }
        out.println();
    }

    private static void writeOccSources(PrintWriter out, KB kb, Map<OccProfileSim, Integer> profiles, Map<BehaviorSim, Integer> behaviors, Map<IFunction1d, Integer> functions, Map<ANode, Integer> nodeMap, Map<IDistributedVal<?>, Integer> distributions) {
        if (kb.getOccSources().isEmpty()) {
            return;
        }
        out.println("[occupant-sources]");
        int ix = 0;
        for (OccSource occSource : kb.getOccSources()) {
            JSONObject json = new JSONObject();
            json.put("name", occSource.getName());
            json.put("flowrate", functions.get(occSource.getFlowrate()));
            json.put("profiles", distributions.get(WriteMesh.toIndexUrn(occSource.getProfileUrn(), profiles::get)));
            json.put("behaviors", distributions.get(WriteMesh.toIndexUrn(occSource.getBehaviorUrn(), behaviors::get)));
            JSONObject aaboxJson = new JSONObject();
            aaboxJson.put("min", occSource.getBounds().getMin().toString());
            aaboxJson.put("max", occSource.getBounds().getMax().toString());
            json.put("bounds", aaboxJson);
            json.put("enforceFlowrate", occSource.isEnforceFlowrate());
            if (occSource.getComponent() != null) {
                json.put("component", nodeMap.get(occSource.getComponent()));
            }
            json.put("groupTemplates", distributions.get(WriteMesh.toIndexUrn(occSource.getGroupUrn(), type -> type.getID())));
            out.printf("%d: %s %n", ix++, json.toJSONString());
        }
        out.println();
    }

    private static void writeOccGroups(PrintWriter out, KB kb, Map<OccProfileSim, Integer> profiles, Map<BehaviorSim, Integer> behaviors, Map<IDistributedVal<?>, Integer> distributions) {
        JSONObject json2;
        Integer ix;
        BiConsumer<JSONObject, IOccGroup> addCommonGroupData = (json, g) -> {
            json.put("maxDistance", g.getMaxDistance());
            json.put("slowdownTime", g.getSlowdownTime());
            json.put("requiresLeader", g.requiresLeader());
            json.put("color", WriteMesh.convertColorToJSON(g.getColor()));
            json.put("respectSocialDist", g.respectSocialDist());
        };
        BiConsumer<JSONObject, OccGroup> addOccGroupData = (json, g) -> {
            json.put("name", g.groupName);
            if (g.templateColor != null) {
                json.put("templateColor", WriteMesh.convertColorToJSON(g.templateColor));
            }
            if (g.getInitOccs() != null) {
                JSONArray jsonArray = new JSONArray();
                for (Occupant occ : g.getInitOccs()) {
                    jsonArray.add(occ.id);
                }
                json.put("members", jsonArray);
            }
            if (g.getInitLeader() != null) {
                json.put("leader", g.getInitLeader().id);
            }
        };
        BiConsumer<JSONObject, OccGroupType> addGroupTypeData = (json, g) -> {
            json.put("name", g.groupTypeName);
            if (g.allowSmallerGroups) {
                json.put("minNumberOfMembers", distributions.get(g.minNumberOfMembers));
            }
            json.put("prefNumberOfMembers", distributions.get(g.prefNumberOfMembers));
            json.put("allowSmallerGroups", g.allowSmallerGroups);
            boolean exactDistCalc = g.useExactDistCalc;
            json.put("exactDistanceCalculation", exactDistCalc);
            if (!exactDistCalc) {
                json.put("heightMultiplier", g.heightMultiplier);
            }
            boolean specifyProfiles = g.profileMap != null;
            json.put("specifyProfiles", specifyProfiles);
            OccProfileSim leaderProfile = g.leaderProfile;
            if (leaderProfile != null) {
                assert (profiles.containsKey(leaderProfile));
                json.put("leaderProfile", profiles.get(leaderProfile));
            }
            json.put("restrictRoom", g.restrictRoom);
            json.put("ungrouped", g.isNoGroupType);
            if (specifyProfiles) {
                JSONArray jsonArray = new JSONArray();
                for (OccProfileSim prof : g.profileMap.keySet()) {
                    if (!profiles.containsKey(prof)) continue;
                    int profID = (Integer)profiles.get(prof);
                    ICurve prefNumOfMembers = g.profileMap.get((Object)prof).prefNumberOfMembers;
                    if (prefNumOfMembers instanceof ConstantCurve && prefNumOfMembers.getAvg().get(Unit.ONE) == 0.0) continue;
                    int prefCurveID = (Integer)distributions.get(prefNumOfMembers);
                    boolean allowSmaller = g.profileMap.get((Object)prof).allowSmallerGroups;
                    Integer minCurveID = allowSmaller ? (Integer)distributions.get(g.profileMap.get((Object)prof).minNumberOfMembers) : null;
                    JSONObject obj = new JSONObject();
                    obj.put("profile", profID);
                    obj.put("prefNumberOfMembers", prefCurveID);
                    obj.put("allowSmallerGroups", allowSmaller);
                    if (minCurveID != null) {
                        obj.put("minNumberOfMembers", minCurveID);
                    }
                    jsonArray.add(obj);
                }
                json.put("profiles", jsonArray);
            }
        };
        if (!kb.getOccupantGroups().isEmpty()) {
            out.println("[groups]");
            ix = 0;
            for (OccGroup occGroup : kb.getOccupantGroups()) {
                json2 = new JSONObject();
                addCommonGroupData.accept(json2, occGroup);
                addOccGroupData.accept(json2, occGroup);
                out.printf("%d: %s %n", ix, json2.toJSONString());
                ix = ix + 1;
            }
            out.println();
        }
        if (!kb.getOccupantGroupTypes().isEmpty()) {
            out.println("[group-templates]");
            ix = 0;
            for (OccGroupType occGroupType : kb.getOccupantGroupTypes()) {
                json2 = new JSONObject();
                addCommonGroupData.accept(json2, occGroupType);
                addGroupTypeData.accept(json2, occGroupType);
                out.printf("%d: %s %n", ix, json2.toJSONString());
                ix = ix + 1;
            }
            out.println();
        }
    }

    private static void writeCounters(PrintWriter out, Map<Counter, Integer> counters) {
        if (counters.isEmpty()) {
            return;
        }
        out.println("[counters]");
        for (Map.Entry<Counter, Integer> entry : counters.entrySet()) {
            out.printf("%d: %s%n", entry.getValue(), entry.getKey().value.toString());
        }
        out.println();
    }

    private static String writeAEOccIDs(AssistedEvacTeam aeData) {
        StringBuilder sb = new StringBuilder();
        if (aeData.clientOrder.isEmpty()) {
            sb.append("NA");
            return sb.toString();
        }
        int[] ids = new int[aeData.clientOrder.size()];
        for (Map.Entry<Integer, Integer> entry : aeData.clientOrder.entrySet()) {
            ids[entry.getValue().intValue()] = entry.getKey();
        }
        for (int i = 0; i < ids.length; ++i) {
            sb.append(ids[i]);
            if (i == ids.length - 1) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    private static Map<OccProfileSim.CompRestrictions, Integer> getCompRestrictions(KB kb) {
        LinkedIdentityHashMap<OccProfileSim.CompRestrictions, Integer> map = new LinkedIdentityHashMap<OccProfileSim.CompRestrictions, Integer>();
        IdentityHashSet processedBehaviors = new IdentityHashSet();
        Consumer<BehaviorSim> processBehavior = b -> {
            if (processedBehaviors.add(b)) {
                return;
            }
            Collection<ChangeProfileGoal> changeProfileGoals = b.deepFlatten(ChangeProfileGoal.class);
            for (ChangeProfileGoal changeProfileGoal : changeProfileGoals) {
                changeProfileGoal.getAllTargetProfiles().forEach(prof -> map.putIfAbsent(prof.getProperty(OccProfileSim.PROP_RESTRICTED_COMPONENTS), map.size()));
            }
        };
        for (Occupant occ : kb.getOccs()) {
            map.putIfAbsent(occ.compRestrictions, map.size());
            processBehavior.accept(occ.behavior);
        }
        for (OccSource source : kb.getOccSources()) {
            source.getProfiles().forEach(prof -> map.putIfAbsent(prof.getProperty(OccProfileSim.PROP_RESTRICTED_COMPONENTS), map.size()));
            source.getBehaviors().forEach(processBehavior);
        }
        return map;
    }

    private static void writeCompRestrictions(PrintWriter out, Map<OccProfileSim.CompRestrictions, Integer> map, Map<ANode, Integer> nodeMap) {
        if (!map.isEmpty()) {
            out.println("[component-restrictions]");
            for (OccProfileSim.CompRestrictions compRestrictions : map.keySet()) {
                JSONObject json = new JSONObject();
                JSONArray nodeIDs = new JSONArray();
                for (ANode node : compRestrictions.nodes) {
                    nodeIDs.add(nodeMap.get(node));
                }
                json.put("components", nodeIDs);
                json.put("action", compRestrictions.reject ? "reject" : "accept");
                json.put("elevators-from-behavior", compRestrictions.elevatorsFromBehavior);
                out.printf("%d: %s %n", map.get(compRestrictions), json.toJSONString());
            }
            out.println();
        }
    }

    private static String getTypeStr(Tri.Terrain terrain) {
        if (terrain.isOpen()) {
            return "open";
        }
        if (terrain.isStair()) {
            return "stair";
        }
        if (terrain.isRamp()) {
            return "ramp";
        }
        assert (false);
        return null;
    }

    public static <T> IUrn<Integer> toIndexUrn(IUrn<T> urn, Function<T, Integer> getIndex) {
        Map<T, Double> weights = urn.getWeights();
        LinkedIdentityHashMap urnMap = new LinkedIdentityHashMap();
        weights.forEach((k, v) -> urnMap.put(getIndex.apply(k), v));
        return UrnUtil.newUrn(urnMap);
    }

    public static <T> JSONObject urnToJson(IUrn<T> urn) {
        T key;
        Map<T, Double> weights = urn.getWeights();
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<T, Double> entry : weights.entrySet()) {
            T obj = entry.getKey();
            HashMap<T, Double> idToWeight = new HashMap<T, Double>();
            idToWeight.put(obj, entry.getValue());
            JSONObject jsonObj = new JSONObject(idToWeight);
            jsonArray.add(jsonObj);
        }
        String type = weights.isEmpty() ? "" : ((key = weights.keySet().iterator().next()) instanceof Integer ? "int" : (key instanceof Boolean ? "bool" : (key instanceof UnitDouble ? "ud" : "string")));
        JSONObject json = new JSONObject();
        json.put("urn", jsonArray);
        json.put("type", type);
        return json;
    }

    private static class UEdge {
        public final int i1;
        public final int i2;

        public UEdge(int i1, int i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        public int hashCode() {
            return this.i1 + this.i2;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            UEdge uedge = (UEdge)obj;
            return uedge.i1 == this.i1 && uedge.i2 == this.i2;
        }
    }
}

