/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.SimError;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class SelectInvalidObjs
extends AMerlinOp
implements IEventObserver {
    public static final UIHook CRITICAL_HOOK = new UIHook(new SelectInvalidObjs(SimError.Level.CRITICAL), Intl.intl("Select Errors"));
    public static final UIHook MODERATE_HOOK = new UIHook(new SelectInvalidObjs(SimError.Level.MODERATE), Intl.intl("Select Warnings"));
    private final SimError.Level d_level;

    public SelectInvalidObjs(SimError.Level level) {
        this.d_level = level;
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    private static boolean isValid(MerlinData md, Object obj, SimError.Level level) {
        if (!(obj instanceof IMerlinObj)) {
            return true;
        }
        EntryPoint<IMerlinObj> ep = EntryPointFactory.get((IMerlinObj)obj);
        Collection<SimError> errors = ep.tvEntryPoint.getErrors(md, (IMerlinObj)obj);
        if (level == null) {
            return errors.isEmpty();
        }
        for (SimError error : errors) {
            if (error.level != level) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        if (md.selection.isEmpty()) {
            this.setEnabled(!SelectInvalidObjs.isValid(md, md, this.d_level));
        } else {
            boolean valid = true;
            Set sel = md.selection.getSelected(Object.class);
            for (Object selObj : sel) {
                if (SelectInvalidObjs.isValid(md, selObj, this.d_level)) continue;
                valid = false;
                break;
            }
            this.setEnabled(!valid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        ArrayList<Object> invalidObjs = new ArrayList<Object>();
        md.beginRead();
        try {
            Set sel = md.selection.getSelected(Object.class);
            if (sel.isEmpty()) {
                SelectInvalidObjs.collectInvalidLeaves(md, Arrays.asList(md), invalidObjs, this.d_level);
            } else {
                SelectInvalidObjs.collectInvalidLeaves(md, sel, invalidObjs, this.d_level);
            }
        }
        finally {
            md.endRead();
        }
        if (!invalidObjs.isEmpty()) {
            md.beginWrite();
            try {
                md.selection.set(invalidObjs);
            }
            finally {
                md.endWrite();
            }
        }
    }

    private static void collectInvalidLeaves(MerlinData md, Collection<?> objs, List<Object> invalidObjs, SimError.Level level) {
        for (Object obj : objs) {
            Collection<SimError> errors = EntryPointFactory.get(obj).tvEntryPoint.getErrors(md, obj);
            for (SimError error : errors) {
                if (level != null && error.level != level) continue;
                invalidObjs.addAll(error.causeObjs);
            }
        }
    }
}

