/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import inferno.io.SnapshotReader;
import inferno.sim.Engine;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.RunInferno;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.gui.RunSimDlg;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.Global;
import thunderheadeng.util.theUtil;

public class ResumeInferno
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new ResumeInferno(), Intl.intl("Res&ume Simulation...,-,Resume Simulation"), null);
    private static final Logger LOGGER = Logger.getLogger(ResumeInferno.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        String filename;
        md.beginRead();
        try {
            filename = md.filename;
        }
        finally {
            md.endRead();
        }
        if (filename == null) {
            JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("An existing model must first be loaded."), Intl.intl("Model Not Loaded"), 0);
            return;
        }
        List<SnapshotReader.SnapshotInfo> snapshots = Collections.emptyList();
        final File snapshotFile = new File(FilenameManager.splitFilename(filename)[0] + ".snapshot");
        if (snapshotFile.exists()) {
            snapshots = SnapshotReader.getSnapshots(snapshotFile);
        }
        if (snapshots.isEmpty()) {
            JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("There are no snapshots for the current model."), Intl.intl("No Snapshots"), 2);
            return;
        }
        JFrame parent = app.getActiveFrame();
        SnapshotDlg ssdlg = new SnapshotDlg((Window)parent, snapshots);
        if (ssdlg.doModal() != 1) {
            return;
        }
        final SnapshotReader.SnapshotInfo snapshot = ssdlg.getSnapshot();
        final RunSimDlg dlg = new RunSimDlg(parent);
        dlg.doModeless();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Engine inferno;
                dlg.beginWaitCursor();
                dlg.setTitleFromPath(filename);
                try {
                    dlg.printToLog(Intl.intl("Opening simulation snapshot..."));
                    inferno = SnapshotReader.openSnapshot(snapshotFile, snapshot, true);
                }
                catch (IOException e) {
                    String msg = String.format(Intl.intl("Error: Could not open snapshot:%n%s"), e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getClass().getSimpleName());
                    dlg.printToLog(msg);
                    TeciLogging.log(LOGGER, e);
                    return;
                }
                finally {
                    dlg.endWaitCursor();
                }
                RunInferno.run(dlg, filename, snapshotFile.getParentFile(), inferno, new RunSimDlg.DlgListener[0]);
            }
        }).start();
    }

    private static class SnapshotDlg
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private final JList<SnapshotReader.SnapshotInfo> d_list;

        public SnapshotDlg(Window owner, List<SnapshotReader.SnapshotInfo> snapshots) {
            super(owner, Intl.intl("Choose Snapshot"), 9);
            this.d_list = new JList<SnapshotReader.SnapshotInfo>(theUtil.toArray(snapshots, SnapshotReader.SnapshotInfo.class));
            this.d_list.setSelectionMode(0);
            this.d_list.setCellRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    String text = String.format("%s", Global.format(((SnapshotReader.SnapshotInfo)value).t, SI.SECOND));
                    this.setText(text);
                    return c;
                }
            });
            this.d_list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        this.getButton(1).doClick();
                    }
                }
            });
            JScrollPane listsp = new JScrollPane(this.d_list);
            if (!snapshots.isEmpty()) {
                int lastix = snapshots.size() - 1;
                this.d_list.setSelectedIndex(lastix);
                this.d_list.scrollRectToVisible(this.d_list.getCellBounds(lastix, lastix));
            }
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(Intl.intl("Choose the time to resume:"), 0);
            gb.addFilledRow(listsp);
            gb.finalizeRows();
            this.setResizable(true);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            int selIndex = this.d_list.getSelectedIndex();
            if (selIndex < 0) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, Intl.intl("You must choose a time from the list."), Intl.intl("Choose a Time"), 0);
                }
                return false;
            }
            if (selIndex < this.d_list.getModel().getSize() - 1 && showWarn) {
                SnapshotReader.SnapshotInfo snapshot = this.getSnapshot();
                int option = JOptionPane.showConfirmDialog(this, String.format(Intl.intl("Snapshots after t=%s will be overwritten.\nAre you sure you want to resume here?"), Global.format(snapshot.t, SI.SECOND)), Intl.intl("Resume Snapshot?"), 0);
                if (option != 0) {
                    return false;
                }
            }
            return true;
        }

        public SnapshotReader.SnapshotInfo getSnapshot() {
            return this.d_list.getSelectedValue();
        }
    }
}

