/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.Save;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.RecentFilesEntry;
import merlin.gui.guiUtil;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.gui.ModelBackup;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.TaskProgress;

public class Open
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Open16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Open(), Intl.intl("&Open...,O,Open File,Open a model file"), ICON);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        try {
            app.beginWaitCursor();
            if (!app.promptSaveIfModified()) {
                return;
            }
            File f = guiUtil.getOpenFile(app, md, MerlinPrefs.OPEN_DIR_PREF, "pth", Intl.intl("Pathfinder Model"));
            if (f == null) {
                return;
            }
            Open.open(app, md, f.getAbsolutePath());
        }
        finally {
            app.endWaitCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean open(MerlinApp app, MerlinData md, String fn) {
        app.setWorkingDir(fn);
        app.beginWaitCursor();
        try {
            MerlinIO io = new MerlinIO();
            MerlinData mdLoad = Open.openModel(app.getActiveFrame(), io, md.backup, fn);
            if (mdLoad == null) {
                boolean bl = false;
                return bl;
            }
            boolean isBackup = md.backup.isReservedPath(mdLoad.filename);
            Save.setForceSavePrompt(isBackup);
            mdLoad.modified |= isBackup;
            md.beginWrite();
            try {
                Undo.insertEntry_breakChain(md);
                md.loadFrom(mdLoad);
                md.filename = mdLoad.filename;
                if (!isBackup) {
                    md.getEvents().added((Object)new RecentFilesEntry(md.filename));
                } else {
                    md.getEvents().changed(md, MerlinData.MODEL_BACKUP_RESTORED);
                }
                System.gc();
            }
            finally {
                md.endWrite();
            }
            Open.printImportedGeomFaceCount(md);
            boolean bl = true;
            return bl;
        }
        finally {
            app.endWaitCursor();
        }
    }

    private static void printImportedGeomFaceCount(MerlinData md) {
        final int[] n = new int[]{0};
        md.beginRead();
        AABox bounds = md.geomLocation.getLocator().getBounds();
        Box3d finder = new Box3d(bounds);
        md.geomLocation.getLocator().find(finder, (IResult<? super IDisplayableGeomSrc>)new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                n[0] = n[0] + obj.getDisplayGeom(null).node.getNumPrims(1);
            }
        }, 0);
        md.endRead();
        System.out.printf("Imported geometry contains %s FACE primitives.%n", n[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MerlinData openModel(Component parent, MerlinIO io, ModelBackup backup, String filename) {
        try {
            Serializable dlg;
            Consumer<TaskProgress> showSkippableProgress = progress -> {
                guiProgressMonitor monitor = new guiProgressMonitor(MerlinApp.getApp().getMainFrame(), Intl.intl("Opening model..."), true, (TaskProgress)progress);
                monitor.setCancelText(Intl.intl("Skip"));
                monitor.setPopupDelay(2000);
                monitor.begin();
            };
            MerlinOIS.DecisionMaker decisions = new MerlinOIS.DecisionMaker();
            decisions.pre104UseNewDefaults = () -> {
                String msg = Intl.intl("Some occupant profile defaults have changed. Would you like to\nuse the new defaults where old defaults were used previously?\nNOTE: The new defaults can be loaded later in the Advanced tab\nof the profiles dialog.");
                int option = JOptionPane.showConfirmDialog(parent, msg, Intl.intl("Use New Defaults?"), 1);
                if (option == 0) {
                    return true;
                }
                if (option == 1) {
                    return false;
                }
                throw new CancellationException();
            };
            decisions.pre139ConvertToSocialDistance = () -> {
                String msg = Intl.intl("This model has forced separation enabled in the simulation parameters which\nhas been deprecated in favor of a per-profile social distance property.\n\nWould you like to convert this model to use the new social distancing method?");
                int option = JOptionPane.showConfirmDialog(MerlinApp.getApp().getMainFrame(), msg, Intl.intl("Use New Social Distancing Method?"), 1);
                if (option == 0) {
                    return true;
                }
                if (option == 1) {
                    return false;
                }
                throw new CancellationException();
            };
            MerlinIO.OpenResult result = io.openModel(parent, filename, showSkippableProgress, decisions);
            if (!backup.createBackupFile(filename)) {
                JOptionPane.showMessageDialog(parent, Intl.intl("Failed to create backup on open."), Intl.intl("Error Creating Backup"), 2);
            }
            if (result.warnings != null && !result.warnings.isEmpty()) {
                dlg = WarningDlg.create(parent, Intl.intl("File Open Warnings"), "", result.warnings);
                ((guiDialog)dlg).doModal();
            }
            result.data.filename = filename;
            dlg = result.data;
            return dlg;
        }
        catch (CancelledException e) {
            MerlinData decisions = null;
            return decisions;
        }
        catch (MerlinIO.BadVersionException e) {
            String msg = String.format(Intl.intl("Could not open file: %s"), filename);
            guiUtil.showError(parent, Intl.intl("File Error"), msg, (Throwable)e);
            MerlinData result = null;
            return result;
        }
        catch (IOException e) {
            String msg = String.format(Intl.intl("Could not open file: %s"), filename);
            File bakFile = backup.getBackupFile(filename);
            if (bakFile == null) {
                guiUtil.showError(parent, Intl.intl("File Error"), msg, (Throwable)e);
            } else {
                msg = guiUtil.formatError(msg, e);
                msg = msg + "\n";
                int option = JOptionPane.showConfirmDialog(parent, msg = msg + String.format(Intl.intl("Would you like to open the backup file, %s?"), bakFile.getAbsolutePath()), Intl.intl("Open Backup File?"), 0);
                if (option == 0) {
                    MerlinData merlinData = Open.openModel(parent, io, backup, bakFile.getAbsolutePath());
                    return merlinData;
                }
            }
            MerlinData merlinData = null;
            return merlinData;
        }
        finally {
            System.gc();
        }
    }
}

