/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3f;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.EditObjects;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.AssistedEvacTeam;
import merlin.data.AssistedEvacTeamComp;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INameGenerator;
import merlin.data.MerlinData;
import merlin.data.OccGroupTypeObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccProfileComp;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.agents.VehicleShapeComp;
import merlin.gui.AssistedEvacTeamsDlg;
import merlin.gui.ManagerDlg;
import merlin.gui.NewDlg;
import merlin.gui.OccGroupTypesDlg;
import merlin.gui.ProfilesDlg;
import merlin.gui.VehicleShapesDlg;
import merlin.util.MerlinUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Pair;

public class NewObject<T extends ICompElement>
extends AMerlinOp
implements IEventObserver {
    public static final NewObject<OccProfile> NEW_PROFILE_OP = new NewObject<OccProfile>(OccProfile.class, md -> md.profiles, md -> md.profNameGen, (mgr, obj) -> {
        ProfilesDlg dlg = new ProfilesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<OccProfile>)mgr, (OccProfile)obj);
        dlg.doModal();
    }, Intl.intl("New Profile"), OccProfile.PROP_NAME, OccProfileComp.class, md -> NewObject.newProfile(md));
    public static final UIHook UI_HOOK_PROFILE = new UIHook(NEW_PROFILE_OP, Intl.intl("Add a Profile..."));
    public static final UIHook UI_HOOK_VEHICLE_SHAPE = new UIHook(new NewObject<VehicleShape>(VehicleShape.class, md -> md.vehicleShapes, md -> md.vehicleShapeNameGen, (mgr, obj) -> {
        VehicleShapesDlg dlg = new VehicleShapesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getData(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<VehicleShape>)mgr, (VehicleShape)obj);
        dlg.doModal();
    }, Intl.intl("New Vehicle Shape"), VehicleShape.PROP_NAME, VehicleShapeComp.class, md -> new VehicleShape()), Intl.intl("Add a Vehicle Shape..."));
    public static final UIHook UI_HOOK_ASSISTED_EVAC_TEAM = new UIHook(new NewObject<AssistedEvacTeam>(AssistedEvacTeam.class, md -> md.assistedEvacTeams, md -> md.assistedEvacTeamNameGen, (mgr, obj) -> {
        AssistedEvacTeamsDlg dlg = new AssistedEvacTeamsDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (EditObjects.CompositeManager<?>)mgr, (AssistedEvacTeam)obj);
        dlg.doModal();
    }, Intl.intl("New Assisted Evacuation Team"), AssistedEvacTeam.PROP_NAME, AssistedEvacTeamComp.class, md -> new AssistedEvacTeam()), Intl.intl("Add an Assisted Evacuation Team..."));
    public static final UIHook UI_HOOK_OCCGROUP_TYPE = new UIHook(new NewObject<OccGroupTypeObj>(OccGroupTypeObj.class, md -> md.occGroupTypes, md -> md.occGroupTypeNameGen, (mgr, obj) -> {
        OccGroupTypesDlg dlg = new OccGroupTypesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (EditObjects.CompositeManager<?>)mgr, (OccGroupTypeObj)obj);
        dlg.doModal();
    }, Intl.intl("New Movement Group Template"), OccGroupTypeObj.PROP_NAME, OccGroupTypeObj.OccGroupTypeComp.class, md -> new OccGroupTypeObj()), Intl.intl("Add a Movement Group Template..."));
    private String d_newMsg;
    private Function<MerlinData, Composite<? super T>> d_getRoot;
    private Function<MerlinData, INameGenerator> d_getNameGenerator;
    private Class<T> d_clazz;
    private Object d_propName;
    private BiConsumer<EditObjects.CompositeManager<T>, T> d_createEditDlg;
    private Class<?> d_compClass;
    private Function<MerlinData, T> d_getNewObject;

    public static OccProfile newProfile(MerlinData md) {
        OccProfile prof = new OccProfile();
        Color c = MerlinUtil.newRandomOccColor();
        float[] cc = new float[3];
        c.getColorComponents(cc);
        prof.setProperty(OccProfile.PROP_COLOR, new Point3f(cc));
        return prof;
    }

    public NewObject(Class<T> clazz, Function<MerlinData, Composite<? super T>> getRoot, Function<MerlinData, INameGenerator> getNameGenerator, BiConsumer<EditObjects.CompositeManager<T>, T> createEditDlg, String newMsg, Object propName, Class<?> compClass, Function<MerlinData, T> getNewObject) {
        this.d_clazz = clazz;
        this.d_getRoot = getRoot;
        this.d_getNameGenerator = getNameGenerator;
        this.d_createEditDlg = createEditDlg;
        this.d_newMsg = newMsg;
        this.d_propName = propName;
        this.d_compClass = compClass;
        this.d_getNewObject = getNewObject;
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(md.selection.isSingleExclusive(this.d_compClass));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        this.add(app, md, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MerlinApp app, MerlinData md, boolean editAfter) {
        ICompElement newObj;
        Pair<String, T> newObjInfo;
        md.beginRead();
        try {
            newObjInfo = NewObject.promptForNewObject(app.getActiveFrame(), md, this.d_getNameGenerator.apply(md).getCurrentName(), this.d_getRoot.apply(md), this.d_clazz, this.d_newMsg, this.d_propName);
            if (newObjInfo == null) {
                return;
            }
        }
        finally {
            md.endRead();
        }
        md.beginWrite();
        try {
            Composite parent;
            Composite composite = parent = editAfter ? (Composite)md.selection.getSelected(Composite.class).iterator().next() : this.d_getRoot.apply(md);
            assert (parent != null);
            newObj = NewObject.newObj(md, (ICompElement)newObjInfo.v2, (String)newObjInfo.v1, this.d_clazz, this.d_newMsg, parent, this.d_getNameGenerator, this.d_getNewObject);
        }
        finally {
            md.endWrite();
        }
        if (editAfter) {
            EditObjects.editObject(app, md, newObj, this.d_propName, this.d_getRoot.apply(md), this.d_createEditDlg, this.d_clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ICompElement> T newObj(MerlinData md, T objBase, String name, Class<T> clazz, String newMsg, Composite<? super T> parent, Function<MerlinData, INameGenerator> getNameGenerator, Function<MerlinData, T> getNewObject) {
        ICompElement objNew = null;
        Undo.begin(Intl.intl(newMsg));
        try {
            objNew = objBase != null ? (ICompElement)objBase.clone() : (ICompElement)getNewObject.apply(md);
            objNew.setName(name);
            INameGenerator nameGenerator = getNameGenerator.apply(md);
            if (name.equals(nameGenerator.getCurrentName())) {
                nameGenerator.nextName();
            }
            AddObject.add((MerlinData)md, parent, (int)parent.getMembers().size(), (ICompElement[])new ICompElement[]{objNew});
        }
        catch (Throwable e) {
            assert (false);
        }
        finally {
            Undo.end(md);
        }
        return (T)objNew;
    }

    public static String promptForName(Component owner, MerlinData md, String initName, Composite<? extends ICompElement> group, Class<? extends ICompElement> clazz, String newMsg, Object propName) {
        Pair<String, ? extends ICompElement> result = NewObject.promptForNameOnEQ(md, owner, initName, NewObject.getInUseNames(md, group, propName), false, clazz, newMsg);
        return result != null ? (String)result.v1 : null;
    }

    public static <T extends IMerlinObj> Pair<String, T> promptForNewObject(Component owner, MerlinData md, String initName, Composite<? extends ICompElement> group, Class<T> clazz, String newMsg, Object propName) {
        return NewObject.promptForNameOnEQ(md, owner, initName, NewObject.getInUseNames(md, group, propName), true, clazz, newMsg);
    }

    private static <T extends IMerlinObj> Pair<String, T> promptForNameOnEQ(MerlinData md, final Component owner, final String initName, final Collection<String> inUse, final boolean newObject, final Class<T> clazz, final String newMsg) {
        Callable worker = new Callable<Pair<String, T>>(){

            @Override
            public Pair<String, T> call() throws Exception {
                return NewObject.promptForName(owner, initName, inUse, newObject, clazz, newMsg);
            }
        };
        return (Pair)md.ui(worker);
    }

    private static <T extends IMerlinObj> Pair<String, T> promptForName(Component owner, String initName, Collection<String> inUse, boolean newObject, Class<T> clazz, String newMsg) {
        String newName = null;
        Object baseObject = null;
        boolean valid = false;
        boolean same = false;
        boolean contained = true;
        do {
            String msg;
            if (newObject) {
                Window wowner = owner instanceof Window ? (Window)owner : SwingUtilities.getWindowAncestor(owner);
                NewDlg<T> dlg = new NewDlg<T>(wowner, MerlinApp.getApp().getData(), newMsg, initName, clazz);
                if (dlg.doModal() != 1) {
                    return null;
                }
                newName = dlg.getName();
                baseObject = dlg.getBaseObject();
            } else {
                newName = JOptionPane.showInputDialog(owner, Intl.intl("Name"), initName);
                if (newName == null) {
                    return null;
                }
            }
            valid = newName.length() > 0;
            same = initName.equals(newName);
            contained = inUse.contains(newName);
            if (!valid) {
                msg = Intl.intl("Please provide a name.");
                JOptionPane.showMessageDialog(owner, msg, Intl.intl("Invalid Entry"), 0);
                continue;
            }
            if (same || !contained) continue;
            msg = String.format(Intl.intl("The name \"%s\" is already in use."), newName);
            JOptionPane.showMessageDialog(owner, msg, Intl.intl("Invalid Entry"), 0);
        } while (!valid || !same && contained);
        return new Pair<String, Object>(newName, baseObject);
    }

    public static Set<String> getInUseNames(MerlinData md, Composite<? extends ICompElement> group, Object nameProp) {
        LinkedHashSet<String> inUse = new LinkedHashSet<String>();
        for (ICompElement ce : group.getMembers()) {
            inUse.add((String)ce.getProperty(nameProp));
        }
        return inUse;
    }
}

