/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.camera.CameraList;
import merlin.data.camera.IViewObj;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class CaptureCamera
extends AMerlinOp
implements IEventObserver {
    public static final UIHook CONTEXT_HOOK = new UIHook(new CaptureCamera(), Intl.intl("Update View,-,Updates the selected view(s) with the current state of the perspective view"));

    public CaptureCamera() {
        SelectionObserver.add(this, IViewObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(this.getEnabled());
    }

    private boolean getEnabled() {
        MerlinData md = MerlinApp.getApp().getData();
        return md.selection.isExclusive(IViewObj.class, CameraList.class);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginRead();
        ArrayList views = new ArrayList(md.selection.getDeepSelected(IViewObj.class));
        md.endRead();
        CaptureCamera.updateViews(app, md, views);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateViews(MerlinApp app, MerlinData md, Collection<? extends IViewObj> views) {
        CameraRecord state = md.ui(() -> {
            Camera cam = app.getModelView().getCamera(3);
            return cam.capture();
        });
        md.beginWrite();
        Undo.begin(Intl.intl("Update View"));
        try {
            IFilteredCollection<IRestorable> restorables = theUtil.filter(views, IRestorable.class);
            if (restorables.isExclusive()) {
                Undo.insertUndoEntry_restore(md, restorables);
            } else {
                Undo.insertEntry_breakChain(md);
            }
            for (IViewObj iViewObj : views) {
                iViewObj.setCameraState(state);
            }
        }
        finally {
            Undo.end(md);
            md.endWrite();
        }
    }
}

