/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis.rend;

import inferno.data2.ANode;
import inferno.data2.Tri;
import inferno.sim.KB;
import inferno.vis.GLView;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import javax.vecmath.Matrix4d;

public class RenderUtil {
    public static DoubleBuffer toGLTransform(Matrix4d xform) {
        DoubleBuffer buffer = ByteBuffer.allocateDirect(128).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        RenderUtil.toGLTransform(xform, buffer);
        return buffer;
    }

    public static DoubleBuffer toGLTransform(Matrix4d xform, DoubleBuffer buffer) {
        double[] temp = new double[4];
        for (int m = 0; m < 4; ++m) {
            xform.getColumn(m, temp);
            buffer.put(temp);
        }
        buffer.position(0);
        return buffer;
    }

    public static boolean isVisible(GLView view, KB kb, ANode room) {
        boolean animating = !view.getFilters().isFilteringAllOf(GLView.ANIMATION_FILTER.class);
        return !animating || room.getAnimationId() >= 0 || !view.getElevatorNodes(kb.getElevatorModel()).contains(room);
    }

    public static boolean isAnimating(GLView view, KB kb, ANode room) {
        boolean animating = !view.getFilters().isFilteringAllOf(GLView.ANIMATION_FILTER.class);
        return animating && room.getAnimationId() >= 0;
    }

    public static boolean isComponentVisible(GLView view, KB kb, Tri ... connectedTris) {
        for (Tri tri : connectedTris) {
            if (!RenderUtil.isVisible(view, kb, tri.node)) continue;
            return true;
        }
        return false;
    }

    public static Matrix4d getAnimXform(GLView view, KB kb, Tri ... connectedTris) {
        if (connectedTris.length == 0) {
            return null;
        }
        ANode node = connectedTris[0].node;
        for (int m = 1; m < connectedTris.length; ++m) {
            if (connectedTris[m].node == node) continue;
            return null;
        }
        return RenderUtil.isAnimating(view, kb, node) ? node.getAnimXform() : null;
    }
}

