/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis.rend;

import inferno.data2.SplitEdge;
import inferno.data2.WingedEdge;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.vis.GLView;
import inferno.vis.rend.IRenderer;
import inferno.vis.rend.RenderUtil;
import java.nio.DoubleBuffer;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.lwjgl.opengl.GL11;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;

public class RendWingedEdge
implements IRenderer<WingedEdge> {
    private static final Color3f bColorRoom = new Color3f(0.8f, 0.6f, 0.0f);
    private static final Color3f bColorStair = new Color3f(0.8f, 0.6f, 0.0f);
    private static final Color3f iColor = new Color3f(0.7f, 0.7f, 0.7f);
    private static final Color3f colorOpenDoor = new Color3f(0.9f, 0.7f, 0.0f);
    private static final Color3f colorClosedDoor = new Color3f(1.0f, 0.0f, 0.0f);
    private static final Color3f colorExit = new Color3f(0.2f, 1.0f, 0.2f);
    private static final Color3f trimmedColor = new Color3f(1.0f, 0.0f, 0.0f);
    private static final Color3f traversableColor = new Color3f(0.0f, 0.2f, 1.0f);
    private static final float bwidth = 4.0f;
    private static final float iwidth = 1.0f;
    private final DoubleBuffer d_matrixBuffer = RenderUtil.toGLTransform(GeomConstants.IDENTITY4d);

    private static OccAgent getSelectedAgent(KB kb) {
        for (OccAgent agent : kb.getActiveAgents()) {
            if (!agent.isSelected()) continue;
            return agent;
        }
        return null;
    }

    @Override
    public void renderOpaque(GLView view, KB kb, WingedEdge e) {
        OccAgent agent;
        boolean showTrimmed;
        Color3f color;
        float lwidth;
        if (!RenderUtil.isComponentVisible(view, kb, e.getAdjTris())) {
            return;
        }
        if (e.isBoundary()) {
            lwidth = 4.0f;
            color = e.t1 != null && e.t1.terrain.isStair() || e.t2 != null && e.t2.terrain.isStair() ? bColorStair : bColorRoom;
        } else if (e.isDoor()) {
            lwidth = 2.0f;
            color = e.data.node.isPhysicallyClosed() ? colorClosedDoor : (e.isExit() ? colorExit : colorOpenDoor);
        } else {
            if (view.getFilters().isFilteringAllOf(TRI_OUTLINE_FILTER.class)) {
                return;
            }
            lwidth = 1.0f;
            color = iColor;
        }
        GL11.glPushAttrib(4);
        GL11.glLineWidth(lwidth);
        GL11.glColor3d(color.x, color.y, color.z);
        Matrix4d animXform = RenderUtil.getAnimXform(view, kb, e.getAdjTris());
        if (animXform != null) {
            GL11.glPushMatrix();
            GL11.glMultMatrix(RenderUtil.toGLTransform(animXform, this.d_matrixBuffer));
        }
        GL11.glBegin(1);
        GL11.glVertex3d(e.base.n1.p.x, e.base.n1.p.y, e.base.n1.p.z);
        GL11.glVertex3d(e.base.n2.p.x, e.base.n2.p.y, e.base.n2.p.z);
        GL11.glEnd();
        boolean showTraversable = !view.getFilters().isFilteringAllOf(TRAVERSABLE_EDGE_FILTER.class);
        boolean bl = showTrimmed = !view.getFilters().isFilteringAllOf(TRIMMED_EDGE_FILTER.class);
        if (!e.isBoundary() && (showTraversable || showTrimmed) && (agent = RendWingedEdge.getSelectedAgent(kb)) != null) {
            SplitEdge[] sedges = kb.getMesh().getShortenedEdges(agent.getGeometryRadius());
            SplitEdge sedge = sedges[e.id];
            BiDoubleConsumer drawEdge = (t1, t2) -> {
                Point3d p1 = sedge.get(t1);
                Point3d p2 = sedge.get(t2);
                GL11.glVertex3d(p1.x, p1.y, p1.z);
                GL11.glVertex3d(p2.x, p2.y, p2.z);
            };
            if (showTraversable && sedge != null && sedge.isTravellable()) {
                GL11.glLineWidth(4.0f);
                GL11.glColor3d(RendWingedEdge.traversableColor.x, RendWingedEdge.traversableColor.y, RendWingedEdge.traversableColor.z);
                GL11.glBegin(1);
                for (int m = 0; m < sedge.splits.length; m += 2) {
                    drawEdge.accept(sedge.splits[m], sedge.splits[m + 1]);
                }
                GL11.glEnd();
            }
            if (showTrimmed && sedge != null) {
                GL11.glLineWidth(4.0f);
                GL11.glColor3d(RendWingedEdge.trimmedColor.x, RendWingedEdge.trimmedColor.y, RendWingedEdge.trimmedColor.z);
                GL11.glBegin(1);
                double prevt = 0.0;
                for (int m = 0; m < sedge.splits.length; m += 2) {
                    double nextt = sedge.splits[m];
                    if (prevt != nextt) {
                        drawEdge.accept(prevt, nextt);
                    }
                    prevt = sedge.splits[m + 1];
                }
                if (prevt != 1.0) {
                    drawEdge.accept(prevt, 1.0);
                }
                GL11.glEnd();
            }
        }
        if (animXform != null) {
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
    }

    @Override
    public void renderTranslucent(GLView view, KB kb, WingedEdge obj) {
    }

    @Override
    public AABox getBounds(WingedEdge e) {
        AABox bb = new AABox();
        bb.add(e.base.n1.p, e.base.n2.p);
        return bb;
    }

    private static interface BiDoubleConsumer {
        public void accept(double var1, double var3);
    }

    public static final class TRIMMED_EDGE_FILTER {
    }

    public static final class TRAVERSABLE_EDGE_FILTER {
    }

    public static final class TRI_OUTLINE_FILTER {
    }
}

