/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis.rend;

import inferno.data2.Vertex;
import inferno.sim.KB;
import inferno.vis.GLView;
import inferno.vis.rend.IRenderer;
import inferno.vis.rend.RenderUtil;
import java.nio.DoubleBuffer;
import javax.vecmath.Matrix4d;
import org.lwjgl.opengl.GL11;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;

public class RendVertex
implements IRenderer<Vertex> {
    private double sinArg = 0.0;
    private final DoubleBuffer d_matrixBuffer = RenderUtil.toGLTransform(GeomConstants.IDENTITY4d);

    @Override
    public AABox getBounds(Vertex obj) {
        return new AABox(obj.p, obj.p);
    }

    @Override
    public void renderOpaque(GLView view, KB kb, Vertex obj) throws Exception {
        if (!view.testFilter(VISIBLE.class)) {
            return;
        }
        if (!RenderUtil.isComponentVisible(view, kb, obj.t)) {
            return;
        }
        Matrix4d animXform = RenderUtil.getAnimXform(view, kb, obj.t);
        if (animXform != null) {
            GL11.glPushMatrix();
            GL11.glMultMatrix(RenderUtil.toGLTransform(animXform, this.d_matrixBuffer));
        }
        double mod = Math.abs(Math.sin(this.sinArg));
        GL11.glColor3d(mod, mod, mod);
        GL11.glPointSize(4.0f);
        GL11.glBegin(0);
        GL11.glVertex3d(obj.p.x, obj.p.y, obj.p.z);
        GL11.glEnd();
        if (animXform != null) {
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderTranslucent(GLView view, KB kb, Vertex obj) throws Exception {
    }

    public static final class VISIBLE {
    }
}

